/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.gui;

import com.oblivioussp.spartanweaponry.client.KeyBinds;
import com.oblivioussp.spartanweaponry.client.gui.AlignmentHelper;
import com.oblivioussp.spartanweaponry.client.gui.HudElement;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HudQuiverAmmo
extends HudElement {
    protected static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
    public static HudQuiverAmmo hudActive = null;
    protected ItemStack quiver = ItemStack.field_190927_a;

    public HudQuiverAmmo(int elementWidth, int elementHeight, ItemStack stackQuiver) {
        super(elementWidth, elementHeight);
        this.quiver = stackQuiver;
    }

    public void setQuiver(ItemStack stackQuiver) {
        this.quiver = stackQuiver;
    }

    @Override
    public void render() {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        if (this.quiver.func_190926_b() || mc.field_71439_g.func_175149_v()) {
            return;
        }
        ScaledResolution res = new ScaledResolution(mc);
        AlignmentHelper.Alignment align = ConfigHandler.quiverHudAlignment;
        int totalAmmo = 0;
        String ammoStr = "";
        if (!this.quiver.func_77942_o()) {
            return;
        }
        NBTTagList list = this.quiver.func_77978_p().func_150295_c("ClientInventory", 10);
        ItemStack stackToDraw = ItemStack.field_190927_a;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack item = new ItemStack(list.func_150305_b(i));
            if (stackToDraw.func_190926_b()) {
                stackToDraw = item.func_77946_l();
            }
            if (item.func_190926_b() || item.func_190916_E() == 0) continue;
            int ammo = item.func_190916_E();
            totalAmmo += ammo;
        }
        ammoStr = String.format("%d", totalAmmo);
        int offsetX = this.getAlignedX(align, ConfigHandler.quiverHudOffsetX, res);
        int offsetY = this.getAlignedY(align, ConfigHandler.quiverHudOffsetY, res);
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(WIDGETS);
        mc.field_71456_v.func_73729_b(offsetX, offsetY, 24, 23, 22, 22);
        if (!this.quiver.func_190926_b()) {
            mc.func_175599_af().func_180450_b(this.quiver, offsetX + 3, offsetY + 3);
        }
        GlStateManager.func_179097_i();
        font.func_175063_a(ammoStr, (float)(offsetX + 20 - font.func_78256_a(ammoStr)), (float)(offsetY + 13), totalAmmo == 0 ? 0xFF6060 : 0xFFC000);
        if (!KeyBinds.KEY_ACCESS_QUIVER.getDisplayName().equals("NONE")) {
            String inventoryKey = "[" + KeyBinds.KEY_ACCESS_QUIVER.getDisplayName().toUpperCase() + "]";
            int keyWidth = font.func_78256_a(inventoryKey);
            AlignmentHelper.VerticalAlignment vert = align.getVertical();
            AlignmentHelper.HorizontalAlignment horiz = align.getHorizontal();
            int keyTextXOffset = horiz == AlignmentHelper.HorizontalAlignment.RIGHT && keyWidth > 19 ? -keyWidth + 22 : (horiz == AlignmentHelper.HorizontalAlignment.LEFT && keyWidth > 19 && offsetX < 19 ? 0 : 11 - (int)((float)keyWidth / 2.0f));
            int keyTextYOffset = align.getVertical() == AlignmentHelper.VerticalAlignment.TOP ? 22 : -8;
            font.func_175063_a(inventoryKey, (float)(offsetX + keyTextXOffset), (float)(offsetY + keyTextYOffset), 0xFFFFFF);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
    }
}

