/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.render.IRenderBauble;
import com.oblivioussp.spartanweaponry.ModSpartanWeaponry;
import com.oblivioussp.spartanweaponry.capability.CapabilityProviderQuiver;
import com.oblivioussp.spartanweaponry.client.model.ModelQuiverBase;
import com.oblivioussp.spartanweaponry.item.ItemSW;
import com.oblivioussp.spartanweaponry.util.StringHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="baubles"), @Optional.Interface(iface="baubles.api.render.IRenderBauble", modid="baubles")})
public abstract class ItemQuiverBase
extends ItemSW
implements IBauble,
IRenderBauble {
    public static final String NBT_SIZE = "size";
    public static final String NBT_CURRENT_AMMO = "currentAmmo";
    public static final String NBT_TOTAL_AMMO = "totalAmmo";
    public static final String NBT_AMMO_COLLECT = "ammoCollect";
    public static final String NBT_OFFHAND_MOVED = "offhandMoved";
    public static final String NBT_ITEM_ID = "id";
    public static final String NBT_ITEM_SLOT = "slot";
    public static final String NBT_CLIENT_INVENTORY = "ClientInventory";
    @SideOnly(value=Side.CLIENT)
    protected ModelQuiverBase model;
    protected int guiIdQuiver = -1;
    protected int arrowSlots = 4;

    public ItemQuiverBase(String unlocName, int inventorySize) {
        super(unlocName);
        this.func_77625_d(1);
        this.arrowSlots = inventorySize;
        this.func_185043_a(new ResourceLocation("arrow"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return ItemQuiverBase.this.getArrowCount(stack);
            }
        });
    }

    protected int getArrowCount(ItemStack stack) {
        int arrows = 0;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = stack.func_77978_p().func_150295_c(NBT_CLIENT_INVENTORY, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack item = new ItemStack(list.func_150305_b(i));
            if (item.func_190926_b()) continue;
            ++arrows;
        }
        if (this.arrowSlots == 9) {
            if (arrows > 5) {
                arrows = 5;
            }
        } else if (arrows > 3) {
            arrows = 3;
        }
        return arrows;
    }

    public int getInventorySlots() {
        return this.arrowSlots;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new CapabilityProviderQuiver(stack, this.getInventorySlots());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            if (!playerIn.func_70093_af() && this.guiIdQuiver != -1) {
                IItemHandler handler;
                if (!heldItem.func_77942_o()) {
                    heldItem.func_77982_d(new NBTTagCompound());
                }
                if (!((handler = (IItemHandler)heldItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) instanceof ItemStackHandler)) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
                }
                SlotType slotType = handIn == EnumHand.MAIN_HAND ? SlotType.MAIN_HAND : SlotType.OFF_HAND;
                playerIn.openGui((Object)ModSpartanWeaponry.instance, this.guiIdQuiver, worldIn, slotType.ordinal(), -1, 0);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
            }
            if (playerIn.func_70093_af()) {
                if (!heldItem.func_77942_o()) {
                    heldItem.func_77982_d(new NBTTagCompound());
                }
                boolean ammoCollect = !heldItem.func_77978_p().func_74767_n(NBT_AMMO_COLLECT);
                heldItem.func_77978_p().func_74757_a(NBT_AMMO_COLLECT, ammoCollect);
                String collectStatus = ammoCollect ? "enabled" : "disabled";
                TextFormatting collectColour = ammoCollect ? TextFormatting.GREEN : TextFormatting.RED;
                String message = StringHelper.translateFormattedString("ammoCollectToggle", "message", "spartanweaponry", collectColour + StringHelper.translateString(collectStatus, "tooltip"));
                playerIn.func_146105_b((ITextComponent)new TextComponentString(message), true);
                return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
    }

    public boolean func_77651_p() {
        return true;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        NBTBase capTag = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.getStorage().writeNBT(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)handler, null);
        NBTTagCompound tag = super.getNBTShareTag(stack);
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (capTag != null) {
            tag.func_74782_a(NBT_CLIENT_INVENTORY, capTag);
        }
        return tag;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.addQuiverInventoryTooltip(stack, tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    protected void addQuiverInventoryTooltip(ItemStack stack, List<String> tooltip) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int itemCount = 0;
        tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateFormattedString("quiver_capacity", "tooltip", "spartanweaponry", TextFormatting.GRAY + "" + this.arrowSlots));
        boolean ammoCollect = stack.func_77978_p().func_74767_n(NBT_AMMO_COLLECT);
        String collectStatus = ammoCollect ? "enabled" : "disabled";
        TextFormatting statusColour = ammoCollect ? TextFormatting.GREEN : TextFormatting.RED;
        tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateFormattedString("quiver_collect_status", "tooltip", "spartanweaponry", statusColour + StringHelper.translateString(collectStatus, "tooltip")));
        tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateString("quiver_contains", "tooltip"));
        NBTTagList list = stack.func_77978_p().func_150295_c(NBT_CLIENT_INVENTORY, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack slotStack = new ItemStack(list.func_150305_b(i));
            if (slotStack.func_190926_b()) continue;
            if (itemCount < 2 || GuiScreen.func_146272_n()) {
                tooltip.add("  " + StringHelper.translateFormattedString("quiver_ammo", "tooltip", "spartanweaponry", slotStack.func_190916_E(), TextFormatting.AQUA + "" + slotStack.func_82833_r()));
            } else if (itemCount == 2) {
                tooltip.add(TextFormatting.DARK_GRAY + StringHelper.translateFormattedString("quiver_show_contents", "tooltip", "spartanweaponry", TextFormatting.AQUA + "SHIFT" + TextFormatting.DARK_GRAY));
            }
            ++itemCount;
        }
        if (itemCount == 0) {
            tooltip.add("  " + StringHelper.translateString("quiver_none", "tooltip"));
        }
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BODY;
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType type, float partialTicks) {
        if (type == IRenderBauble.RenderType.BODY) {
            int arrowsToRender = this.getArrowCount(stack);
            if (this.model == null) {
                this.model = this.initModel();
            }
            this.model.setArrowsToRender(arrowsToRender);
            if (Loader.isModLoaded((String)"mobends")) {
                Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)player);
                if (render instanceof RenderPlayer) {
                    RenderPlayer renderPlayer = (RenderPlayer)render;
                    renderPlayer.func_177087_b().field_78115_e.func_78794_c(0.0625f);
                }
                if (player.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.49f, (float)-0.0875f);
                } else {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
                }
            } else {
                IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
                GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture());
            this.model.render(0.0625f);
        }
    }

    public int getGuiId() {
        return this.guiIdQuiver;
    }

    public abstract ModelQuiverBase initModel();

    public abstract ResourceLocation getTexture();

    public abstract boolean isAmmoValid(ItemStack var1, ItemStack var2);

    public static enum SlotType {
        UNDEFINED,
        MAIN_HAND,
        OFF_HAND,
        HOTBAR,
        BAUBLE;

    }
}

