/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.network;

import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.network.PacketBase;
import com.oblivioussp.spartanweaponry.util.Log;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketLongReachAttack
extends PacketBase<PacketLongReachAttack> {
    private int entityId;
    private float velocity;

    public PacketLongReachAttack() {
    }

    public PacketLongReachAttack(int entId, float vel) {
        this.entityId = entId;
        this.velocity = vel;
        Log.trace("PacketLongReachAttack constructed");
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        this.velocity = buf.readFloat();
        Log.trace("Read data from byte buffer to packet.");
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.entityId, (int)4);
        buf.writeFloat(this.velocity);
        Log.trace("Wrote packet to byte buffer.");
    }

    @Override
    public void handleClientSide(PacketLongReachAttack message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketLongReachAttack message, EntityPlayerMP player) {
        if (message == null || player == null) {
            return;
        }
        Entity victim = player.field_70170_p.func_73045_a(message.entityId);
        if (victim == null) {
            return;
        }
        Log.debug("Victim of attack: " + victim.toString());
        ItemStack weapon = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (weapon.func_190926_b()) {
            return;
        }
        if (weapon.func_77973_b() instanceof IWeaponPropertyContainer) {
            WeaponProperty reachProp = ((IWeaponPropertyContainer)weapon.func_77973_b()).getFirstWeaponPropertyWithType("reach");
            if (reachProp != null) {
                float reach = reachProp.getMagnitude();
                double distanceSquared = player.func_70068_e(victim);
                double reachSquared = reach * reach;
                player.getEntityData().func_74776_a("spartanweaponry_RidingVelocity", message.velocity);
                if (reachSquared >= distanceSquared) {
                    player.func_71059_n(victim);
                    Log.debug("Attacking victim!");
                }
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            player.func_184821_cY();
        }
    }
}

