/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTHelper {
    protected static void initNBTCompound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public static void setBoolean(ItemStack stack, String tag, boolean value) {
        NBTHelper.initNBTCompound(stack);
        stack.func_77978_p().func_74757_a(tag, value);
    }

    public static void setInteger(ItemStack stack, String tag, int value) {
        NBTHelper.initNBTCompound(stack);
        stack.func_77978_p().func_74768_a(tag, value);
    }

    public static void setFloat(ItemStack stack, String tag, float value) {
        NBTHelper.initNBTCompound(stack);
        stack.func_77978_p().func_74776_a(tag, value);
    }

    public static void setDouble(ItemStack stack, String tag, double value) {
        NBTHelper.initNBTCompound(stack);
        stack.func_77978_p().func_74780_a(tag, value);
    }

    public static void setString(ItemStack stack, String tag, String value) {
        NBTHelper.initNBTCompound(stack);
        stack.func_77978_p().func_74778_a(tag, value);
    }

    public static void setTagCompound(ItemStack stack, String tag, NBTTagCompound value) {
        NBTHelper.initNBTCompound(stack);
        stack.func_77978_p().func_74782_a(tag, (NBTBase)value);
    }

    public static NBTTagList saveItemStacksAsList(List<ItemStack> stacks) {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : stacks) {
            if (stack == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stack.func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        return list;
    }

    public static boolean getBoolean(ItemStack stack, String tag) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b(tag)) {
            return false;
        }
        return stack.func_77978_p().func_74767_n(tag);
    }

    public static int getInteger(ItemStack stack, String tag) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b(tag)) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(tag);
    }

    public static float getFloat(ItemStack stack, String tag) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b(tag)) {
            return 0.0f;
        }
        return stack.func_77978_p().func_74760_g(tag);
    }

    public static double getDouble(ItemStack stack, String tag) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b(tag)) {
            return 0.0;
        }
        return stack.func_77978_p().func_74769_h(tag);
    }

    public static String getString(ItemStack stack, String tag) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b(tag)) {
            return "";
        }
        return stack.func_77978_p().func_74779_i(tag);
    }

    public static NBTTagCompound getTagCompound(ItemStack stack, String tag) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b(tag)) {
            return null;
        }
        return stack.func_77978_p().func_74775_l(tag);
    }

    public static ItemStack[] retrieveItemStacksFromList(NBTTagList list) {
        ItemStack[] result = new ItemStack[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            result[i] = new ItemStack(stackTag);
        }
        return result;
    }
}

