/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import baubles.api.BaublesApi;
import com.oblivioussp.spartanweaponry.ModSpartanWeaponry;
import com.oblivioussp.spartanweaponry.init.OreDictionarySW;
import com.oblivioussp.spartanweaponry.item.ItemBolt;
import com.oblivioussp.spartanweaponry.item.ItemCrossbow;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;

public class QuiverHelper {
    public static final int SLOT_BODY = 5;
    public static List<IQuiverInfo> info = new ArrayList<IQuiverInfo>();

    public static ItemStack findFirstOfType(EntityPlayer player, IQuiverInfo info) {
        ItemStack bauble;
        if (ModSpartanWeaponry.isBaublesLoaded && !(bauble = QuiverHelper.findFromBauble(player)).func_190926_b() && info.isQuiver(bauble)) {
            return bauble;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !info.isQuiver(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack findFirst(EntityPlayer player) {
        ItemStack bauble;
        if (ModSpartanWeaponry.isBaublesLoaded && !(bauble = QuiverHelper.findFromBauble(player)).func_190926_b() && OreDictionarySW.matches("spartanweaponry:quivers", bauble)) {
            return bauble;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !OreDictionarySW.matches("spartanweaponry:quivers", stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> findValidQuivers(EntityPlayer player) {
        ItemStack bauble;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (ModSpartanWeaponry.isBaublesLoaded && !(bauble = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(5)).func_190926_b() && OreDictionarySW.matches("spartanweaponry:quivers", bauble)) {
            result.add(bauble);
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !OreDictionarySW.matches("spartanweaponry:quivers", stack)) continue;
            result.add(stack);
        }
        return result;
    }

    public static ItemStack findFromBauble(EntityPlayer player) {
        return BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(5);
    }

    public static boolean isInBaublesSlot(EntityPlayer player, ItemStack stack) {
        return BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(5).func_77969_a(stack);
    }

    static {
        info.add(new IQuiverInfo(){

            @Override
            public boolean isQuiver(ItemStack stack) {
                return OreDictionarySW.matches("spartanweaponry:bolt_quivers", stack);
            }

            @Override
            public boolean isWeapon(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemCrossbow;
            }

            @Override
            public boolean isAmmo(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemBolt;
            }
        });
        info.add(new IQuiverInfo(){

            @Override
            public boolean isQuiver(ItemStack stack) {
                return OreDictionarySW.matches("spartanweaponry:arrow_quivers", stack);
            }

            @Override
            public boolean isWeapon(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemBow;
            }

            @Override
            public boolean isAmmo(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemArrow;
            }
        });
    }

    public static interface IQuiverInfo {
        public boolean isQuiver(ItemStack var1);

        public boolean isWeapon(ItemStack var1);

        public boolean isAmmo(ItemStack var1);
    }
}

