/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.api;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AetherRegistryEntry<T extends IForgeRegistryEntry<T>>
implements IForgeRegistryEntry<T> {
    private ResourceLocation registryName = null;

    public T setRegistryName(String name) {
        String prefix;
        if (this.getRegistryName() != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
        }
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index);
        name = index == -1 ? name : name.substring(index + 1);
        ModContainer mc = Loader.instance().activeModContainer();
        String string = prefix = mc == null || mc instanceof InjectedModContainer && ((InjectedModContainer)mc).wrappedContainer instanceof FMLContainer ? "minecraft" : mc.getModId().toLowerCase();
        if (!oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            prefix = oldPrefix;
        }
        this.registryName = new ResourceLocation(prefix, name);
        return (T)this;
    }

    public final T setRegistryName(ResourceLocation name) {
        return this.setRegistryName(name.toString());
    }

    public final T setRegistryName(String modID, String name) {
        return this.setRegistryName(modID + ":" + name);
    }

    public final ResourceLocation getRegistryName() {
        return this.registryName != null ? this.registryName : null;
    }

    public final Class<T> getRegistryType() {
        return this.getClass();
    }
}

