/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.client.renders.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AetherStateMap
extends StateMapperBase {
    private final IProperty<?> name;
    private final String suffix;
    private final List<IProperty<?>> ignored;

    private AetherStateMap(@Nullable IProperty<?> name, @Nullable String suffix, List<IProperty<?>> ignored) {
        this.name = name;
        this.suffix = suffix;
        this.ignored = ignored;
    }

    public ModelResourceLocation func_178132_a(IBlockState state) {
        LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
        String s = this.name == null ? ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString() : String.format("%s:%s", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).func_110624_b(), this.removeName(this.name, map));
        if (this.suffix != null) {
            s = s + this.suffix;
        }
        for (IProperty<?> iproperty : this.ignored) {
            map.remove(iproperty);
        }
        return new ModelResourceLocation(s, this.func_178131_a(map));
    }

    private <T extends Comparable<T>> String removeName(IProperty<T> property, Map<IProperty<?>, Comparable<?>> values) {
        return property.func_177702_a(values.remove(this.name));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Builder {
        private IProperty<?> name;
        private String suffix;
        private final List<IProperty<?>> ignored = Lists.newArrayList();

        public Builder withName(IProperty<?> builderPropertyIn) {
            this.name = builderPropertyIn;
            return this;
        }

        public Builder withSuffix(String builderSuffixIn) {
            this.suffix = builderSuffixIn;
            return this;
        }

        public Builder ignore(IProperty<?> ... ignores) {
            Collections.addAll(this.ignored, ignores);
            return this;
        }

        public AetherStateMap build() {
            return new AetherStateMap(this.name, this.suffix, this.ignored);
        }
    }
}

