/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.bosses.slider;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.util.IAetherBoss;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.dungeon.BlockDungeonBase;
import com.gildedgames.the_aether.blocks.util.EnumStoneType;
import com.gildedgames.the_aether.entities.util.AetherNameGen;
import com.gildedgames.the_aether.registry.AetherLootTables;
import com.gildedgames.the_aether.registry.sounds.SoundsAether;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySlider
extends EntityFlying
implements IAetherBoss {
    public static final DataParameter<String> SLIDER_NAME = EntityDataManager.func_187226_a(EntitySlider.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Boolean> SLIDER_AWAKE = EntityDataManager.func_187226_a(EntitySlider.class, (DataSerializer)DataSerializers.field_187198_h);
    private int dungeonX;
    private int dungeonY;
    private int dungeonZ;
    private int[] doorStart = new int[3];
    private int[] doorEnd = new int[3];
    public float hurtAngle;
    public float hurtAngleX;
    public float hurtAngleZ;
    public int chatTime;
    public int moveTime;
    public boolean isMoving;
    public boolean crushedBlock;
    public float velocity;
    public EnumFacing direction;

    public EntitySlider(World world) {
        super(world);
        this.func_70105_a(2.0f, 2.0f);
        this.field_70125_A = 0.0f;
        this.field_70177_z = 0.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
        this.func_70606_j(500.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70165_t = Math.floor(this.field_70165_t + 0.5);
        this.field_70163_u = Math.floor(this.field_70163_u + 0.5);
        this.field_70161_v = Math.floor(this.field_70161_v + 0.5);
        this.field_70180_af.func_187214_a(SLIDER_AWAKE, (Object)false);
        this.field_70180_af.func_187214_a(SLIDER_NAME, (Object)String.valueOf(AetherNameGen.gen()));
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.isAwake()) {
            super.func_70091_d(type, x, y, z);
        } else {
            super.func_70091_d(type, 0.0, 0.0, 0.0);
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187674_a;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187902_gb;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("dungeonX", this.dungeonX);
        nbttagcompound.func_74768_a("dungeonY", this.dungeonY);
        nbttagcompound.func_74768_a("dungeonZ", this.dungeonZ);
        nbttagcompound.func_74783_a("doorStart", this.doorStart);
        nbttagcompound.func_74783_a("doorEnd", this.doorEnd);
        nbttagcompound.func_74757_a("isAwake", this.isAwake());
        nbttagcompound.func_74778_a("bossName", this.getBossName());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.dungeonX = nbttagcompound.func_74762_e("dungeonX");
        this.dungeonY = nbttagcompound.func_74762_e("dungeonY");
        this.dungeonZ = nbttagcompound.func_74762_e("dungeonZ");
        this.doorStart = nbttagcompound.func_74759_k("doorStart");
        this.doorEnd = nbttagcompound.func_74759_k("doorEnd");
        this.setAwake(nbttagcompound.func_74767_n("isAwake"));
        this.setBossName(nbttagcompound.func_74779_i("bossName"));
    }

    public boolean criticalCondition() {
        return this.func_110143_aJ() <= 80.0f;
    }

    public void func_70071_h_() {
        int i1 = MathHelper.func_76128_c((double)this.field_70165_t);
        int j1 = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k1 = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos position = new BlockPos(i1, j1, k1);
        if (this.field_70123_F && !this.isMoving && !this.field_70170_p.func_175623_d(position.func_177977_b()) && !this.crushedBlock) {
            this.field_70181_x = 1.2f;
        }
        this.evapWater();
        if (this.hurtAngle > 0.01f) {
            this.hurtAngle *= 0.8f;
        }
        if (this.chatTime > 0) {
            --this.chatTime;
        }
        super.func_70071_h_();
        this.field_70177_z = 0.0f;
        this.field_70125_A = 0.0f;
        this.field_70761_aq = 0.0f;
        if (!this.isAwake()) {
            this.func_70624_b(null);
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null || this.func_70638_az().field_70128_L || this.func_70638_az().func_110143_aJ() <= 0.0f) {
                this.reset();
                return;
            }
            if (this.isMoving) {
                if (this.field_70132_H) {
                    double x = this.field_70165_t - 0.5;
                    double y = this.func_174813_aQ().field_72338_b + 0.75;
                    double z = this.field_70161_v - 0.5;
                    this.crushedBlock = false;
                    if (y < 124.0 && y > 4.0) {
                        if (this.direction == EnumFacing.UP) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock((BlockPos)new BlockPos.MutableBlockPos().func_189532_c(x + a, y + 1.5, z + b));
                            }
                        } else if (this.direction == EnumFacing.DOWN) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock((BlockPos)new BlockPos.MutableBlockPos().func_189532_c(x + a, y - 1.5, z + b));
                            }
                        } else if (this.direction == EnumFacing.EAST) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock((BlockPos)new BlockPos.MutableBlockPos().func_189532_c(x + 1.5, y + a, z + b));
                            }
                        } else if (this.direction == EnumFacing.WEST) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock((BlockPos)new BlockPos.MutableBlockPos().func_189532_c(x - 1.5, y + a, z + b));
                            }
                        } else if (this.direction == EnumFacing.SOUTH) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock((BlockPos)new BlockPos.MutableBlockPos().func_189532_c(x + a, y + b, z + 1.5));
                            }
                        } else if (this.direction == EnumFacing.NORTH) {
                            for (int i = 0; i < 25; ++i) {
                                double a = (double)(i / 5 - 2) * 0.75;
                                double b = (double)(i % 5 - 2) * 0.75;
                                this.destroyBlock((BlockPos)new BlockPos.MutableBlockPos().func_189532_c(x + a, y + b, z - 1.5));
                            }
                        }
                    }
                    if (this.crushedBlock) {
                        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.HOSTILE, 3.0f, (0.625f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsAether.slider_collide, SoundCategory.HOSTILE, 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    }
                    this.stop();
                } else {
                    if (this.velocity < 2.0f) {
                        this.velocity += this.criticalCondition() ? 0.07f : 0.035f;
                    }
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    if (this.direction == EnumFacing.UP) {
                        this.field_70181_x = this.velocity;
                        if (this.func_174813_aQ().field_72338_b > this.func_70638_az().func_174813_aQ().field_72338_b + 0.35) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    } else if (this.direction == EnumFacing.DOWN) {
                        this.field_70181_x = -this.velocity;
                        if (this.func_174813_aQ().field_72338_b < this.func_70638_az().func_174813_aQ().field_72338_b - 0.25) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    } else if (this.direction == EnumFacing.EAST) {
                        this.field_70159_w = this.velocity;
                        if (this.field_70165_t > this.func_70638_az().field_70165_t + 0.125) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    } else if (this.direction == EnumFacing.WEST) {
                        this.field_70159_w = -this.velocity;
                        if (this.field_70165_t < this.func_70638_az().field_70165_t - 0.125) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    } else if (this.direction == EnumFacing.SOUTH) {
                        this.field_70179_y = this.velocity;
                        if (this.field_70161_v > this.func_70638_az().field_70161_v + 0.125) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    } else if (this.direction == EnumFacing.NORTH) {
                        this.field_70179_y = -this.velocity;
                        if (this.field_70161_v < this.func_70638_az().field_70161_v - 0.125) {
                            this.stop();
                            this.moveTime = this.criticalCondition() ? 4 : 8;
                        }
                    }
                }
            } else if (this.moveTime > 0) {
                --this.moveTime;
                if (this.criticalCondition() && this.field_70146_Z.nextInt(2) == 0) {
                    --this.moveTime;
                }
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            } else {
                if (this.func_70638_az() == null) {
                    return;
                }
                double a = Math.abs(this.field_70165_t - this.func_70638_az().field_70165_t);
                double b = Math.abs(this.func_174813_aQ().field_72338_b - this.func_70638_az().func_174813_aQ().field_72338_b);
                double c = Math.abs(this.field_70161_v - this.func_70638_az().field_70161_v);
                if (a > c) {
                    this.direction = EnumFacing.EAST;
                    if (this.field_70165_t > this.func_70638_az().field_70165_t) {
                        this.direction = EnumFacing.WEST;
                    }
                } else {
                    this.direction = EnumFacing.SOUTH;
                    if (this.field_70161_v > this.func_70638_az().field_70161_v) {
                        this.direction = EnumFacing.NORTH;
                    }
                }
                if (b > a && b > c || b > 0.25 && this.field_70146_Z.nextInt(5) == 0) {
                    this.direction = EnumFacing.UP;
                    if (this.field_70163_u > this.func_70638_az().field_70163_u) {
                        this.direction = EnumFacing.DOWN;
                    }
                }
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsAether.slider_move, SoundCategory.HOSTILE, 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.isMoving = true;
            }
        }
    }

    public void evapWater() {
        int var1 = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72340_a + (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a) / 2.0));
        int var2 = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72339_c + (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c) / 2.0));
        int radius = 2;
        for (int var4 = var1 - radius; var4 <= var1 + radius; ++var4) {
            for (int var5 = var2 - radius; var5 <= var2 + radius; ++var5) {
                for (int var6 = 0 + this.field_70146_Z.nextInt(2); var6 < 8; ++var6) {
                    double var7 = this.field_70163_u + (double)var6;
                    if (!(this.field_70170_p.func_180495_p(new BlockPos((double)var4, var7, (double)var5)) instanceof BlockLiquid)) continue;
                    this.field_70170_p.func_175656_a(new BlockPos((double)var4, var7, (double)var5), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    private void destroyBlock(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == BlocksAether.locked_dungeon_block || state.func_177230_c().func_176195_g(state, this.field_70170_p, pos) < 0.0f) {
            return;
        }
        Aether.proxy.spawnBlockBrokenFX(state, pos);
        state.func_177230_c().func_180663_b(this.field_70170_p, pos, state);
        state.func_177230_c().func_176226_b(this.field_70170_p, pos, state, 0);
        this.field_70170_p.func_175698_g(pos);
        this.crushedBlock = true;
        Aether.proxy.spawnSmoke(this.field_70170_p, pos);
    }

    private boolean checkIsAir(int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList blockList = Lists.newArrayListWithCapacity((int)9);
        for (BlockPos position : BlockPos.func_191532_a((int)x1, (int)y1, (int)z1, (int)x2, (int)y2, (int)z2)) {
            blockList.add(this.field_70170_p.func_180495_p(position).func_177230_c());
        }
        HashSet blockSet = new HashSet(blockList);
        if (blockSet.size() == 1) {
            return blockList.get(1) == Blocks.field_150350_a;
        }
        return false;
    }

    private void openDoor() {
        if (this.doorStart.length > 0 && this.doorEnd.length > 0) {
            for (int x = this.doorStart[0]; x < this.doorEnd[0] + 1; ++x) {
                for (int y = this.doorStart[1]; y < this.doorEnd[1] + 1; ++y) {
                    for (int z = this.doorStart[2]; z < this.doorEnd[2] + 1; ++z) {
                        this.field_70170_p.func_175656_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
    }

    private void closeDoor() {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (!this.checkIsAir(this.dungeonX + 15, this.dungeonY + 1, this.dungeonZ + 6, this.dungeonX + 15, this.dungeonY + 4, this.dungeonZ + 9)) break block8;
                        this.doorStart = new int[]{this.dungeonX + 15, this.dungeonY + 1, this.dungeonZ + 6};
                        this.doorEnd = new int[]{this.dungeonX + 15, this.dungeonY + 4, this.dungeonZ + 9};
                        int x = this.dungeonX + 15;
                        for (int y = this.dungeonY + 1; y < this.dungeonY + 8; ++y) {
                            for (int z = this.dungeonZ + 5; z < this.dungeonZ + 11; ++z) {
                                this.field_70170_p.func_175656_a(new BlockPos(x, y, z), BlocksAether.locked_dungeon_block.func_176223_P());
                            }
                        }
                        break block9;
                    }
                    if (!this.checkIsAir(this.dungeonX, this.dungeonY + 1, this.dungeonZ + 6, this.dungeonX, this.dungeonY + 4, this.dungeonZ + 9)) break block10;
                    this.doorStart = new int[]{this.dungeonX, this.dungeonY + 1, this.dungeonZ + 6};
                    this.doorEnd = new int[]{this.dungeonX, this.dungeonY + 4, this.dungeonZ + 9};
                    int x = this.dungeonX;
                    for (int y = this.dungeonY + 1; y < this.dungeonY + 8; ++y) {
                        for (int z = this.dungeonZ + 5; z < this.dungeonZ + 11; ++z) {
                            this.field_70170_p.func_175656_a(new BlockPos(x, y, z), BlocksAether.locked_dungeon_block.func_176223_P());
                        }
                    }
                    break block9;
                }
                if (!this.checkIsAir(this.dungeonX + 6, this.dungeonY + 1, this.dungeonZ + 15, this.dungeonX + 9, this.dungeonY + 4, this.dungeonZ + 15)) break block11;
                this.doorStart = new int[]{this.dungeonX + 6, this.dungeonY + 1, this.dungeonZ + 15};
                this.doorEnd = new int[]{this.dungeonX + 9, this.dungeonY + 4, this.dungeonZ + 15};
                int z = this.dungeonZ + 15;
                for (int y = this.dungeonY + 1; y < this.dungeonY + 8; ++y) {
                    for (int x = this.dungeonX + 5; x < this.dungeonX + 11; ++x) {
                        this.field_70170_p.func_175656_a(new BlockPos(x, y, z), BlocksAether.locked_dungeon_block.func_176223_P());
                    }
                }
                break block9;
            }
            if (!this.checkIsAir(this.dungeonX + 6, this.dungeonY + 1, this.dungeonZ, this.dungeonX + 9, this.dungeonY + 4, this.dungeonZ)) break block9;
            this.doorStart = new int[]{this.dungeonX + 6, this.dungeonY + 1, this.dungeonZ};
            this.doorEnd = new int[]{this.dungeonX + 9, this.dungeonY + 4, this.dungeonZ};
            int z = this.dungeonZ;
            for (int y = this.dungeonY + 1; y < this.dungeonY + 8; ++y) {
                for (int x = this.dungeonX + 5; x < this.dungeonX + 11; ++x) {
                    this.field_70170_p.func_175656_a(new BlockPos(x, y, z), BlocksAether.locked_dungeon_block.func_176223_P());
                }
            }
        }
    }

    public void func_70108_f(Entity entity) {
        boolean flag;
        if (this.isAwake() && this.isMoving && (flag = entity.func_70097_a((DamageSource)new EntityDamageSource("crush", (Entity)this), 6.0f)) && entity instanceof EntityLivingBase) {
            EntityLivingBase collidedEntity = (EntityLivingBase)entity;
            collidedEntity.func_70024_g(collidedEntity.field_70181_x, 0.35, collidedEntity.field_70179_y);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsAether.slider_collide, SoundCategory.HOSTILE, 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.stop();
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190916_E() != 0 && stack.func_77973_b() != null) {
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
            entityitem.func_184224_h(true);
            entityitem.func_174869_p();
            if (this.captureDrops) {
                this.capturedDrops.add(entityitem);
            } else {
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            return entityitem;
        }
        return null;
    }

    public void stop() {
        this.isMoving = false;
        this.moveTime = 12;
        this.direction = EnumFacing.UP;
        this.velocity = 0.0f;
        this.field_70181_x = this.field_70179_y = (double)0.0f;
        this.field_70159_w = this.field_70179_y;
    }

    private void sendMessage(EntityPlayer player, ITextComponent s) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.chatTime <= 0) {
            if (side.isClient()) {
                Aether.proxy.sendMessage(player, s);
            }
            this.chatTime = 60;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        double c;
        double a;
        if (source.func_76364_f() == null || !(source.func_76364_f() instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)source.func_76364_f();
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151034_e) {
            this.sendMessage(player, (ITextComponent)new TextComponentTranslation("gui.slider.apple", new Object[0]));
            return false;
        }
        if (!source.func_180136_u() && source.func_76346_g().func_70032_d((Entity)this) > 6.0f && !this.isAwake()) {
            this.sendMessage(player, (ITextComponent)new TextComponentTranslation("gui.slider.far", new Object[0]));
            return false;
        }
        boolean isTCPickaxe = stack.func_77973_b().getClass().getName().equals("slimeknights.tconstruct.tools.tools.Pickaxe");
        if (!stack.func_77973_b().func_150897_b(Blocks.field_150348_b.func_176223_P()) && !isTCPickaxe) {
            this.sendMessage(player, (ITextComponent)new TextComponentTranslation("gui.slider.notpickaxe", new Object[0]));
            return false;
        }
        boolean flag = super.func_70097_a(source, Math.max(0.0f, amount));
        if (flag) {
            for (int j = 0; j < (this.func_110143_aJ() <= 0.0f ? 2 : 4); ++j) {
                double a2 = this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 1.5;
                double b = this.func_174813_aQ().field_72338_b + 1.75;
                double c2 = this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 1.5;
                if (this.func_110143_aJ() <= 0.0f) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, a2, b, c2, 0.0, 0.0, 0.0, new int[0]);
                }
                Aether.proxy.spawnBlockBrokenFX(Blocks.field_150348_b.func_176223_P(), new BlockPos(a2, b, c2));
            }
            if (this.func_110143_aJ() <= 0.0f || this.field_70128_L) {
                this.openDoor();
                this.unlockBlock(new BlockPos(this.dungeonX, this.dungeonY, this.dungeonZ));
                IBlockState state = Blocks.field_150415_aT.func_176223_P();
                this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX + 7, this.dungeonY + 1, this.dungeonZ + 7), state.func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.SOUTH), 2);
                this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX + 8, this.dungeonY + 1, this.dungeonZ + 7), state.func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.SOUTH), 2);
                this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX + 7, this.dungeonY + 1, this.dungeonZ + 8), state.func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.NORTH), 2);
                this.field_70170_p.func_180501_a(new BlockPos(this.dungeonX + 8, this.dungeonY + 1, this.dungeonZ + 8), state.func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.NORTH), 2);
                AetherAPI.getInstance().get(player).setFocusedBoss(null);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsAether.slider_death, SoundCategory.HOSTILE, 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.field_70128_L = true;
            }
            if (!this.isAwake()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsAether.slider_awaken, SoundCategory.HOSTILE, 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.func_70624_b((EntityLivingBase)player);
                this.closeDoor();
                this.setAwake(true);
            }
            if (this.isMoving) {
                this.velocity *= 0.75f;
            }
        }
        if ((a = Math.abs(this.field_70165_t - player.field_70165_t)) > (c = Math.abs(this.field_70161_v - player.field_70161_v))) {
            this.hurtAngleZ = 1.0f;
            this.hurtAngleX = 0.0f;
            if (this.field_70165_t > player.field_70165_t) {
                this.hurtAngleZ = -1.0f;
            }
        } else {
            this.hurtAngleX = 1.0f;
            this.hurtAngleZ = 0.0f;
            if (this.field_70161_v > player.field_70161_v) {
                this.hurtAngleX = -1.0f;
            }
        }
        this.hurtAngle = 0.7f - this.func_110143_aJ() / 875.0f;
        AetherAPI.getInstance().get(player).setFocusedBoss(this);
        return flag;
    }

    private void unlockBlock(BlockPos pos) {
        IBlockState blockState = this.field_70170_p.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block == BlocksAether.locked_dungeon_block) {
            this.field_70170_p.func_180501_a(pos, BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.getType(block.func_176201_c(blockState)))), 2);
            this.unlockBlock(pos.func_177974_f());
            this.unlockBlock(pos.func_177976_e());
            this.unlockBlock(pos.func_177984_a());
            this.unlockBlock(pos.func_177977_b());
            this.unlockBlock(pos.func_177968_d());
            this.unlockBlock(pos.func_177978_c());
        }
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.func_70108_f(entity);
            }
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.dungeonX == 0 && this.dungeonY == 0 && this.dungeonZ == 0) {
            this.setDungeon(this.field_70165_t - 8.0, this.field_70163_u - 2.0, this.field_70161_v - 8.0);
        }
        if (this.getBossName().isEmpty()) {
            this.setBossName(AetherNameGen.gen());
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70024_g(double d, double d1, double d2) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
    }

    public void func_70653_a(Entity par1Entity, float par2, double par3, double par5) {
    }

    public void reset() {
        this.moveTime = 0;
        this.stop();
        this.openDoor();
        this.setAwake(false);
        this.func_70624_b(null);
        this.func_70606_j(this.func_110138_aP());
        this.func_70634_a(this.dungeonX + 8, this.dungeonY + 2, this.dungeonZ + 8);
    }

    public void setDungeon(double posX, double posY, double posZ) {
        this.dungeonX = (int)posX;
        this.dungeonY = (int)posY;
        this.dungeonZ = (int)posZ;
    }

    public void setBossName(String name) {
        this.field_70180_af.func_187227_b(SLIDER_NAME, (Object)name);
    }

    public String getBossName() {
        return (String)this.field_70180_af.func_187225_a(SLIDER_NAME);
    }

    @Override
    public String getBossTitle() {
        return this.getBossName() + ", " + new TextComponentTranslation("title.aether_legacy.slider.name", new Object[0]).func_150254_d();
    }

    public void setAwake(boolean isAwake) {
        this.field_70180_af.func_187227_b(SLIDER_AWAKE, (Object)isAwake);
    }

    public boolean isAwake() {
        return (Boolean)this.field_70180_af.func_187225_a(SLIDER_AWAKE);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    @Override
    public float getBossHealth() {
        return this.func_110143_aJ();
    }

    @Override
    public float getMaxBossHealth() {
        return this.func_110138_aP();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return AetherLootTables.slider;
    }

    public boolean func_90999_ad() {
        return false;
    }
}

