/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.hostile;

import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.dungeon.BlockDungeonBase;
import com.gildedgames.the_aether.blocks.util.EnumStoneType;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySentry
extends EntityLiving
implements IMob {
    public static final DataParameter<Boolean> SENTRY_AWAKE = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187198_h);
    public float timeSpotted;
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;

    public EntitySentry(World world) {
        super(world);
        this.field_70765_h = new SlimeMoveHelper(this);
        this.func_70105_a(1.0f, 1.0f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_70606_j(this.func_110138_aP());
    }

    public EntitySentry(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISlimeFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimeAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISlimeFaceRandom(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISlimeHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindEntityNearest((EntityLiving)this, EntityIronGolem.class));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SENTRY_AWAKE, (Object)false);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("wasOnGround", this.wasOnGround);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.wasOnGround = tagCompund.func_74767_n("wasOnGround");
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_187882_fq;
    }

    public void func_70071_h_() {
        EntityPlayer entityplayer;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.field_70128_L = true;
        }
        if ((entityplayer = this.field_70170_p.func_72890_a((Entity)this, 8.0)) != null) {
            if (!this.isAwake()) {
                if (this.timeSpotted >= 24.0f) {
                    this.setAwake(true);
                }
                this.timeSpotted += 1.0f;
            }
        } else {
            this.setAwake(false);
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            this.func_184185_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    protected EntitySentry createInstance() {
        return new EntitySentry(this.field_70170_p);
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (!(entityIn instanceof EntitySentry) && entityIn instanceof EntityLivingBase) {
            this.explode((EntityLivingBase)entityIn);
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        this.explode((EntityLivingBase)entityIn);
    }

    protected void explode(EntityLivingBase entity) {
        if (this.isAwake() && this.func_70685_l((Entity)entity) && entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f) && this.field_70173_aa > 20) {
            entity.func_70024_g(0.5, 0.5, 0.5);
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.1f, false);
            this.func_70106_y();
            this.func_70606_j(0.0f);
            this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_174815_a((EntityLivingBase)this, (Entity)entity);
        }
    }

    public void setAwake(boolean isAwake) {
        this.field_70180_af.func_187227_b(SENTRY_AWAKE, (Object)isAwake);
    }

    public boolean isAwake() {
        return (Boolean)this.field_70180_af.func_187225_a(SENTRY_AWAKE);
    }

    public float func_70047_e() {
        return 0.625f * this.field_70131_O;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187882_fq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187882_fq;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected void func_70664_aZ() {
        if (this.isAwake()) {
            this.field_70181_x = 0.42f;
            this.field_70160_al = true;
        }
    }

    protected void func_70628_a(boolean var1, int var2) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            Block block = BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Sentry)).func_177230_c();
            this.func_70099_a(new ItemStack(block), 0.0f);
        } else {
            this.func_70099_a(new ItemStack(BlocksAether.dungeon_block), 0.0f);
        }
    }

    static class SlimeMoveHelper
    extends EntityMoveHelper {
        private float field_179922_g;
        private int field_179924_h;
        private EntitySentry slime;
        private boolean field_179923_j;

        public SlimeMoveHelper(EntitySentry p_i45821_1_) {
            super((EntityLiving)p_i45821_1_);
            this.slime = p_i45821_1_;
        }

        public void func_179920_a(float p_179920_1_, boolean p_179920_2_) {
            this.field_179922_g = p_179920_1_;
            this.field_179923_j = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.field_179922_g, 30.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_75648_a.field_70122_E) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (this.field_179924_h-- <= 0) {
                    this.field_179924_h = this.slime.getJumpDelay();
                    if (this.field_179923_j) {
                        this.field_179924_h /= 3;
                    }
                    this.slime.func_70683_ar().func_75660_a();
                    this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                } else {
                    this.slime.field_191988_bg = 0.0f;
                    this.slime.field_70702_br = 0.0f;
                    this.field_75648_a.func_70659_e(0.0f);
                }
            } else {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
            }
        }
    }

    static class AISlimeHop
    extends EntityAIBase {
        private EntitySentry slime;

        public AISlimeHop(EntitySentry p_i45822_1_) {
            this.slime = p_i45822_1_;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class AISlimeFloat
    extends EntityAIBase {
        private EntitySentry slime;

        public AISlimeFloat(EntitySentry p_i45823_1_) {
            this.slime = p_i45823_1_;
            this.func_75248_a(5);
            ((PathNavigateGround)p_i45823_1_.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.slime.func_70090_H() || this.slime.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class AISlimeFaceRandom
    extends EntityAIBase {
        private EntitySentry slime;
        private float field_179459_b;
        private int field_179460_c;

        public AISlimeFaceRandom(EntitySentry p_i45820_1_) {
            this.slime = p_i45820_1_;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab());
        }

        public void func_75246_d() {
            if (--this.field_179460_c <= 0) {
                this.field_179460_c = 40 + this.slime.func_70681_au().nextInt(60);
                this.field_179459_b = this.slime.func_70681_au().nextInt(360);
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).func_179920_a(this.field_179459_b, false);
        }
    }

    static class AISlimeAttack
    extends EntityAIBase {
        private EntitySentry slime;
        private int field_179465_b;

        public AISlimeAttack(EntitySentry p_i45824_1_) {
            this.slime = p_i45824_1_;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (!this.slime.isAwake()) {
                return false;
            }
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a);
        }

        public void func_75249_e() {
            this.field_179465_b = 300;
            super.func_75249_e();
        }

        public boolean continueExecuting() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a ? false : --this.field_179465_b > 0));
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((SlimeMoveHelper)this.slime.func_70605_aq()).func_179920_a(this.slime.field_70177_z, true);
        }
    }
}

