/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world;

import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.natural.BlockHolystone;
import com.gildedgames.the_aether.registry.AetherLootTables;
import com.gildedgames.the_aether.world.dungeon.BronzeDungeon;
import com.gildedgames.the_aether.world.dungeon.util.AetherDungeonVirtual;
import com.gildedgames.the_aether.world.gen.MapGenGoldenDungeon;
import com.gildedgames.the_aether.world.gen.MapGenLargeColdAercloud;
import com.gildedgames.the_aether.world.gen.MapGenQuicksoil;
import com.gildedgames.the_aether.world.gen.MapGenSilverDungeon;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class ChunkProviderAether
implements IChunkGenerator {
    private Random rand;
    private World worldObj;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves perlinNoise1;
    private double[] buffer;
    double[] pnr;
    double[] ar;
    double[] br;
    protected AetherDungeonVirtual dungeon_bronze = new BronzeDungeon();
    private MapGenQuicksoil quicksoilGen = new MapGenQuicksoil();
    private MapGenSilverDungeon silverDungeonStructure = new MapGenSilverDungeon();
    private MapGenGoldenDungeon goldenDungeonStructure = new MapGenGoldenDungeon();
    private MapGenLargeColdAercloud largeColdAercloudStructure = new MapGenLargeColdAercloud();

    public ChunkProviderAether(World world, long seed) {
        this.worldObj = world;
        this.rand = new Random(seed);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer chunkPrimer) {
        this.buffer = this.setupNoiseGenerators(this.buffer, x * 2, z * 2);
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int j1 = 0; j1 < 2; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d1 = this.buffer[(i1 * 3 + j1) * 33 + k1];
                    double d2 = this.buffer[(i1 * 3 + (j1 + 1)) * 33 + k1];
                    double d3 = this.buffer[((i1 + 1) * 3 + j1) * 33 + k1];
                    double d4 = this.buffer[((i1 + 1) * 3 + (j1 + 1)) * 33 + k1];
                    double d5 = (this.buffer[(i1 * 3 + j1) * 33 + (k1 + 1)] - d1) * 0.25;
                    double d6 = (this.buffer[(i1 * 3 + (j1 + 1)) * 33 + (k1 + 1)] - d2) * 0.25;
                    double d7 = (this.buffer[((i1 + 1) * 3 + j1) * 33 + (k1 + 1)] - d3) * 0.25;
                    double d8 = (this.buffer[((i1 + 1) * 3 + (j1 + 1)) * 33 + (k1 + 1)] - d4) * 0.25;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.125;
                        double d13 = (d4 - d2) * 0.125;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.125;
                            for (int k2 = 0; k2 < 8; ++k2) {
                                int x1 = i2 + i1 * 8;
                                int y = l1 + k1 * 4;
                                int z1 = k2 + j1 * 8;
                                IBlockState filler = Blocks.field_150350_a.func_176223_P();
                                if (d15 > 0.0) {
                                    filler = BlocksAether.holystone.func_176223_P();
                                }
                                chunkPrimer.func_177855_a(x1, y, z1, filler);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void buildSurfaces(int i, int j, ChunkPrimer chunkPrimer, Biome[] biomesIn) {
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                Biome biome = biomesIn[k + l * 16];
                int j1 = -1;
                int i1 = (int)(3.0 + this.rand.nextDouble() * 0.25);
                IBlockState top = biome.field_76752_A;
                IBlockState filler = biome.field_76753_B;
                for (int k1 = 127; k1 >= 0; --k1) {
                    Block block = chunkPrimer.func_177856_a(k, k1, l).func_177230_c();
                    if (block == Blocks.field_150350_a) {
                        j1 = -1;
                        continue;
                    }
                    if (block != BlocksAether.holystone) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            top = Blocks.field_150350_a.func_176223_P();
                            filler = BlocksAether.holystone.func_176223_P();
                        }
                        j1 = i1;
                        if (k1 >= 0) {
                            chunkPrimer.func_177855_a(k, k1, l, top);
                            continue;
                        }
                        chunkPrimer.func_177855_a(k, k1, l, filler);
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    chunkPrimer.func_177855_a(k, k1, l, filler);
                }
            }
        }
    }

    private double[] setupNoiseGenerators(double[] buffer, int x, int z) {
        if (buffer == null) {
            buffer = new double[3366];
        }
        double d = 1368.824;
        double d1 = 684.412;
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, x, 0, z, 3, 33, 3, d / 80.0, d1 / 160.0, d / 80.0);
        this.ar = this.noiseGen1.func_76304_a(this.ar, x, 0, z, 3, 33, 3, d, d1, d);
        this.br = this.noiseGen1.func_76304_a(this.br, x, 0, z, 3, 33, 3, d, d1, d);
        int id = 0;
        for (int j2 = 0; j2 < 3; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                for (int j3 = 0; j3 < 33; ++j3) {
                    double d10 = this.ar[id] / 512.0;
                    double d11 = this.br[id] / 512.0;
                    double d12 = (this.pnr[id] / 10.0 + 1.0) / 2.0;
                    double d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= 8.0;
                    if (j3 > 1) {
                        double d13 = (float)(j3 - 1) / 31.0f;
                        d8 = d8 * (1.0 - d13) + -30.0 * d13;
                    }
                    if (j3 < 8) {
                        double d14 = (float)(8 - j3) / 7.0f;
                        d8 = d8 * (1.0 - d14) + -30.0 * d14;
                    }
                    buffer[id] = d8;
                    ++id;
                }
            }
        }
        return buffer;
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        Biome[] biomesForGeneration = new Biome[]{};
        biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(biomesForGeneration, x * 16, z * 16, 16, 16);
        this.setBlocksInChunk(x, z, chunkPrimer);
        this.buildSurfaces(x, z, chunkPrimer, biomesForGeneration);
        this.quicksoilGen.func_186125_a(this.worldObj, x, z, chunkPrimer);
        this.largeColdAercloudStructure.func_186125_a(this.worldObj, x, z, chunkPrimer);
        this.silverDungeonStructure.func_186125_a(this.worldObj, x, z, chunkPrimer);
        this.goldenDungeonStructure.func_186125_a(this.worldObj, x, z, chunkPrimer);
        Chunk chunk = new Chunk(this.worldObj, chunkPrimer, x, z);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)Biome.func_185362_a((Biome)biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.worldObj.func_72959_q().func_180631_a(pos);
        return biome != null ? biome.func_76747_a(creatureType) : null;
    }

    public boolean func_185933_a(Chunk chunkIn, int chunkX, int chunkZ) {
        return false;
    }

    public void func_180514_a(Chunk p_180514_1_, int x, int z) {
        this.largeColdAercloudStructure.func_186125_a(this.worldObj, x, z, null);
        this.silverDungeonStructure.func_186125_a(this.worldObj, x, z, null);
        this.goldenDungeonStructure.func_186125_a(this.worldObj, x, z, null);
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        if ("SilverDungeon".equals(structureName) && this.silverDungeonStructure != null) {
            return this.silverDungeonStructure.func_175795_b(pos);
        }
        if ("GoldDungeon".equals(structureName) && this.goldenDungeonStructure != null) {
            return this.goldenDungeonStructure.func_175795_b(pos);
        }
        return false;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        BlockPos whoops = new BlockPos(position.func_177958_n() + 20, position.func_177956_o(), position.func_177952_p() + 20);
        if ("SilverDungeon".equals(structureName) && this.silverDungeonStructure != null) {
            return this.silverDungeonStructure.func_180706_b(worldIn, whoops, findUnexplored);
        }
        if ("GoldDungeon".equals(structureName) && this.goldenDungeonStructure != null) {
            return this.goldenDungeonStructure.func_180706_b(worldIn, whoops, findUnexplored);
        }
        return null;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        Biome biome = this.worldObj.func_180494_b(pos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.worldObj.func_72905_C());
        this.largeColdAercloudStructure.func_175794_a(this.worldObj, this.rand, chunkpos);
        this.silverDungeonStructure.func_175794_a(this.worldObj, this.rand, chunkpos);
        this.goldenDungeonStructure.func_175794_a(this.worldObj, this.rand, chunkpos);
        this.generateBronzeDungeon(pos);
        biome.func_180624_a(this.worldObj, this.rand, pos);
        WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biome, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
    }

    private void generateBronzeDungeon(BlockPos pos) {
        this.dungeon_bronze.func_180709_b(this.worldObj, this.rand, pos.func_177982_a(0, this.rand.nextInt(48) + 24, 0));
        this.dungeon_bronze.storeVariables();
        Map<BlockPos, IBlockState> placementSelection = this.dungeon_bronze.getPlacement();
        Map<BlockPos, IBlockState> replacementSelection = this.dungeon_bronze.getReplacement();
        Map<BlockPos, IBlockState> tunnelSelection = this.dungeon_bronze.getTunnel();
        for (Map.Entry<BlockPos, IBlockState> placement : placementSelection.entrySet()) {
            if (!this.worldObj.func_175667_e(placement.getKey()) || placement.getValue() == null) continue;
            if ((this.worldObj.func_180495_p(placement.getKey()).func_177230_c() != BlocksAether.dungeon_block && this.worldObj.func_180495_p(placement.getKey()).func_177230_c() != BlocksAether.locked_dungeon_block || placement.getValue().func_177230_c() != BlocksAether.holystone && placement.getValue().func_177230_c() != BlocksAether.mossy_holystone && placement.getValue().func_177230_c() != Blocks.field_150350_a) && (placement.getValue().func_177230_c() != BlocksAether.holystone && placement.getValue().func_177230_c() != BlocksAether.mossy_holystone || this.worldObj.func_180495_p(placement.getKey()).func_177230_c() != Blocks.field_150350_a)) {
                this.worldObj.func_180501_a(placement.getKey(), placement.getValue(), 18);
            }
            this.dungeon_bronze.placementStorage.remove(placement.getKey(), placement.getValue());
            this.dungeon_bronze.placement.remove(placement.getKey(), placement.getValue());
            placementSelection.remove(placement.getKey(), placement.getValue());
        }
        for (Map.Entry<BlockPos, IBlockState> placement : replacementSelection.entrySet()) {
            if (!this.worldObj.func_175667_e(placement.getKey()) || placement.getValue() == null) continue;
            this.worldObj.func_180501_a(placement.getKey(), placement.getValue(), 18);
            if (placement.getValue().func_177230_c() == BlocksAether.dungeon_chest) {
                Random lootRandom = new Random();
                TileEntityChest chest = (TileEntityChest)this.worldObj.func_175625_s(placement.getKey());
                chest.func_189404_a(AetherLootTables.bronze_dungeon_chest, lootRandom.nextLong());
            }
            this.dungeon_bronze.replacementStorage.remove(placement.getKey(), placement.getValue());
            this.dungeon_bronze.replacement.remove(placement.getKey(), placement.getValue());
            replacementSelection.remove(placement.getKey(), placement.getValue());
        }
        for (Map.Entry<BlockPos, IBlockState> tunnel : tunnelSelection.entrySet()) {
            if (!this.worldObj.func_175667_e(tunnel.getKey()) || tunnel.getValue() == null) continue;
            if (this.worldObj.func_180495_p(tunnel.getKey()).func_177230_c() != Blocks.field_150350_a && this.worldObj.func_180495_p(tunnel.getKey()).func_177230_c() != BlocksAether.dungeon_block && this.worldObj.func_180495_p(tunnel.getKey()).func_177230_c() != BlocksAether.locked_dungeon_block && this.worldObj.func_180495_p(tunnel.getKey()).func_177230_c() != BlocksAether.dungeon_trap && this.worldObj.func_180495_p(tunnel.getKey()).func_177230_c() != BlocksAether.dungeon_chest && this.worldObj.func_180495_p(tunnel.getKey()) != BlocksAether.holystone.func_176223_P().func_177226_a((IProperty)BlockHolystone.dungeon_block, (Comparable)Boolean.valueOf(true)) && this.worldObj.func_180495_p(tunnel.getKey()) != BlocksAether.mossy_holystone.func_176223_P().func_177226_a((IProperty)BlockHolystone.dungeon_block, (Comparable)Boolean.valueOf(true)) && this.worldObj.func_180495_p(tunnel.getKey()).func_177230_c() != BlocksAether.aether_leaves && this.worldObj.func_180495_p(tunnel.getKey()).func_177230_c() != BlocksAether.crystal_leaves && this.worldObj.func_180495_p(tunnel.getKey()).func_177230_c() != BlocksAether.holiday_leaves && this.worldObj.func_180495_p(tunnel.getKey()).func_177230_c() != BlocksAether.aether_log && this.worldObj.func_180495_p(tunnel.getKey()).func_177230_c() != BlocksAether.aercloud) {
                this.worldObj.func_180501_a(tunnel.getKey(), tunnel.getValue(), 18);
            }
            this.dungeon_bronze.tunnelStorage.remove(tunnel.getKey(), tunnel.getValue());
            this.dungeon_bronze.tunnel.remove(tunnel.getKey(), tunnel.getValue());
            tunnelSelection.remove(tunnel.getKey(), tunnel.getValue());
        }
    }
}

