/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util.resource;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.sky.RenderSkybox;
import hellfirepvp.astralsorcery.client.util.TexturePreloader;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;

public class AssetLibrary
implements IResourceManagerReloadListener {
    public static AssetLibrary resReloadInstance = new AssetLibrary();
    public static boolean reloading = false;
    private static Map<AssetLoader.SubLocation, Map<String, BindableResource>> loadedTextures = new HashMap<AssetLoader.SubLocation, Map<String, BindableResource>>();

    private AssetLibrary() {
    }

    public static BindableResource loadTexture(AssetLoader.TextureLocation location, String name) {
        if (name.endsWith(".png")) {
            throw new IllegalArgumentException("Tried to loadTexture with appended .png from the AssetLibrary!");
        }
        Map resources = loadedTextures.computeIfAbsent(location, l -> new HashMap());
        if (resources.containsKey(name)) {
            return (BindableResource)resources.get(name);
        }
        BindableResource res = AssetLoader.load(AssetLoader.AssetLocation.TEXTURES, location, name, ".png");
        resources.put(name, res);
        return res;
    }

    public void func_110549_a(@Nullable IResourceManager resourceManager) {
        if (reloading) {
            return;
        }
        reloading = true;
        AstralSorcery.log.info("[AssetLibrary] Refreshing and Invalidating Resources");
        for (Map<String, BindableResource> map : loadedTextures.values()) {
            for (BindableResource res : map.values()) {
                res.invalidateAndReload();
            }
        }
        reloading = false;
        AstralSorcery.log.info("[AssetLibrary] Finished reloading, rebinding textures...");
        TexturePreloader.doPreloadRoutine();
        RenderSkybox.resetAstralSkybox();
        AstralSorcery.log.info("[AssetLibrary] Successfully reloaded and rebound library.");
    }
}

