/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.GameStageTweaks;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;

public class PerkLevelManager
extends ConfigEntry {
    private static int LEVEL_CAP = 30;
    public static final PerkLevelManager INSTANCE = new PerkLevelManager();
    private Map<Integer, Long> totalExpLevelRequired = new HashMap<Integer, Long>();

    private PerkLevelManager() {
        super(ConfigEntry.Section.PERK_LEVELS, "level");
    }

    private void ensureLevels() {
        if (this.totalExpLevelRequired.isEmpty()) {
            for (int i = 1; i <= LEVEL_CAP; ++i) {
                long prev = this.totalExpLevelRequired.getOrDefault(i - 1, 0L);
                this.totalExpLevelRequired.put(i, prev + 150L + MathHelper.func_76124_d((double)Math.pow(2.0, i / 2 + 3)));
            }
        }
    }

    public int getLevel(double totalExp, EntityPlayer player) {
        return this.getLevel(MathHelper.func_76124_d((double)totalExp), player);
    }

    private int getLevel(long totalExp, EntityPlayer player) {
        this.ensureLevels();
        if (totalExp <= 0L) {
            return 1;
        }
        int levelCap = PerkLevelManager.getLevelCapFor(player);
        for (int i = 1; i <= levelCap; ++i) {
            if (totalExp >= this.totalExpLevelRequired.getOrDefault(i, Long.MAX_VALUE)) continue;
            return i;
        }
        return levelCap;
    }

    public long getExpForLevel(int level, EntityPlayer player) {
        this.ensureLevels();
        if (level <= 1) {
            return 0L;
        }
        int levelCap = PerkLevelManager.getLevelCapFor(player);
        if (level > levelCap) {
            level = levelCap;
        }
        return this.totalExpLevelRequired.get(level);
    }

    public float getNextLevelPercent(double totalExp, EntityPlayer player) {
        this.ensureLevels();
        int level = this.getLevel(totalExp, player);
        if (level >= LEVEL_CAP) {
            return 1.0f;
        }
        long nextLevel = this.totalExpLevelRequired.getOrDefault(level, 0L);
        long prevLevel = this.totalExpLevelRequired.getOrDefault(level - 1, 0L);
        return (float)(totalExp - (double)prevLevel) / (float)(nextLevel - prevLevel);
    }

    public static int getLevelCapFor(EntityPlayer player) {
        if (Mods.GAMESTAGES.isPresent() && Mods.CRAFTTWEAKER.isPresent()) {
            return PerkLevelManager.resolveLevelCap(player);
        }
        return LEVEL_CAP;
    }

    @Optional.Method(modid="gamestages")
    private static int resolveLevelCap(EntityPlayer player) {
        if (player == null) {
            return LEVEL_CAP;
        }
        int highestFound = -1;
        IStageData data = GameStageHelper.getPlayerData((EntityPlayer)player);
        if (data == null) {
            return LEVEL_CAP;
        }
        for (String stage : data.getStages()) {
            int cap = GameStageTweaks.getMaxCap(stage);
            if (cap <= highestFound) continue;
            highestFound = cap;
        }
        return highestFound > -1 ? highestFound : LEVEL_CAP;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        this.totalExpLevelRequired.clear();
        LEVEL_CAP = cfg.getInt(this.getKey() + "Cap", this.getConfigurationSection(), LEVEL_CAP, 1, 100, "Sets the max level for the perk tree levels.");
    }
}

