/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.attribute;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AttributeTypeLimiter {
    public static final AttributeTypeLimiter INSTANCE = new AttributeTypeLimiter();
    private static final Tuple<Float, Float> NONE = new Tuple<Object, Object>(null, null);
    private static final Tuple<Float, Float> ANY = new Tuple<Float, Float>(Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    private static Map<PerkAttributeType, Tuple<Float, Float>> perkTypeLimits = Maps.newHashMap();

    private AttributeTypeLimiter() {
    }

    void putLimit(PerkAttributeType type, float lower, float upper) {
        perkTypeLimits.put(type, new Tuple<Float, Float>(Float.valueOf(lower), Float.valueOf(upper)));
    }

    @Nullable
    public Float getMaxLimit(PerkAttributeType type) {
        return (Float)AttributeTypeLimiter.perkTypeLimits.getOrDefault((Object)type, AttributeTypeLimiter.NONE).value;
    }

    @SubscribeEvent
    public void onProcess(AttributeEvent.PostProcessVanilla ev) {
        PerkAttributeType type = ev.resolveAttributeType();
        if (type != null) {
            this.checkValue(type, (float)ev.getValue(), ev::setValue);
        }
    }

    @SubscribeEvent
    public void onProcess(AttributeEvent.PostProcessModded ev) {
        this.checkValue(ev.getType(), (float)ev.getValue(), ev::setValue);
    }

    private void checkValue(PerkAttributeType type, float value, Consumer<Float> setValue) {
        Tuple<Float, Float> limit = perkTypeLimits.getOrDefault(type, ANY);
        setValue.accept(Float.valueOf(MathHelper.func_76131_a((float)value, (float)((Float)limit.key).floatValue(), (float)((Float)limit.value).floatValue())));
    }
}

