/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entities;

import com.google.common.collect.Iterables;
import hellfirepvp.astralsorcery.common.container.ContainerObservatory;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileObservatory;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityObservatoryHelper
extends Entity {
    private static DataParameter<BlockPos> FIXED = EntityDataManager.func_187226_a(EntityObservatoryHelper.class, (DataSerializer)DataSerializers.field_187200_j);

    public EntityObservatoryHelper(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.0f, 0.0f);
        this.field_70178_ae = true;
    }

    public EntityObservatoryHelper(World world, BlockPos fixedPos) {
        super(world);
        this.func_70105_a(0.0f, 0.0f);
        this.field_70180_af.func_187227_b(FIXED, (Object)fixedPos);
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FIXED, (Object)BlockPos.field_177992_a);
    }

    public BlockPos getFixedObservatoryPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(FIXED);
    }

    @Nullable
    public TileObservatory tryGetObservatory() {
        return MiscUtils.getTileAt((IBlockAccess)this.field_70170_p, this.getFixedObservatoryPos(), TileObservatory.class, false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70145_X = true;
        TileObservatory to = this.isOnTelescope();
        if (to == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return;
        }
        List passengers = this.func_184188_bt();
        if (!to.isUsable()) {
            passengers.forEach(Entity::func_184210_p);
            return;
        }
        Entity riding = (Entity)Iterables.getFirst((Iterable)passengers, null);
        if (riding != null && riding instanceof EntityPlayer) {
            this.applyObservatoryRotationsFrom(to, (EntityPlayer)riding);
        }
    }

    public void applyObservatoryRotationsFrom(TileObservatory to, EntityPlayer riding) {
        if (riding.field_71070_bA != null && riding.field_71070_bA instanceof ContainerObservatory) {
            this.field_70177_z = riding.field_70759_as;
            this.field_70126_B = riding.field_70758_at;
            this.field_70125_A = riding.field_70125_A;
            this.field_70127_C = riding.field_70127_C;
        } else {
            this.field_70177_z = riding.field_70761_aq;
            this.field_70126_B = riding.field_70760_ar;
        }
        to.updatePitchYaw(this.field_70125_A, this.field_70127_C, this.field_70177_z, this.field_70126_B);
    }

    @Nullable
    private TileObservatory isOnTelescope() {
        BlockPos fixed = this.getFixedObservatoryPos();
        TileObservatory to = MiscUtils.getTileAt((IBlockAccess)this.field_70170_p, fixed, TileObservatory.class, true);
        if (to == null) {
            return null;
        }
        UUID helper = to.getEntityHelperRef();
        if (helper == null || !helper.equals(this.field_96093_i)) {
            return null;
        }
        return to;
    }

    protected boolean func_184228_n(Entity entityIn) {
        if (!super.func_184228_n(entityIn)) {
            return false;
        }
        TileObservatory to = this.isOnTelescope();
        return to != null && to.isUsable();
    }

    public boolean func_174814_R() {
        return true;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_184202_aL() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_180427_aV() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_191953_am() {
        return true;
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((Block)BlocksAS.blockObservatory);
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }

    public boolean func_184186_bw() {
        return false;
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }
}

