/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.common.item.scuba.ItemScubaHelmet;
import net.tropicraft.core.common.item.scuba.ScubaCapabilities;
import net.tropicraft.core.common.item.scuba.api.IScubaGear;
import net.tropicraft.core.common.item.scuba.api.IScubaTank;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ScubaOverlayHandler
extends Gui {
    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        float airRemaining = -1.0f;
        float timeRemaining = 0.0f;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (helmet == null || !(helmet.func_77973_b() instanceof ItemScubaHelmet)) {
            return;
        }
        ItemStack chestplate = player.func_184582_a(EntityEquipmentSlot.CHEST);
        IScubaGear gear = chestplate != null ? (IScubaGear)chestplate.getCapability(ScubaCapabilities.getGearCapability(), null) : null;
        int maxDepth = this.getTagCompound(helmet).func_74762_e("MaxDepth");
        int blocksAbove = this.getTagCompound(helmet).func_74762_e("WaterBlocksAbove");
        int blocksBelow = this.getTagCompound(helmet).func_74762_e("WaterBlocksBelow");
        if (gear != null) {
            airRemaining = gear.getTotalPressure();
            timeRemaining += this.getTimeRemaining((IScubaTank)gear.getTanks().getLeft());
            timeRemaining += this.getTimeRemaining((IScubaTank)gear.getTanks().getRight());
        }
        float airTemp = player.field_70170_p.getBiomeForCoordsBody(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), 0, MathHelper.func_76128_c((double)player.field_70161_v))).func_180626_a(player.func_180425_c());
        float yaw = player.field_70177_z;
        int size = 100;
        int offset = -size / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(sr.func_78326_a() + offset - 20), (float)120.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(yaw + 180.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TropicraftRenderUtils.getTextureGui("compass_background"));
        ScubaOverlayHandler.func_146110_a((int)offset, (int)offset, (float)0.0f, (float)0.0f, (int)size, (int)size, (float)size, (float)size);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        if (gear != null) {
            this.func_73731_b(fr, "psi", sr.func_78326_a() - 50, 48, 0xFFFFFF);
            this.func_73731_b(fr, "Air", sr.func_78326_a() - 75, 34, 0xFFFFFF);
        }
        GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.0f);
        if (gear != null) {
            String psi = String.format("%.0f", Float.valueOf(airRemaining));
            this.func_73731_b(fr, psi, (int)((float)(sr.func_78326_a() - 50) / 1.5f) - fr.func_78256_a(psi) - 1, 30, 52446);
        }
        this.func_73731_b(fr, TropicraftRenderUtils.translateGUI("currentDepth") + ": " + blocksAbove, 4, 70, 0xBBBBFF);
        GlStateManager.func_179121_F();
        this.func_73731_b(fr, TropicraftRenderUtils.translateGUI("maxDepth") + ": " + maxDepth, 6, 130, -1);
        this.func_73731_b(fr, airTemp * 50.0f + " F", 6, 150, -1);
        if (gear != null) {
            String time = DurationFormatUtils.formatDuration((long)((long)(timeRemaining * 1000.0f) / 60L * 60L), (String)"H' hr 'm' mins'");
            this.func_73731_b(fr, TropicraftRenderUtils.translateGUI("timeRemaining"), 6, 34, 0xFFFFFF);
            this.func_73731_b(fr, time, 6, 45, 16182034);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private float getTimeRemaining(IScubaTank tank) {
        if (tank != null) {
            return tank.getPressure() / tank.getAirType().getUsageRate();
        }
        return 0.0f;
    }

    private NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

