/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.client.gui.GuiTropicsLoading;
import net.tropicraft.core.common.dimension.TropicraftWorldUtils;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class TropicraftLoadingListener {
    private Minecraft mc = FMLClientHandler.instance().getClient();
    private int lastDimension = 0;
    private ArrayList<Pair<String, Integer>> farewellSkipDimensions = new ArrayList();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase.equals((Object)TickEvent.Phase.END) && this.mc.field_71439_g != null) {
            this.lastDimension = this.mc.field_71439_g.field_71093_bK;
        }
    }

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent evt) {
        if (evt.getGui() instanceof GuiDownloadTerrain && FMLClientHandler.instance().getClientPlayHandler() instanceof NetHandlerPlayClient && this.mc.field_71439_g != null) {
            GuiTropicsLoading guiLoading = new GuiTropicsLoading();
            boolean isLeaving = false;
            if (this.lastDimension != TropicraftWorldUtils.TROPICS_DIMENSION_ID && this.mc.field_71439_g.field_71093_bK == TropicraftWorldUtils.TROPICS_DIMENSION_ID) {
                isLeaving = true;
            }
            guiLoading.setLeaving(isLeaving);
            if (this.wasTropicsInvolved() && this.isDimensionFarewellAllowed(isLeaving)) {
                evt.setGui((GuiScreen)guiLoading);
            }
        }
    }

    public boolean isDimensionFarewellAllowed(boolean isFarewell) {
        if (!isFarewell) {
            return true;
        }
        for (int i = 0; i < this.farewellSkipDimensions.size(); ++i) {
            Pair<String, Integer> pair = this.farewellSkipDimensions.get(i);
            if ((Integer)pair.getRight() != this.mc.field_71439_g.field_71093_bK) continue;
            return false;
        }
        return true;
    }

    public boolean wasTropicsInvolved() {
        return this.mc.field_71439_g.field_71093_bK == TropicraftWorldUtils.TROPICS_DIMENSION_ID || this.lastDimension == TropicraftWorldUtils.TROPICS_DIMENSION_ID;
    }
}

