/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.biome.decorators;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.tropicraft.core.common.enums.TropicraftOres;
import net.tropicraft.core.registry.BlockRegistry;

public class BiomeDecoratorTropicraft
extends BiomeDecorator {
    private WorldGenerator eudialyteGen;
    private WorldGenerator zirconGen;
    private WorldGenerator azuriteGen;
    protected int zirconSize = 10;
    protected int eudialyteSize = 8;

    public void func_180292_a(World worldIn, Random random, Biome biome, BlockPos pos) {
        if (this.field_185425_a) {
            throw new RuntimeException("Already decorating");
        }
        this.field_180293_d = ChunkGeneratorSettings.Factory.func_177865_a((String)worldIn.func_72912_H().func_82571_y()).func_177864_b();
        this.field_180294_c = pos;
        this.field_185425_a = false;
        this.initOreGen(biome, worldIn, random);
        this.func_150513_a(biome, worldIn, random);
    }

    protected void initOreGen(Biome biome, World world, Random rand) {
        this.field_76823_i = new WorldGenMinable(Blocks.field_150346_d.func_176223_P(), this.field_180293_d.field_177789_I);
        this.field_76820_j = new WorldGenMinable(Blocks.field_150351_n.func_176223_P(), this.field_180293_d.field_177785_M);
        this.field_180296_j = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), this.field_180293_d.field_177796_Q);
        this.field_180297_k = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), this.field_180293_d.field_177792_U);
        this.field_180295_l = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), this.field_180293_d.field_177800_Y);
        this.field_76821_k = new WorldGenMinable(Blocks.field_150365_q.func_176223_P(), this.field_180293_d.field_177844_ac);
        this.field_76818_l = new WorldGenMinable(Blocks.field_150366_p.func_176223_P(), this.field_180293_d.field_177848_ag);
        this.field_76819_m = new WorldGenMinable(Blocks.field_150352_o.func_176223_P(), this.field_180293_d.field_177828_ak);
        this.field_180299_p = new WorldGenMinable(Blocks.field_150450_ax.func_176223_P(), this.field_180293_d.field_177836_ao);
        this.field_180298_q = new WorldGenMinable(Blocks.field_150482_ag.func_176223_P(), this.field_180293_d.field_177814_as);
        this.field_76831_p = new WorldGenMinable(Blocks.field_150369_x.func_176223_P(), this.field_180293_d.field_177822_aw);
        this.eudialyteGen = new WorldGenMinable(BlockRegistry.ore.defaultForVariant(TropicraftOres.EUDIALYTE), this.eudialyteSize);
        this.zirconGen = new WorldGenMinable(BlockRegistry.ore.defaultForVariant(TropicraftOres.ZIRCON), this.zirconSize);
        this.azuriteGen = new AzuriteGenerator();
    }

    protected void func_150513_a(Biome biomeIn, World worldIn, Random random) {
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(worldIn, random, this.field_180294_c));
        this.func_76797_b(worldIn, random);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(worldIn, random, this.field_180294_c));
    }

    protected void func_76797_b(@Nonnull World worldIn, @Nonnull Random random) {
        super.func_76797_b(worldIn, random);
        this.func_76795_a(worldIn, random, this.zirconSize, this.zirconGen, 5, 95);
        this.func_76795_a(worldIn, random, this.eudialyteSize, this.eudialyteGen, 5, 55);
        this.azuriteGen.func_180709_b(worldIn, random, this.field_180294_c);
    }

    public int getTerrainHeightAt(World world, int x, int z) {
        for (int y = world.func_175645_m(new BlockPos(x, 0, z)).func_177956_o() + 1; y > 0; --y) {
            IBlockState blockstate = world.func_180495_p(new BlockPos(x, y, z));
            if (blockstate.func_185904_a() != Material.field_151577_b && blockstate.func_185904_a() != Material.field_151578_c && blockstate.func_185904_a() != Material.field_151595_p) continue;
            return y + 1;
        }
        return 0;
    }

    public final int randDecorationCoord(Random rand, int base, int variance) {
        return base + rand.nextInt(variance) + 8;
    }

    private static class AzuriteGenerator
    extends WorldGenerator {
        private AzuriteGenerator() {
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
            int count = 3 + rand.nextInt(3);
            for (int i = 0; i < count; ++i) {
                int x = rand.nextInt(16) + 8;
                int z = rand.nextInt(16) + 8;
                BlockPos blockpos = pos.func_177982_a(x, rand.nextInt(28) + 4, z);
                IBlockState state = worldIn.func_180495_p(blockpos);
                if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b))) continue;
                worldIn.func_180501_a(blockpos, BlockRegistry.ore.defaultForVariant(TropicraftOres.AZURITE), 2);
            }
            return true;
        }
    }
}

