/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.tropicraft.core.common.block.tileentity.TileEntityBambooChest;
import net.tropicraft.core.common.block.tileentity.TileEntityFactory;

public class BlockBambooChest
extends BlockChest {
    private static final BlockChest.Type TYPE = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"BAMBOO", (Class[])new Class[0], (Object[])new Object[0]);
    private static final MethodHandle _upperChest;
    private static final MethodHandle _lowerChest;

    public BlockBambooChest() {
        super(TYPE);
        this.func_149711_c(2.5f);
        this.func_149649_H();
    }

    public TileEntity func_149915_a(World world, int i) {
        return TileEntityFactory.getBambooChestTE();
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntityBambooChest tile = (TileEntityBambooChest)world.func_175625_s(pos);
        if (tile != null && tile.isUnbreakable()) {
            return 0.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    @Nullable
    public ILockableContainer func_189418_a(World worldIn, BlockPos pos, boolean allowBlocking) {
        ILockableContainer ret = super.func_189418_a(worldIn, pos, allowBlocking);
        if (_upperChest != null && _lowerChest != null && ret instanceof InventoryLargeChest) {
            InventoryLargeChest invLC = (InventoryLargeChest)ret;
            try {
                return new InventoryLargeChest("tile.tropicraft.bamboo_chest_large.name", _upperChest.invokeExact(invLC), _lowerChest.invokeExact(invLC));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    static {
        MethodHandle uc = null;
        MethodHandle lc = null;
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            uc = lookup.unreflectGetter(ReflectionHelper.findField(InventoryLargeChest.class, (String[])new String[]{"field_70478_c", "lowerChest"}));
            lc = lookup.unreflectGetter(ReflectionHelper.findField(InventoryLargeChest.class, (String[])new String[]{"field_70477_b", "upperChest"}));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        _upperChest = uc;
        _lowerChest = lc;
    }
}

