/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.tropicraft.core.common.block.BlockTropicraft;
import net.tropicraft.core.common.enums.TropicraftSands;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class BlockSeaweed
extends BlockTropicraft {
    public static int GROWTH_CHANCE = 10;

    public BlockSeaweed() {
        super(Material.field_151595_p);
        this.func_149672_a(SoundType.field_185855_h);
        this.func_149711_c(0.5f);
        this.setHarvestLevel("shovel", 0);
        this.func_149675_a(true);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileSeaweed) {
            ((TileSeaweed)te).revalidateHeight();
        }
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        this.tryGrow(world, pos);
    }

    private void tryGrow(World world, BlockPos pos) {
        if (world.field_73012_v.nextInt(GROWTH_CHANCE) != 0) {
            return;
        }
        TileSeaweed tileEnt = (TileSeaweed)world.func_175625_s(pos);
        if (tileEnt.getHeight() < tileEnt.getMaxHeight() && tileEnt.canGrowTo(tileEnt.getHeight() + 1)) {
            tileEnt.setHeight(tileEnt.getHeight() + 1);
            tileEnt.syncTileEntity();
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileSeaweed();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockRegistry.sands);
    }

    public int func_180651_a(IBlockState state) {
        return TropicraftSands.FOAMY.getMeta();
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int height;
        TileSeaweed tileEnt = (TileSeaweed)world.func_175625_s(pos);
        for (int i = height = tileEnt.getHeight(); i > 0; --i) {
            ItemStack drop = new ItemStack(ItemRegistry.rawSeaweed);
            Block.func_180635_a((World)world, (BlockPos)pos.func_177981_b(i), (ItemStack)drop);
        }
        super.func_180663_b(world, pos, state);
    }

    public static class TileSeaweed
    extends TileEntity {
        private static final Random rand = new Random(439875L);
        private static final NoiseGeneratorPerlin angleNoise = new NoiseGeneratorPerlin(rand, 1);
        private static final NoiseGeneratorPerlin delayNoise = new NoiseGeneratorPerlin(rand, 3);
        private int height = -1;
        private AxisAlignedBB cachedBB;
        private Vec3d offset = Vec3d.field_186680_a;
        private double swayAngle;
        private double swayDelay;
        private int maxHeight;

        public void initRandomHeights() {
            this.setHeight(rand.nextInt(5) + 1);
            this.setMaxHeight(rand.nextInt(10) + 5);
        }

        protected void func_190201_b(World worldIn) {
            super.func_190201_b(worldIn);
            if (!worldIn.field_72995_K) {
                worldIn.func_175684_a(this.func_174877_v(), BlockRegistry.seaweed, 5);
            }
        }

        public void syncTileEntity() {
            if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
                return;
            }
            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148537_a((Packet)this.func_189518_D_(), this.field_145850_b.field_73011_w.getDimension());
        }

        public void recalculateClientBB() {
            rand.setSeed(MathHelper.func_180187_c((int)this.func_174877_v().func_177958_n(), (int)this.func_174877_v().func_177956_o(), (int)this.func_174877_v().func_177952_p()));
            this.cachedBB = new AxisAlignedBB(this.func_174877_v()).func_72314_b(1.1, (double)((float)this.height / 2.0f), 1.1).func_72317_d(0.0, (double)((float)this.height / 2.0f), 0.0);
            this.offset = new Vec3d((double)((rand.nextFloat() - 0.5f) * 0.25f), 0.0, (double)((rand.nextFloat() - 0.5f) * 0.25f));
            Vec3d centerPos = new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5).func_178787_e(this.offset);
            this.swayAngle = angleNoise.func_151601_a(centerPos.field_72450_a / 200.0, centerPos.field_72449_c / 200.0);
            this.swayAngle += 1.0;
            this.swayAngle *= Math.PI;
            this.swayDelay = delayNoise.func_151601_a(centerPos.field_72450_a / 100.0, centerPos.field_72449_c / 100.0);
            this.swayDelay *= 20.0;
        }

        public void revalidateHeight() {
            int testHeight;
            for (testHeight = 0; testHeight < this.height && this.canGrowTo(testHeight + 1); ++testHeight) {
            }
            if (testHeight != this.getHeight()) {
                this.setHeight(testHeight);
                this.func_70296_d();
                this.syncTileEntity();
            }
        }

        public boolean canGrowTo(int height) {
            return this.func_145831_w().func_180495_p(this.func_174877_v().func_177981_b(height)).func_185904_a().func_76224_d();
        }

        public AxisAlignedBB getRenderBoundingBox() {
            if (this.cachedBB == null) {
                this.recalculateClientBB();
            }
            return this.cachedBB;
        }

        public double func_145833_n() {
            return super.func_145833_n() * 2.0;
        }

        public boolean hasFastRenderer() {
            return true;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxHeight(int newMax) {
            this.maxHeight = newMax;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
            if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
                this.recalculateClientBB();
            }
        }

        public Vec3d getOffset() {
            return this.offset;
        }

        public double getSwayAngle() {
            return this.swayAngle;
        }

        public double getSwayDelay() {
            return this.swayDelay;
        }

        public void func_145839_a(NBTTagCompound compound) {
            super.func_145839_a(compound);
            this.setHeight(compound.func_74762_e("height"));
            this.setMaxHeight(compound.func_74762_e("maxHeight"));
            if (this.getMaxHeight() == 0) {
                this.initRandomHeights();
            }
        }

        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            compound.func_74768_a("height", this.getHeight());
            compound.func_74768_a("maxHeight", this.getMaxHeight());
            return super.func_189515_b(compound);
        }

        public NBTTagCompound func_189517_E_() {
            return this.func_189515_b(new NBTTagCompound());
        }

        @Nullable
        public SPacketUpdateTileEntity func_189518_D_() {
            return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
        }

        public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
            super.onDataPacket(net, pkt);
            this.func_145839_a(pkt.func_148857_g());
            this.recalculateClientBB();
        }
    }
}

