/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.block.BlockTropicraft;
import net.tropicraft.core.common.block.ITropicraftBlock;
import net.tropicraft.core.common.enums.ITropicraftVariant;
import org.apache.commons.lang3.ArrayUtils;

public class BlockTropicraftEnumVariants<T extends Enum<T>>
extends BlockTropicraft
implements ITropicraftBlock {
    private final IProperty<T> property;
    private final BlockStateContainer blockState;
    private final Int2ObjectMap<T> byMeta = new Int2ObjectArrayMap();
    private final T[] variants;

    protected BlockTropicraftEnumVariants(Material mat, Class<T> enumClass) {
        this(mat, enumClass, (Enum[])enumClass.getEnumConstants());
    }

    protected BlockTropicraftEnumVariants(Material mat, Class<T> enumClass, T[] variants) {
        super(mat);
        Preconditions.checkNotNull(variants);
        Preconditions.checkArgument((variants.length > 0 ? 1 : 0) != 0, (Object)"Must supply at least one variant.");
        this.variants = variants;
        this.property = PropertyEnum.func_177707_a((String)"variant", enumClass, (Collection)Lists.newArrayList((Object[])variants));
        this.blockState = this.func_180661_e();
        for (Enum variant : (Enum[])enumClass.getEnumConstants()) {
            this.byMeta.put(((ITropicraftVariant)((Object)variant)).getMeta(), (Object)variant);
        }
        this.func_180632_j(this.blockState.func_177621_b());
    }

    protected IProperty<?>[] getAdditionalProperties() {
        return new IProperty[0];
    }

    protected BlockStateContainer func_180661_e() {
        if (this.property == null) {
            return super.func_180661_e();
        }
        return new BlockStateContainer((Block)this, (IProperty[])ArrayUtils.addAll((Object[])new IProperty[]{this.getProperty()}, (Object[])this.getAdditionalProperties()));
    }

    public BlockStateContainer func_176194_O() {
        return this.blockState;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < this.property.func_177700_c().size(); ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        Enum variant = (Enum)this.byMeta.get(meta);
        IBlockState ret = this.func_176223_P();
        if (variant != null) {
            ret = ret.func_177226_a(this.getProperty(), (Comparable)((Object)variant));
        }
        return ret;
    }

    public int func_176201_c(IBlockState state) {
        return ((ITropicraftVariant)this.getVariant(state)).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IProperty<T> getProperty() {
        return this.property;
    }

    public T getVariant(IBlockState state) {
        return (T)((Enum)((Object)state.func_177229_b(this.getProperty())));
    }

    public IBlockState defaultForVariant(T variant) {
        return this.func_176223_P().func_177226_a(this.getProperty(), variant);
    }

    public IBlockState randomVariant(Random rand) {
        return this.defaultForVariant(this.variants[rand.nextInt(this.variants.length)]);
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((ITropicraftVariant)this.getVariant(state)).func_176610_l();
    }
}

