/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.block.ITropicraftBlock;
import net.tropicraft.core.common.enums.TropicraftLogs;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public class BlockTropicraftLog
extends BlockLog
implements ITropicraftBlock {
    public static final PropertyEnum<TropicraftLogs> VARIANT = PropertyEnum.func_177709_a((String)"variant", TropicraftLogs.class);

    public BlockTropicraftLog() {
        this.func_149649_H();
        this.func_149711_c(2.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)TropicraftLogs.MAHOGANY)).func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
    }

    @Deprecated
    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ((TropicraftLogs)((Object)blockState.func_177229_b(VARIANT))).getHardness();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c(), 1, ((TropicraftLogs)((Object)state.func_177229_b(VARIANT))).getMeta());
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if ((TropicraftLogs)((Object)state.func_177229_b(VARIANT)) == TropicraftLogs.PALM) {
            BlockTropicraftLog.spawnCoconuts(world, pos, random, 20);
        }
    }

    public static void spawnCoconuts(World world, BlockPos pos, Random random, int chance) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == BlockRegistry.leaves || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == BlockRegistry.leaves) {
            Block coconut = BlockRegistry.coconut;
            if (world.func_175623_d(pos.func_177972_a(EnumFacing.WEST)) && random.nextInt(chance) == 0) {
                TCGenUtils.setBlock(world, pos.func_177974_f(), coconut);
            }
            if (world.func_175623_d(pos.func_177972_a(EnumFacing.WEST)) && random.nextInt(chance) == 0) {
                TCGenUtils.setBlock(world, pos.func_177976_e(), coconut);
            }
            if (world.func_175623_d(pos.func_177972_a(EnumFacing.NORTH)) && random.nextInt(chance) == 0) {
                TCGenUtils.setBlock(world, pos.func_177978_c(), coconut);
            }
            if (world.func_175623_d(pos.func_177972_a(EnumFacing.SOUTH)) && random.nextInt(chance) == 0) {
                TCGenUtils.setBlock(world, pos.func_177968_d(), coconut);
            }
            if (world.func_175623_d(pos.func_177972_a(EnumFacing.DOWN)) && random.nextInt(chance) == 0) {
                TCGenUtils.setBlock(world, pos.func_177977_b(), coconut);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176299_a, VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < TropicraftLogs.values().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)TropicraftLogs.byMetadata(meta & 3)));
        switch (meta & 0xC) {
            case 0: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.X);
                break;
            }
            case 8: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
            }
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((TropicraftLogs)((Object)state.func_177229_b(VARIANT))).getMeta();
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)) {
            case X: {
                i |= 4;
                break;
            }
            case Z: {
                i |= 8;
                break;
            }
            case NONE: {
                i |= 0xC;
            }
        }
        return i;
    }

    public int func_180651_a(IBlockState state) {
        return ((TropicraftLogs)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, ((TropicraftLogs)((Object)state.func_177229_b(VARIANT))).getMeta());
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((TropicraftLogs)((Object)state.func_177229_b(VARIANT))).func_176610_l();
    }

    @Override
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    public IItemColor getItemColor() {
        return null;
    }
}

