/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.BlockTropicraftEnumVariants;
import net.tropicraft.core.common.enums.TropicraftOres;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class BlockTropicraftOre
extends BlockTropicraftEnumVariants<TropicraftOres> {
    public BlockTropicraftOre() {
        super(Material.field_151576_e, TropicraftOres.class);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 2);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch ((TropicraftOres)this.getVariant(state)) {
            case AZURITE: {
                return ItemRegistry.azurite;
            }
            case EUDIALYTE: {
                return ItemRegistry.eudialyte;
            }
            case ZIRCON: {
                return ItemRegistry.zircon;
            }
            case MANGANESE: 
            case SHAKA: {
                return Item.func_150898_a(BlockRegistry.ore);
            }
        }
        return null;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        TropicraftOres variant = (TropicraftOres)this.getVariant(state);
        if (variant == TropicraftOres.MANGANESE || variant == TropicraftOres.SHAKA) {
            return variant.ordinal();
        }
        return 0;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        TropicraftOres variant = (TropicraftOres)this.getVariant(state);
        if (variant == TropicraftOres.EUDIALYTE) {
            return 1 + random.nextInt(4 + fortune);
        }
        if (variant == TropicraftOres.MANGANESE || variant == TropicraftOres.SHAKA) {
            return 1;
        }
        return 1 + random.nextInt(1 + fortune);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        return MathHelper.func_76136_a((Random)rand, (int)2, (int)7);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(BlockRegistry.ore, 1, ((TropicraftOres)this.getVariant(state)).getMeta());
    }
}

