/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.tropicraft.Names;
import net.tropicraft.core.common.block.tileentity.message.MessageSifterInventory;
import net.tropicraft.core.common.block.tileentity.message.MessageSifterStart;
import net.tropicraft.core.common.enums.TropicraftShells;
import net.tropicraft.core.common.network.TCPacketHandler;
import net.tropicraft.core.registry.ItemRegistry;

public class TileEntitySifter
extends TileEntity
implements ITickable {
    public static final int SIFT_TIME = 80;
    public boolean isSifting;
    public int currentSiftTime = 80;
    private Random rand;
    public double yaw;
    public double yaw2 = 0.0;
    @Nonnull
    public ItemStack siftItem = ItemStack.field_190927_a;

    public TileEntitySifter() {
        this.rand = new Random();
    }

    public void func_73660_a() {
        if (this.currentSiftTime > 0 && this.isSifting) {
            --this.currentSiftTime;
        }
        if (this.func_145831_w().field_72995_K) {
            this.yaw2 = this.yaw % 360.0;
            this.yaw += 4.545454502105713;
        }
        if (this.isSifting && this.currentSiftTime <= 0) {
            this.stopSifting();
        }
    }

    public void dumpResults(double x, double y, double z, SiftType type) {
        this.dumpBeachResults(x, y, z);
        this.syncInventory();
    }

    private void dumpBeachResults(double x, double y, double z) {
        int dumpCount = this.rand.nextInt(3) + 1;
        while (dumpCount > 0) {
            ItemStack stack;
            --dumpCount;
            if (this.rand.nextInt(10) == 0) {
                stack = this.getRareItem();
            } else if (this.rand.nextInt(10) < 3) {
                int damage = this.rand.nextInt(Names.LT17_NAMES.length);
                stack = new ItemStack((Item)ItemRegistry.ltShell, 1, damage);
            } else {
                stack = this.getCommonItem();
            }
            this.spawn(stack, x, y, z);
        }
    }

    private void spawn(ItemStack stack, double x, double y, double z) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        EntityItem eitem = new EntityItem(this.func_145831_w(), x, y, z, stack);
        eitem.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.func_145831_w().func_72838_d((Entity)eitem);
    }

    private ItemStack getCommonItem() {
        int dmg = this.rand.nextInt(TropicraftShells.values().length + 1) - 1;
        if (dmg < 0) {
            return this.getRareItem();
        }
        return new ItemStack((Item)ItemRegistry.shell, 1, dmg);
    }

    private ItemStack getRareItem() {
        int dmg = this.rand.nextInt(12);
        switch (dmg) {
            case 0: {
                return new ItemStack((Item)ItemRegistry.shell, 1, TropicraftShells.RUBE.getMeta());
            }
            case 1: {
                return new ItemStack(Items.field_151074_bl, 1);
            }
            case 2: {
                return new ItemStack(Items.field_151133_ar, 1);
            }
            case 3: {
                return new ItemStack(Items.field_151038_n, 1);
            }
            case 4: {
                return new ItemStack(Items.field_151069_bo, 1);
            }
            case 5: {
                return new ItemStack(ItemRegistry.whitePearl, 1);
            }
            case 6: {
                return new ItemStack(ItemRegistry.blackPearl, 1);
            }
            case 7: {
                return new ItemStack(Items.field_151051_r, 1);
            }
        }
        return new ItemStack((Item)ItemRegistry.shell, 1, TropicraftShells.RUBE.getMeta());
    }

    public boolean isHeatedSifter() {
        IBlockState stateBelow = this.func_145831_w().func_180495_p(this.func_174877_v().func_177977_b());
        return stateBelow.func_185904_a() == Material.field_151581_o || stateBelow.func_185904_a() == Material.field_151587_i;
    }

    public void addItemToSifter(ItemStack stack) {
        this.siftItem = stack;
        this.siftItem.func_190920_e(1);
        this.syncInventory();
    }

    public void startSifting() {
        this.isSifting = true;
        if (!this.func_145831_w().field_72995_K) {
            TCPacketHandler.INSTANCE.sendToDimension(new MessageSifterStart(this), this.func_145831_w().field_73011_w.getDimension());
        }
    }

    private void stopSifting() {
        double x = (double)this.field_174879_c.func_177958_n() + this.func_145831_w().field_73012_v.nextDouble() * 1.4;
        double y = (double)this.field_174879_c.func_177956_o() + this.func_145831_w().field_73012_v.nextDouble() * 1.4;
        double z = (double)this.field_174879_c.func_177952_p() + this.func_145831_w().field_73012_v.nextDouble() * 1.4;
        if (!this.func_145831_w().field_72995_K) {
            this.dumpResults(x, y, z, this.isHeatedSifter() ? SiftType.HEATED : SiftType.REGULAR);
        }
        this.currentSiftTime = 80;
        this.isSifting = false;
        this.siftItem = ItemStack.field_190927_a;
        this.syncInventory();
    }

    public void setSifting(boolean flag) {
        this.isSifting = flag;
    }

    public boolean isSifting() {
        return this.isSifting;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isSifting = nbt.func_74767_n("isSifting");
        this.currentSiftTime = nbt.func_74762_e("currentSiftTime");
        NBTTagList itemtaglist = nbt.func_150295_c("Item", 10);
        NBTTagCompound itemtagcompound = itemtaglist.func_150305_b(0);
        this.siftItem = new ItemStack(itemtagcompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("isSifting", this.isSifting);
        nbt.func_74768_a("currentSiftTime", this.currentSiftTime);
        NBTTagList nbttaglist = new NBTTagList();
        if (this.siftItem != null) {
            NBTTagCompound siftItemTagCompound = new NBTTagCompound();
            this.siftItem.func_77955_b(siftItemTagCompound);
            nbttaglist.func_74742_a((NBTBase)siftItemTagCompound);
        }
        nbt.func_74782_a("Item", (NBTBase)nbttaglist);
        return nbt;
    }

    public NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    protected void syncInventory() {
        TCPacketHandler.INSTANCE.sendToDimension(new MessageSifterInventory(this), this.func_145831_w().field_73011_w.getDimension());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbttagcompound = this.func_189515_b(new NBTTagCompound());
        return nbttagcompound;
    }

    public static enum SiftType {
        REGULAR,
        HEATED;

    }
}

