/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.capability;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.tropicraft.core.common.town.ISimulationTickable;
import net.tropicraft.core.common.town.ManagedLocation;

public class WorldDataInstance {
    private World world;
    private int lastIDUsedForKoaVillage = 0;
    public ConcurrentHashMap<Integer, ISimulationTickable> lookupTickingManagedLocations = new ConcurrentHashMap();

    public World getWorld() {
        return this.world;
    }

    public WorldDataInstance setWorld(World world) {
        this.world = world;
        return this;
    }

    public void readNBT(NBTTagCompound nbt) {
        this.lastIDUsedForKoaVillage = nbt.func_74762_e("lastIDUsedForKoaVillage");
        NBTTagCompound tickingLocations = nbt.func_74775_l("tickingLocations");
        for (String keyName : tickingLocations.func_150296_c()) {
            NBTTagCompound nbt2 = tickingLocations.func_74775_l(keyName);
            String classname = nbt2.func_74779_i("classname");
            ClassLoader classLoader = WorldDataInstance.class.getClassLoader();
            Class<?> aClass = null;
            try {
                aClass = classLoader.loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ISimulationTickable locationObj = null;
            if (aClass != null) {
                try {
                    locationObj = (ISimulationTickable)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (locationObj == null) continue;
            locationObj.init();
            locationObj.readFromNBT(nbt2);
            locationObj.initPost();
            this.addTickingLocation(locationObj);
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("lastIDUsedForKoaVillage", this.lastIDUsedForKoaVillage);
        NBTTagCompound nbtSet = new NBTTagCompound();
        int index = 0;
        for (ISimulationTickable entry : this.lookupTickingManagedLocations.values()) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            entry.writeToNBT(nbt2);
            nbtSet.func_74782_a("" + index++, (NBTBase)nbt2);
        }
        nbt.func_74782_a("tickingLocations", (NBTBase)nbtSet);
        nbt.func_74778_a("classname", this.getClass().getCanonicalName());
    }

    public void addTickingLocation(ISimulationTickable location) {
        this.addTickingLocation(location, true);
    }

    public void addTickingLocation(ISimulationTickable location, boolean init) {
        if (location.getOrigin() != null) {
            int hash = 0;
            hash = location instanceof ManagedLocation ? ((ManagedLocation)location).locationID : location.getOrigin().hashCode();
            if (!this.lookupTickingManagedLocations.containsKey(hash)) {
                this.lookupTickingManagedLocations.put(hash, location);
            } else {
                System.out.println("warning: location already exists at these coords: " + location.getOrigin());
            }
        }
    }

    public void removeTickingLocation(ISimulationTickable location) {
        if (location.getOrigin() != null) {
            Integer hash = location.getOrigin().hashCode();
            if (this.lookupTickingManagedLocations.containsKey(hash)) {
                this.lookupTickingManagedLocations.remove(hash);
                location.cleanup();
            } else {
                System.out.println("Error, couldnt find location for removal");
            }
        }
    }

    public void tick() {
        for (ISimulationTickable entry : this.lookupTickingManagedLocations.values()) {
            entry.tickUpdate();
        }
    }

    public ISimulationTickable getLocationByID(int id) {
        return this.lookupTickingManagedLocations.get(id);
    }

    public int getAndIncrementKoaIDVillage() {
        return this.lastIDUsedForKoaVillage++;
    }
}

