/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockSand;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.ForgeEventFactory;
import net.tropicraft.core.common.biome.BiomeTropicraft;
import net.tropicraft.core.common.spawning.TropiWorldEntitySpawner;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.common.worldgen.mapgen.MapGenTropicsCaves;
import net.tropicraft.core.common.worldgen.mapgen.MapGenUndergroundGrove;
import net.tropicraft.core.common.worldgen.mapgen.MapGenUndergroundWaterCove;
import net.tropicraft.core.common.worldgen.mapgen.MapGenVolcano;
import net.tropicraft.core.registry.BlockRegistry;

public class ChunkProviderTropicraft
implements IChunkGenerator {
    private World worldObj;
    protected Random rand;
    private Biome[] biomesForGeneration;
    private double[] depthBuffer = new double[256];
    private float[] parabolicField;
    private NoiseGeneratorPerlin surfaceNoise;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    private NoiseGeneratorOctaves noiseGen5;
    private MapGenUndergroundGrove groveGen;
    private MapGenUndergroundWaterCove coveGen;
    private MapGenTropicsCaves caveGenerator;
    private MapGenVolcano volcanoGen;
    private final Set<BlockPos> volcanoCache = new HashSet<BlockPos>();

    public ChunkProviderTropicraft(World world, long seed, boolean mapFeaturesEnabled) {
        this.worldObj = world;
        this.rand = new Random(seed);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 16);
        this.volcanoGen = new MapGenVolcano(this.worldObj, true);
        this.groveGen = new MapGenUndergroundGrove(this.worldObj);
        this.coveGen = new MapGenUndergroundWaterCove(this.worldObj);
        this.caveGenerator = new MapGenTropicsCaves();
    }

    public void func_185931_b(int x, int z) {
        BlockPos posVolcanoTE;
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        BiomeTropicraft biome = (BiomeTropicraft)this.worldObj.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.worldObj.func_72905_C());
        biome.func_180624_a(this.worldObj, this.rand, blockpos);
        this.coveGen.decorate(x, z);
        BlockPos volcanoCoords = this.volcanoGen.getVolcanoNear(this.worldObj, x, z);
        if (volcanoCoords != null && !this.volcanoCache.contains(volcanoCoords) && this.worldObj.func_180495_p(posVolcanoTE = new BlockPos(volcanoCoords.func_177958_n(), 1, volcanoCoords.func_177952_p())).func_177230_c() != BlockRegistry.volcano) {
            this.worldObj.func_175656_a(posVolcanoTE, BlockRegistry.volcano.func_176223_P());
            this.volcanoCache.add(volcanoCoords);
        }
        TropiWorldEntitySpawner.performWorldGenSpawning(this.worldObj, biome, i + 8, j + 8, 16, 16, this.rand);
        BlockSand.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.worldObj.func_180494_b(pos).func_76747_a(creatureType);
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBiomeBlocks(x, z, chunkprimer, this.biomesForGeneration);
        this.volcanoGen.generate(x, z, chunkprimer);
        this.groveGen.generate(x, z, chunkprimer);
        this.caveGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
        this.coveGen.generate(x, z, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.worldObj)) {
            return;
        }
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        int a = -1;
        boolean flag = false;
        int k = 63;
        double d = 0.03125;
        for (int xValue = 0; xValue < 16; ++xValue) {
            for (int zValue = 0; zValue < 16; ++zValue) {
                Biome biomePreCast = biomesIn[xValue + zValue * 16];
                if (!(biomePreCast instanceof BiomeTropicraft)) {
                    System.err.println("!!! Weird, ChunkProviderTropicraft encountered a non Tropicraft biome: " + biomePreCast.func_185359_l());
                    continue;
                }
                BiomeTropicraft biome = (BiomeTropicraft)biomePreCast;
                int yStart = -1;
                for (int yValue = 127; yValue >= 0; --yValue) {
                    int xx = xValue;
                    int zz = zValue;
                    Block block = primer.func_177856_a(xx, yValue, zz).func_177230_c();
                    if (yValue <= 0) {
                        primer.func_177855_a(xx, yValue, zz, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    if (TCGenUtils.isBlockInList(block, new Block[]{Blocks.field_150350_a, BlockRegistry.tropicsWater})) {
                        a = 0;
                        continue;
                    }
                    if (a >= 0 && a < 5) {
                        if (yStart == -1) {
                            yStart = yValue;
                        }
                        IBlockState blockUsed = biome.getStateForLayer(yStart, a);
                        primer.func_177855_a(xx, yValue, zz, blockUsed);
                        ++a;
                        continue;
                    }
                    a = -1;
                }
                a = -1;
            }
        }
    }

    private void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        int chunkSizeGenXZ = 4;
        int chunkSizeGenY = 16;
        int midHeight = 63;
        int k_size = chunkSizeGenXZ + 1;
        int b3 = 17;
        int l_size = chunkSizeGenXZ + 1;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, k_size + 5, l_size + 5);
        double[] noiseArray = null;
        noiseArray = this.initializeNoiseField(noiseArray, x * chunkSizeGenXZ, 0, z * chunkSizeGenXZ, k_size, b3, l_size);
        for (int genX = 0; genX < chunkSizeGenXZ; ++genX) {
            for (int genY = 0; genY < chunkSizeGenXZ; ++genY) {
                for (int genZ = 0; genZ < chunkSizeGenY; ++genZ) {
                    double d0 = 0.125;
                    double d1 = noiseArray[((genX + 0) * l_size + genY + 0) * b3 + genZ + 0];
                    double d2 = noiseArray[((genX + 0) * l_size + genY + 1) * b3 + genZ + 0];
                    double d3 = noiseArray[((genX + 1) * l_size + genY + 0) * b3 + genZ + 0];
                    double d4 = noiseArray[((genX + 1) * l_size + genY + 1) * b3 + genZ + 0];
                    double d5 = (noiseArray[((genX + 0) * l_size + genY + 0) * b3 + genZ + 1] - d1) * d0;
                    double d6 = (noiseArray[((genX + 0) * l_size + genY + 1) * b3 + genZ + 1] - d2) * d0;
                    double d7 = (noiseArray[((genX + 1) * l_size + genY + 0) * b3 + genZ + 1] - d3) * d0;
                    double d8 = (noiseArray[((genX + 1) * l_size + genY + 1) * b3 + genZ + 1] - d4) * d0;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d14 = 0.25;
                            double d15 = (d11 - d10) * d14;
                            double d16 = d10 - d15;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                d16 += d15;
                                if (d > 0.0) {
                                    primer.func_177855_a(genX * 4 + k2, genZ * 8 + j2, genY * 4 + l2, Blocks.field_150348_b.func_176223_P());
                                    continue;
                                }
                                if (genZ * 8 + j2 >= 64) continue;
                                primer.func_177855_a(genX * 4 + k2, genZ * 8 + j2, genY * 4 + l2, BlockRegistry.tropicsWater.func_176223_P());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private double[] initializeNoiseField(double[] par1ArrayOfDouble, int par2, int par3, int par4, int par5, int par6, int par7) {
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        if (this.parabolicField == null) {
            this.parabolicField = new float[25];
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -2; l1 <= 2; ++l1) {
                    float f;
                    this.parabolicField[k1 + 2 + (l1 + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(k1 * k1 + l1 * l1) + 0.2f));
                }
            }
        }
        double d0 = 684.412;
        double d1 = 684.412;
        double[] noise1 = null;
        double[] noise2 = null;
        double[] noise3 = null;
        double[] noise4 = null;
        double[] noise5 = null;
        noise1 = this.noiseGen1.func_76304_a(noise1, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        noise2 = this.noiseGen2.func_76304_a(noise2, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        noise3 = this.noiseGen3.func_76304_a(noise3, par2, par3, par4, par5, par6, par7, d0 / 80.0, d1 / 160.0, d0 / 80.0);
        noise4 = this.noiseGen4.func_76305_a(noise4, par2, par4, par5, par7, 1.121, 1.121, 0.5);
        noise5 = this.noiseGen5.func_76305_a(noise5, par2, par4, par5, par7, 200.0, 200.0, 0.5);
        int i2 = 0;
        int j2 = 0;
        for (int k2 = 0; k2 < par5; ++k2) {
            for (int l2 = 0; l2 < par7; ++l2) {
                float f1 = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                int b0 = 2;
                Biome biome = this.biomesForGeneration[k2 + 2 + (l2 + 2) * (par5 + 5)];
                for (int i3 = -b0; i3 <= b0; ++i3) {
                    for (int j3 = -b0; j3 <= b0; ++j3) {
                        Biome biome1 = this.biomesForGeneration[k2 + i3 + 2 + (l2 + j3 + 2) * (par5 + 5)];
                        float f4 = this.parabolicField[i3 + 2 + (j3 + 2) * 5] / (biome1.func_185355_j() + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            f4 /= 2.0f;
                        }
                        f1 += biome1.func_185360_m() * f4;
                        f2 += biome1.func_185355_j() * f4;
                        f3 += f4;
                    }
                }
                f1 /= f3;
                f2 /= f3;
                f1 = f1 * 0.9f + 0.1f;
                f2 = (f2 * 4.0f - 1.0f) / 8.0f;
                double d2 = noise5[j2] / 8000.0;
                if (d2 < 0.0) {
                    d2 = -d2 * 0.3;
                }
                if ((d2 = d2 * 3.0 - 2.0) < 0.0) {
                    if ((d2 /= 2.0) < -1.0) {
                        d2 = -1.0;
                    }
                    d2 /= 1.4;
                    d2 /= 2.0;
                } else {
                    if (d2 > 1.0) {
                        d2 = 1.0;
                    }
                    d2 /= 8.0;
                }
                ++j2;
                for (int k3 = 0; k3 < par6; ++k3) {
                    double d3 = f2;
                    double d4 = f1;
                    d3 += d2 * 0.2;
                    d3 = d3 * (double)par6 / 16.0;
                    double d5 = (double)par6 / 2.0 + d3 * 4.0;
                    double d6 = 0.0;
                    double d7 = ((double)k3 - d5) * 12.0 * 128.0 / 128.0 / d4;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = noise1[i2] / 512.0;
                    double d9 = noise2[i2] / 512.0;
                    double d10 = (noise3[i2] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k3 > par6 - 4) {
                        double d11 = (float)(k3 - (par6 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    par1ArrayOfDouble[i2] = d6;
                    ++i2;
                }
            }
        }
        return par1ArrayOfDouble;
    }
}

