/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.tropicraft.core.common.block.BlockTikiTorch;
import net.tropicraft.core.common.block.BlockTropicraftSands;
import net.tropicraft.core.common.block.tileentity.TileEntityBambooChest;
import net.tropicraft.core.common.dimension.WorldProviderTropicraft;
import net.tropicraft.core.common.enums.TropicraftBundles;
import net.tropicraft.core.common.enums.TropicraftSands;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class TeleporterTropics
extends Teleporter {
    private static Block PORTAL_WALL_BLOCK;
    private static Block PORTAL_BLOCK;
    private static Block TELEPORTER_BLOCK;
    private IBlockState thatchBlock = BlockRegistry.bundles.defaultForVariant(TropicraftBundles.THATCH);
    private final WorldServer world;
    private final Random random;
    private final Long2ObjectMap<Teleporter.PortalPosition> destinationCoordinateCache = new Long2ObjectOpenHashMap(4096);
    private final List destinationCoordinateKeys = new ArrayList();

    public TeleporterTropics(WorldServer world) {
        super(world);
        PORTAL_BLOCK = BlockRegistry.tropicsPortal;
        TELEPORTER_BLOCK = BlockRegistry.tropicsPortalTeleporter;
        PORTAL_WALL_BLOCK = BlockRegistry.portalWall;
        this.world = world;
        this.random = new Random(world.func_72905_C());
    }

    public void func_180266_a(Entity entity, float yaw) {
        long startTime = System.currentTimeMillis();
        if (!this.func_180620_b(entity, yaw)) {
            this.func_85188_a(entity);
            this.func_180620_b(entity, yaw);
        }
        long finishTime = System.currentTimeMillis();
        System.out.printf("It took %f seconds for TeleporterTropics.placeInPortal to complete\n", Float.valueOf((float)(finishTime - startTime) / 1000.0f));
    }

    public boolean func_180620_b(Entity entity, float f) {
        int searchArea = 148;
        double closestPortal = -1.0;
        int foundX = 0;
        int foundY = 0;
        int foundZ = 0;
        int entityX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        BlockPos blockpos = BlockPos.field_177992_a;
        boolean notInCache = true;
        long j1 = ChunkPos.func_77272_a((int)entityX, (int)entityZ);
        if (this.destinationCoordinateCache.containsKey(j1)) {
            Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)this.destinationCoordinateCache.get(j1);
            closestPortal = 0.0;
            blockpos = portalposition;
            portalposition.field_85087_d = this.world.func_82737_E();
            notInCache = false;
        } else {
            for (int x = entityX - searchArea; x <= entityX + searchArea; ++x) {
                double distX = (double)x + 0.5 - entity.field_70165_t;
                for (int z = entityZ - searchArea; z <= entityZ + searchArea; ++z) {
                    double distZ = (double)z + 0.5 - entity.field_70161_v;
                    for (int y = this.world.func_72940_L() - 1; y >= 0; --y) {
                        BlockPos pos = new BlockPos(x, y, z);
                        if (this.world.func_180495_p(pos).func_177230_c() != PORTAL_BLOCK) continue;
                        pos = pos.func_177977_b();
                        while (this.world.func_180495_p(pos).func_177230_c() == PORTAL_BLOCK) {
                            --y;
                            pos = pos.func_177977_b();
                        }
                        double distY = (double)y + 0.5 - entity.field_70163_u;
                        double distance = distX * distX + distY * distY + distZ * distZ;
                        if (!(closestPortal < 0.0) && !(distance < closestPortal)) continue;
                        closestPortal = distance;
                        foundX = x;
                        foundY = y;
                        foundZ = z;
                    }
                }
            }
        }
        if (closestPortal >= 0.0) {
            if (notInCache) {
                this.destinationCoordinateCache.put(j1, (Object)new Teleporter.PortalPosition((Teleporter)this, blockpos, this.world.func_82737_E()));
            }
            int x = foundX;
            int y = foundY;
            int z = foundZ;
            double newLocX = (double)x + 0.5;
            double newLocY = (double)y + 0.5;
            double newLocZ = (double)z + 0.5;
            BlockPos pos = new BlockPos(x, y, z);
            if (this.world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_177230_c() == PORTAL_BLOCK) {
                newLocX -= 0.5;
            }
            if (this.world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_177230_c() == PORTAL_BLOCK) {
                newLocX += 0.5;
            }
            if (this.world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)).func_177230_c() == PORTAL_BLOCK) {
                newLocZ -= 0.5;
            }
            if (this.world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_177230_c() == PORTAL_BLOCK) {
                newLocZ += 0.5;
            }
            entity.func_70012_b(newLocX, newLocY + 2.0, newLocZ, entity.field_70177_z, 0.0f);
            int worldSpawnX = MathHelper.func_76128_c((double)newLocX);
            int worldSpawnZ = MathHelper.func_76128_c((double)newLocZ);
            int worldSpawnY = foundY + 5;
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (this.world.field_73011_w instanceof WorldProviderTropicraft && !player.field_71071_by.func_70431_c(new ItemStack(ItemRegistry.encyclopedia))) {
                    TileEntityBambooChest chest = null;
                    int chestX = MathHelper.func_76128_c((double)newLocX);
                    int chestZ = MathHelper.func_76128_c((double)newLocZ);
                    block4: for (int searchX = -3; searchX < 4; ++searchX) {
                        for (int searchZ = -3; searchZ < 4; ++searchZ) {
                            for (int searchY = -4; searchY < 5; ++searchY) {
                                BlockPos chestPos = new BlockPos(chestX + searchX, worldSpawnY + searchY, chestZ + searchZ);
                                if (this.world.func_180495_p(chestPos).func_177230_c() == BlockRegistry.bambooChest && (chest = (TileEntityBambooChest)this.world.func_175625_s(chestPos)) != null && chest.isUnbreakable()) break block4;
                            }
                        }
                    }
                    if (chest != null && chest.isUnbreakable()) {
                        int inv;
                        boolean hasEncyclopedia = false;
                        for (inv = 0; inv < chest.func_70302_i_(); ++inv) {
                            ItemStack stack = chest.func_70301_a(inv);
                            if (stack.func_77973_b() != ItemRegistry.encyclopedia) continue;
                            hasEncyclopedia = true;
                        }
                        if (!hasEncyclopedia) {
                            for (inv = 0; inv < chest.func_70302_i_(); ++inv) {
                                ItemStack stack = chest.func_70301_a(inv);
                                if (!stack.func_190926_b()) continue;
                                chest.func_70299_a(inv, new ItemStack(ItemRegistry.encyclopedia, 1));
                                break;
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        System.out.println("Start make portal");
        int searchArea = 16;
        double closestSpot = -1.0;
        int entityX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int entityZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        int foundX = entityX;
        int foundY = entityY;
        int foundZ = entityZ;
        for (int x = entityX - searchArea; x <= entityX + searchArea; ++x) {
            double distX = (double)x + 0.5 - entity.field_70165_t;
            block1: for (int z = entityZ - searchArea; z <= entityZ + searchArea; ++z) {
                double distZ = (double)z + 0.5 - entity.field_70161_v;
                int y = this.world.func_72800_K() - 1;
                BlockPos pos = new BlockPos(x, y, z);
                while (!(y < 62 || this.world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a && this.getValidBuildBlocks().contains(this.world.func_180495_p(pos)))) {
                    y = pos.func_177956_o();
                    pos = pos.func_177977_b();
                }
                if (y > 83 || y < 63) continue;
                BlockPos tryPos = new BlockPos(x, y, z);
                if (!this.getValidBuildBlocks().contains(this.world.func_180495_p(tryPos))) continue;
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                        int otherY = this.world.func_72800_K() - 1;
                        BlockPos pos1 = new BlockPos(x + xOffset, otherY, z + zOffset);
                        BlockPos pos2 = tryPos.func_185334_h();
                        while (!(otherY < 63 || this.world.func_180495_p(pos1).func_177230_c() != Blocks.field_150350_a && this.world.func_180495_p(pos2).func_185914_p())) {
                            otherY = pos1.func_177956_o();
                            pos1 = pos1.func_177977_b();
                        }
                        if (Math.abs(y - otherY) >= 3) continue block1;
                    }
                }
                double distY = (double)y + 0.5 - entity.field_70163_u;
                double distance = distX * distX + distY * distY + distZ * distZ;
                if (!(closestSpot < 0.0) && !(distance < closestSpot)) continue;
                closestSpot = distance;
                foundX = x;
                foundY = y;
                foundZ = z;
            }
        }
        int worldSpawnX = MathHelper.func_76141_d((float)foundX);
        int worldSpawnZ = MathHelper.func_76141_d((float)foundZ);
        int worldSpawnY = this.getTerrainHeightAt(worldSpawnX, worldSpawnZ);
        int SEARCH_FOR_LAND_DISTANCE_MAX = 200;
        if (closestSpot < 0.0) {
            foundY = worldSpawnY - 2;
            boolean foundLand = false;
            block6: for (int dist = 1; !foundLand && dist < SEARCH_FOR_LAND_DISTANCE_MAX; ++dist) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    BlockPos pos = new BlockPos(worldSpawnX, worldSpawnY, worldSpawnZ).func_177967_a(dir, 3 + dist);
                    IBlockState state = this.world.func_180495_p(pos);
                    if (!this.getValidBuildBlocks().contains(state)) continue;
                    foundLand = true;
                    BlockPos buildpos = new BlockPos(worldSpawnX, worldSpawnY + 1, worldSpawnZ).func_177967_a(dir, 3);
                    while (!buildpos.equals((Object)pos.func_177984_a())) {
                        this.world.func_175656_a(buildpos, this.thatchBlock);
                        this.world.func_175656_a(buildpos.func_177972_a(dir.func_176746_e()), this.thatchBlock);
                        this.world.func_175656_a(buildpos.func_177972_a(dir.func_176735_f()), this.thatchBlock);
                        buildpos = buildpos.func_177972_a(dir);
                    }
                    BlockPos stairPosMid = new BlockPos(pos.func_177958_n(), worldSpawnY + 1, worldSpawnZ);
                    this.placeStairs(stairPosMid, dir.func_176734_d());
                    this.generateThatchBorder(worldSpawnX, worldSpawnY + 1, worldSpawnZ);
                    continue block6;
                }
            }
        }
        entity.func_70012_b((double)foundX, (double)(foundY + 2), (double)foundZ, entity.field_70177_z, 0.0f);
        this.buildTeleporterAt(worldSpawnX, worldSpawnY + 1, worldSpawnZ, entity);
        System.out.println("End makePortal");
        return true;
    }

    private void placeStairs(BlockPos pos, EnumFacing dir) {
        if (dir == EnumFacing.EAST || dir == EnumFacing.WEST) {
            BlockPos stairPosLeft = pos.func_177982_a(0, 0, -1);
            BlockPos stairPosMid = pos;
            BlockPos stairPosRight = pos.func_177982_a(0, 0, 1);
            IBlockState thatchStairState = BlockRegistry.thatchStairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)dir);
            this.world.func_175656_a(stairPosLeft, thatchStairState);
            this.world.func_175656_a(stairPosMid, thatchStairState);
            this.world.func_175656_a(stairPosRight, thatchStairState);
        } else if (dir == EnumFacing.NORTH || dir == EnumFacing.SOUTH) {
            BlockPos stairPosLeft = pos.func_177982_a(-1, 0, 0);
            BlockPos stairPosMid = pos;
            BlockPos stairPosRight = pos.func_177982_a(1, 0, 0);
            IBlockState thatchStairState = BlockRegistry.thatchStairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)dir);
            this.world.func_175656_a(stairPosLeft, thatchStairState);
            this.world.func_175656_a(stairPosMid, thatchStairState);
            this.world.func_175656_a(stairPosRight, thatchStairState);
        }
    }

    private void generateThatchBorder(int x, int y, int z) {
        for (int zOffset = -4; zOffset <= 4; ++zOffset) {
            for (int xOffset = -4; xOffset <= 4; ++xOffset) {
                boolean isWall;
                boolean bl = isWall = xOffset < -2 || xOffset > 2 || zOffset < -2 || zOffset > 2;
                if (!isWall) continue;
                BlockPos thatchPos = new BlockPos(x + xOffset, y, z + zOffset);
                IBlockState thatchState = BlockRegistry.bundles.defaultForVariant(TropicraftBundles.THATCH);
                this.world.func_175656_a(thatchPos, thatchState);
            }
        }
    }

    public int getTerrainHeightAt(int x, int z) {
        for (int y = 100; y > 0; --y) {
            IBlockState state = this.world.func_180495_p(new BlockPos(x, y, z));
            Block block = state.func_177230_c();
            if (block != Blocks.field_150346_d && state.func_185904_a() != Material.field_151576_e && state.func_185904_a() != Material.field_151586_h && state.func_185904_a() != Material.field_151577_b && state.func_185904_a() != Material.field_151595_p) continue;
            return y;
        }
        return 0;
    }

    public void buildTeleporterAt(int x, int y, int z, Entity entity) {
        System.out.println("start buildTeleporterAt");
        y = y < 9 ? 9 : y;
        for (int yOffset = 4; yOffset >= -7; --yOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    boolean isCorner;
                    int blockX = x + xOffset;
                    int blockY = y + yOffset;
                    int blockZ = z + zOffset;
                    BlockPos pos = new BlockPos(blockX, blockY, blockZ);
                    if (yOffset == -7) {
                        this.world.func_175656_a(pos, PORTAL_WALL_BLOCK.func_176223_P());
                    } else if (yOffset > 0) {
                        this.world.func_175698_g(pos);
                    } else {
                        boolean isWall;
                        boolean bl = isWall = xOffset == -2 || xOffset == 2 || zOffset == -2 || zOffset == 2;
                        if (isWall) {
                            this.world.func_175656_a(pos, PORTAL_WALL_BLOCK.func_176223_P());
                        } else {
                            boolean isTeleportBlock;
                            boolean bl2 = isTeleportBlock = yOffset <= -5;
                            if (isTeleportBlock) {
                                this.world.func_175656_a(pos, TELEPORTER_BLOCK.func_176223_P());
                            } else {
                                this.world.func_175656_a(pos, PORTAL_BLOCK.func_176223_P());
                            }
                        }
                    }
                    boolean bl = isCorner = !(xOffset != -2 && xOffset != 2 || zOffset != -2 && zOffset != 2);
                    if (yOffset != 0 || !isCorner) continue;
                    this.world.func_180501_a(pos.func_177984_a(), BlockRegistry.tikiTorch.func_176223_P().func_177226_a(BlockTikiTorch.SECTION, (Comparable)((Object)BlockTikiTorch.TorchSection.LOWER)), 3);
                    this.world.func_180501_a(pos.func_177981_b(2), BlockRegistry.tikiTorch.func_176223_P().func_177226_a(BlockTikiTorch.SECTION, (Comparable)((Object)BlockTikiTorch.TorchSection.MIDDLE)), 3);
                    this.world.func_180501_a(pos.func_177981_b(3), BlockRegistry.tikiTorch.func_176223_P().func_177226_a(BlockTikiTorch.SECTION, (Comparable)((Object)BlockTikiTorch.TorchSection.UPPER)), 3);
                }
            }
        }
        if (this.world.field_73011_w instanceof WorldProviderTropicraft) {
            BlockPos chestPos = new BlockPos(x + 2, y + 1, z);
            this.world.func_180501_a(chestPos, BlockRegistry.bambooChest.func_176223_P(), 3);
            TileEntityBambooChest tile = (TileEntityBambooChest)this.world.func_175625_s(chestPos);
            if (tile != null) {
                tile.setIsUnbreakable(true);
            }
        }
        System.out.println("end buildTeleporterAt");
    }

    public void func_85189_a(long par1) {
        if (par1 % 100L == 0L) {
            Iterator iterator = this.destinationCoordinateKeys.iterator();
            long j = par1 - 600L;
            while (iterator.hasNext()) {
                Long olong = (Long)iterator.next();
                Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)this.destinationCoordinateCache.get(olong.longValue());
                if (portalposition != null && portalposition.field_85087_d >= j) continue;
                iterator.remove();
                this.destinationCoordinateCache.remove(olong.longValue());
            }
        }
    }

    private List<IBlockState> getValidBuildBlocks() {
        return Arrays.asList(Blocks.field_150354_m.func_176223_P(), Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P(), BlockRegistry.sands.func_176223_P().func_177226_a(BlockTropicraftSands.VARIANT, (Comparable)((Object)TropicraftSands.PURIFIED)));
    }
}

