/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Teleporter;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.dimension.TeleporterTropics;
import net.tropicraft.core.common.dimension.WorldProviderTropicraft;

public class TropicraftWorldUtils {
    public static final int TROPICS_DIMENSION_ID = TropicsConfigs.tropicsDimensionID;
    public static final DimensionType tropicsDimension = DimensionType.register((String)"Tropics", (String)"_tropics", (int)TROPICS_DIMENSION_ID, WorldProviderTropicraft.class, (boolean)true);

    public static void initializeDimension() {
        DimensionManager.registerDimension((int)TROPICS_DIMENSION_ID, (DimensionType)tropicsDimension);
        NBTTagCompound n = new NBTTagCompound();
        n.func_74768_a("dim_id", tropicsDimension.func_186068_a());
        n.func_74778_a("dim_name", tropicsDimension.func_186065_b());
        FMLInterModComms.sendMessage((String)ForgeModContainer.getInstance().getModId(), (String)"loaderFarewellSkip", (NBTTagCompound)n);
    }

    public static void teleportPlayer(EntityPlayerMP player) {
        TeleporterTropics tropicsTeleporter;
        long time = System.currentTimeMillis();
        if (player.field_71093_bK == TROPICS_DIMENSION_ID) {
            tropicsTeleporter = new TeleporterTropics(player.func_184102_h().func_71218_a(0));
            PlayerList pl = player.func_184102_h().func_184103_al();
            pl.transferPlayerToDimension(player, 0, (Teleporter)tropicsTeleporter);
        } else {
            tropicsTeleporter = new TeleporterTropics(player.func_184102_h().func_71218_a(TROPICS_DIMENSION_ID));
            PlayerList pl = player.func_184102_h().func_184103_al();
            pl.transferPlayerToDimension(player, TROPICS_DIMENSION_ID, (Teleporter)tropicsTeleporter);
        }
        long time2 = System.currentTimeMillis();
        System.out.printf("It took %f seconds to teleport\n", Float.valueOf((float)(time2 - time) / 1000.0f));
    }
}

