/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.donations;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.tropicraft.core.common.block.tileentity.TileEntityDonation;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.donations.CommandUser;
import net.tropicraft.core.common.donations.DonationData;
import net.tropicraft.core.common.donations.JsonDataDonation;
import net.tropicraft.core.common.donations.JsonDataDonationEntry;
import net.tropicraft.core.common.donations.JsonDeserializerDonation;
import net.tropicraft.core.common.donations.JsonDeserializerDonationTotal;
import net.tropicraft.core.common.donations.ThreadWorkerDonations;

public class TickerDonation {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(JsonDataDonation.class, (Object)new JsonDeserializerDonation()).create();
    public static final Gson GSON_TOTAL = new GsonBuilder().registerTypeAdapter(JsonDataDonation.class, (Object)new JsonDeserializerDonationTotal()).create();
    private static final Set<TileEntityDonation> callbacks = new HashSet<TileEntityDonation>();
    private static DonationData donationData;

    public static void tick(World world) {
        if (!ThreadWorkerDonations.getInstance().running && !TropicsConfigs.tiltifyAppToken.isEmpty() && TropicsConfigs.tiltifyCampaign != 0 && FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72394_k() > 0) {
            donationData = TickerDonation.getSavedData(world);
            ThreadWorkerDonations.getInstance().startThread(donationData);
        }
    }

    public static void callbackDonations(JsonDataDonation data) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> TickerDonation.processDonationsServer(data));
        } else {
            ThreadWorkerDonations.getInstance().stopThread();
            callbacks.clear();
        }
    }

    private static DonationData getSavedData(World world) {
        DonationData data = (DonationData)world.func_175693_T().func_75742_a(DonationData.class, "donationData");
        if (data == null) {
            data = new DonationData("donationData");
            world.func_175693_T().func_75745_a("donationData", (WorldSavedData)data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processDonationsServer(JsonDataDonation data) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world == null) {
            return;
        }
        data.new_donations.stream().sorted(Comparator.comparingLong(JsonDataDonationEntry::getDate)).filter(entry -> entry.getDate() > donationData.getLastSeenDate()).map(donation -> new TextComponentTranslation("tropicraft.donations.donation", new Object[]{TextFormatting.AQUA + donation.name + TextFormatting.RESET.toString(), TextFormatting.GREEN.toString() + NumberFormat.getCurrencyInstance(Locale.US).format(donation.amount) + TextFormatting.RESET})).forEach(msg -> {
            server.func_184103_al().func_181057_v().stream().forEach(p -> p.func_145747_a((ITextComponent)msg));
            callbacks.forEach(TileEntityDonation::triggerDonation);
        });
        long lastSeenDate = data.new_donations.stream().mapToLong(d -> d.getDate()).max().orElse(0L);
        int lastSeenId = data.new_donations.stream().mapToInt(d -> d.id).max().orElse(0);
        DonationData donationData = TickerDonation.donationData;
        synchronized (donationData) {
            TickerDonation.donationData.setLastSeenDate(Math.max(TickerDonation.donationData.getLastSeenDate(), lastSeenDate));
            TickerDonation.donationData.setLastSeenId(Math.max(TickerDonation.donationData.getLastSeenId(), lastSeenId));
            int amountPerMonument = TropicsConfigs.donationAmountPerMonument;
            if (amountPerMonument > 0) {
                while (TickerDonation.donationData.getMonumentsPlaced() < data.totalDonated / amountPerMonument) {
                    TickerDonation.donationData.setMonumentsPlaced(TickerDonation.donationData.getMonumentsPlaced() + 1);
                    server.func_71187_D().func_71556_a((ICommandSender)new CommandUser((World)world), TropicsConfigs.tiltifyCommandRun);
                }
            }
        }
    }

    public static void simulateDonation(String name, int amount) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world == null) {
            return;
        }
        if (!name.equals("")) {
            server.func_184103_al().func_181057_v().stream().forEach(p -> p.func_145747_a((ITextComponent)new TextComponentTranslation("tropicraft.donations.donation", new Object[]{TextFormatting.AQUA + name + TextFormatting.RESET.toString(), TextFormatting.GREEN.toString() + NumberFormat.getCurrencyInstance(Locale.US).format(amount) + TextFormatting.RESET})));
        }
        callbacks.forEach(TileEntityDonation::triggerDonation);
    }

    public static void addCallback(TileEntityDonation tile) {
        callbacks.add(tile);
    }

    public static void removeCallback(TileEntityDonation tile) {
        callbacks.remove((Object)tile);
    }
}

