/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.drinks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.Ingredient;
import net.tropicraft.core.common.drinks.MixerRecipe;
import net.tropicraft.core.registry.DrinkMixerRegistry;

public final class MixerRecipes {
    private static Map<Drink, Ingredient[]> drinkToIngredientsMap = new HashMap<Drink, Ingredient[]>();

    private MixerRecipes() {
    }

    public static void addMixerRecipes() {
        MixerRecipes.registerMixerRecipe(Drink.limeade, Ingredient.lime, Ingredient.sugar, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.caipirinha, Ingredient.lime, Ingredient.sugarcane, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.orangeade, Ingredient.orange, Ingredient.sugar, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.lemonade, Ingredient.lemon, Ingredient.sugar, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.blackCoffee, Ingredient.roastedCoffeeBean, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.pinaColada, Ingredient.pineappleCubes, Ingredient.coconutChunk);
        MixerRecipes.registerMixerRecipe(Drink.pinaColada, Ingredient.pineappleCubes, Ingredient.coconut);
        MixerRecipes.registerMixerRecipe(Drink.pinaColada, Ingredient.pineapple, Ingredient.coconutChunk);
        MixerRecipes.registerMixerRecipe(Drink.pinaColada, Ingredient.pineapple, Ingredient.coconut);
        MixerRecipes.registerMixerRecipe(Drink.coconutWater, Ingredient.coconut, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.maiTai, Ingredient.orange, Ingredient.lime, Ingredient.waterBucket);
    }

    private static void registerMixerRecipe(Drink result, Ingredient ... ingredients) {
        DrinkMixerRegistry.registerRecipe(new MixerRecipe(result, ingredients));
        drinkToIngredientsMap.put(result, ingredients);
    }

    public static ItemStack getItemStack(Drink drink) {
        NonNullList stack = NonNullList.func_191196_a();
        for (Ingredient i : drinkToIngredientsMap.get(drink)) {
            stack.add((Object)i.getIngredient());
        }
        return DrinkMixerRegistry.getResult((NonNullList<ItemStack>)stack);
    }

    public static boolean isValidRecipe(NonNullList<ItemStack> ingredientStacks) {
        HashSet<Ingredient> ingredients = new HashSet<Ingredient>();
        for (ItemStack stack : ingredientStacks) {
            Ingredient ingredient = Ingredient.findMatchingIngredient(stack);
            if (ingredient == null) {
                return false;
            }
            ingredients.add(ingredient);
            for (MixerRecipe recipe : DrinkMixerRegistry.getRecipes()) {
                HashSet<Ingredient> recipeIngredientSet = new HashSet<Ingredient>();
                for (Ingredient i : recipe.getIngredients()) {
                    recipeIngredientSet.add(i);
                }
                if (!ingredients.equals(recipeIngredientSet)) continue;
                return true;
            }
        }
        return false;
    }

    public static Drink getDrink(NonNullList<ItemStack> ingredientStacks) {
        HashSet<Ingredient> ingredients = new HashSet<Ingredient>();
        for (ItemStack stack : ingredientStacks) {
            Ingredient ingredient = Ingredient.findMatchingIngredient(stack);
            if (ingredient == null) {
                return null;
            }
            ingredients.add(ingredient);
            for (MixerRecipe recipe : DrinkMixerRegistry.getRecipes()) {
                HashSet<Ingredient> recipeIngredientSet = new HashSet<Ingredient>();
                for (Ingredient i : recipe.getIngredients()) {
                    recipeIngredientSet.add(i);
                }
                if (!ingredients.equals(recipeIngredientSet)) continue;
                return recipe.getCraftingResult();
            }
        }
        return null;
    }
}

