/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.entity.passive.EntityVMonkey;

public class EntityAIMonkeyFollowNearestWithCondition
extends EntityAIBase {
    private final EntityVMonkey entity;
    private final Predicate<EntityLivingBase> followPredicate;
    private final double speedModifier;
    private final PathNavigate navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;
    private final float areaSize;
    private int followCounter = 0;

    public EntityAIMonkeyFollowNearestWithCondition(EntityVMonkey entity, double speedModifier, float stopDistance, float areaSize, Predicate<EntityLivingBase> predicate) {
        this.entity = entity;
        this.followPredicate = predicate;
        this.speedModifier = speedModifier;
        this.navigation = entity.func_70661_as();
        this.stopDistance = stopDistance;
        this.areaSize = areaSize;
        this.func_75248_a(1);
        if (!(entity.func_70661_as() instanceof PathNavigateGround) && !(entity.func_70661_as() instanceof PathNavigateFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.entity.func_70906_o()) {
            return false;
        }
        if (this.entity.func_70909_n()) {
            return false;
        }
        if (this.entity.selfHoldingDrink(Drink.pinaColada)) {
            return false;
        }
        List list = this.entity.field_70170_p.func_175647_a(EntityPlayer.class, this.entity.func_174813_aQ().func_186662_g((double)this.areaSize), this.followPredicate);
        if (!list.isEmpty()) {
            for (EntityPlayer entityliving : list) {
                if (entityliving.func_82150_aj()) continue;
                this.entity.setFollowingEntity((EntityLivingBase)entityliving);
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.entity.getFollowingEntity() != null && this.entity.followingHoldingPinaColada() && !this.entity.func_70909_n();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.entity.setFollowingEntity(null);
        this.entity.setAngry(false);
        this.entity.func_70624_b(null);
        this.navigation.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        this.followCounter = 0;
    }

    public void func_75246_d() {
        if (this.entity.getFollowingEntity() != null && !this.entity.func_110167_bD()) {
            ++this.followCounter;
            if (this.followCounter >= 20) {
                this.entity.setAngry(true);
                this.entity.func_70624_b(this.entity.getFollowingEntity());
            }
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.getFollowingEntity(), 10.0f, (float)this.entity.func_70646_bf());
            if (this.entity.func_70068_e((Entity)this.entity.getFollowingEntity()) > (double)(this.stopDistance * this.stopDistance) && --this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                double d0 = this.entity.field_70165_t - this.entity.getFollowingEntity().field_70165_t;
                double d1 = this.entity.field_70163_u - this.entity.getFollowingEntity().field_70163_u;
                double d2 = this.entity.field_70161_v - this.entity.getFollowingEntity().field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 > (double)(this.stopDistance * this.stopDistance)) {
                    this.navigation.func_75497_a((Entity)this.entity.getFollowingEntity(), this.speedModifier);
                } else {
                    this.navigation.func_75499_g();
                    if (d3 <= (double)this.stopDistance) {
                        double d4 = this.entity.getFollowingEntity().field_70165_t - this.entity.field_70165_t;
                        double d5 = this.entity.getFollowingEntity().field_70161_v - this.entity.field_70161_v;
                        this.navigation.func_75492_a(this.entity.field_70165_t - d4, this.entity.field_70163_u, this.entity.field_70161_v - d5, this.speedModifier);
                    }
                }
            }
        }
    }
}

