/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.egg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityEgg
extends EntityLiving {
    private static final DataParameter<Integer> HATCH_DELAY = EntityDataManager.func_187226_a(EntityEgg.class, (DataSerializer)DataSerializers.field_187192_b);
    public double rotationRand;

    public EntityEgg(World w) {
        super(w);
        this.func_70105_a(0.4f, 0.5f);
        this.rotationRand = 0.0;
        this.field_70158_ak = true;
        this.field_70177_z = this.field_70146_Z.nextInt(360);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HATCH_DELAY, (Object)0);
        this.setHatchDelay(-60 + this.field_70146_Z.nextInt(120));
    }

    @SideOnly(value=Side.CLIENT)
    public abstract boolean shouldEggRenderFlat();

    public abstract String getEggTexture();

    public abstract Entity onHatch();

    public abstract int getHatchTime();

    public abstract int getPreHatchMovement();

    public int getRandomHatchDelay() {
        return (Integer)this.func_184212_Q().func_187225_a(HATCH_DELAY);
    }

    public boolean isHatching() {
        return this.field_70173_aa > this.getHatchTime() + this.getRandomHatchDelay();
    }

    public boolean isNearHatching() {
        return this.field_70173_aa > this.getHatchTime() + this.getRandomHatchDelay() - this.getPreHatchMovement();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isNearHatching()) {
            this.rotationRand += (double)(0.1707f * this.field_70170_p.field_73012_v.nextFloat());
            if (this.field_70173_aa >= this.getHatchTime() && !this.field_70170_p.field_72995_K) {
                Entity ent = this.onHatch();
                ent.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d(ent);
                this.func_70106_y();
            }
        }
    }

    public void func_70014_b(NBTTagCompound n) {
        n.func_74768_a("ticks", this.field_70173_aa);
        n.func_74768_a("hatchDelay", this.getHatchDelay());
        super.func_70014_b(n);
    }

    public void func_70037_a(NBTTagCompound n) {
        this.field_70173_aa = n.func_74762_e("ticks");
        this.setHatchDelay(n.func_74762_e("hatchDelay"));
        super.func_70037_a(n);
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
    }

    public void setHatchDelay(int i) {
        this.func_184212_Q().func_187227_b(HATCH_DELAY, (Object)(-60 + this.field_70146_Z.nextInt(120)));
    }

    public int getHatchDelay() {
        return (Integer)this.func_184212_Q().func_187225_a(HATCH_DELAY);
    }
}

