/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.hostile.EntityLostMask;

public abstract class EntityAshen
extends EntityMob
implements IRangedAttackMob {
    private static final DataParameter<Integer> MASK_TYPE = EntityDataManager.func_187226_a(EntityAshen.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ACTION_STATE = EntityDataManager.func_187226_a(EntityAshen.class, (DataSerializer)DataSerializers.field_187192_b);
    public float bobber;
    public int bobberHelper;
    public int actionPicker;
    public EntityLostMask maskToTrack;
    public Entity itemToTrack;

    public EntityAshen(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 1.3f);
        this.setMaskType(new Random().nextInt(7));
        this.actionPicker = 0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(MASK_TYPE, (Object)0);
        this.func_184212_Q().func_187214_a(ACTION_STATE, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getAttackStrength());
    }

    protected abstract double getAttackStrength();

    public void setMaskType(int type) {
        this.field_70180_af.func_187227_b(MASK_TYPE, (Object)type);
    }

    public int getMaskType() {
        return (Integer)this.field_70180_af.func_187225_a(MASK_TYPE);
    }

    public void setActionState(int state) {
        this.field_70180_af.func_187227_b(ACTION_STATE, (Object)state);
    }

    public int getActionState() {
        return (Integer)this.field_70180_af.func_187225_a(ACTION_STATE);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("MaskType", (short)this.getMaskType());
        nbttagcompound.func_74777_a("ActionState", (short)this.getActionState());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setMaskType(nbttagcompound.func_74765_d("MaskType"));
        this.setActionState(nbttagcompound.func_74765_d("ActionState"));
    }

    public boolean hasMask() {
        return this.getActionState() != 1;
    }

    public void dropMask() {
        this.setActionState(1);
        this.maskToTrack = new EntityLostMask(this.field_70170_p, this.getMaskType(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z);
        this.field_70170_p.func_72838_d((Entity)this.maskToTrack);
    }

    public void pickupMask(EntityLostMask mask) {
        this.setActionState(2);
        this.maskToTrack = null;
        this.setMaskType(mask.type);
        mask.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float amt) {
        boolean wasHit = super.func_70097_a(source, amt);
        if (!this.field_70170_p.field_72995_K && this.hasMask() && wasHit && !source.equals(DamageSource.field_76380_i)) {
            this.dropMask();
        }
        return wasHit;
    }
}

