/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.EntityLand;
import net.tropicraft.core.common.entity.projectile.EntityPoisonBlot;
import net.tropicraft.core.registry.ItemRegistry;

public class EntityTreeFrog
extends EntityLand
implements IMob,
IRangedAttackMob {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityTreeFrog.class, (DataSerializer)DataSerializers.field_187192_b);
    public int jumpDelay = 0;
    public boolean initialSet = false;
    private int attackTime;
    private EntityAINearestAttackableTarget<EntityPlayer> hostileAI;

    public EntityTreeFrog(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.4f);
        this.field_70144_Y = 0.8f;
        this.field_70728_aV = 5;
    }

    public boolean func_70601_bi() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)this.field_70146_Z.nextInt(4));
    }

    public EntityTreeFrog(World world, byte type) {
        this(world);
        this.setType(type);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        if (!this.initialSet) {
            this.setType(this.field_70146_Z.nextInt(Type.values().length));
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.hostileAI = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
        this.field_70715_bh.func_75776_a(1, this.hostileAI);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getType().equals((Object)Type.GREEN)) {
            this.field_70715_bh.func_85156_a(this.hostileAI);
        }
        if (!(this.func_70661_as().func_75500_f() && this.func_70638_az() == null || !this.field_70122_E && !this.func_70090_H())) {
            if (this.jumpDelay > 0) {
                --this.jumpDelay;
            }
            if (this.jumpDelay <= 0) {
                this.jumpDelay = 5 + this.field_70146_Z.nextInt(4);
                double speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                if (speed > 0.02) {
                    this.field_70181_x += 0.4;
                    this.field_70159_w *= 1.1;
                    this.field_70179_y *= 1.1;
                }
            }
        }
        if (this.attackTime > 0) {
            --this.attackTime;
        }
    }

    public void func_82196_d(EntityLivingBase entity, float f) {
        if (f < 4.0f && !this.field_70170_p.field_72995_K && this.attackTime == 0 && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            double d = entity.field_70165_t - this.field_70165_t;
            double d1 = entity.field_70161_v - this.field_70161_v;
            EntityPoisonBlot entitypoisonblot = new EntityPoisonBlot(this.field_70170_p, (EntityLivingBase)this);
            entitypoisonblot.field_70163_u += (double)1.4f;
            double d2 = entity.field_70163_u + (double)entity.func_70047_e() - (double)0.2f - entitypoisonblot.field_70163_u;
            float f1 = MathHelper.func_76133_a((double)(d * d + d1 * d1)) * 0.2f;
            this.field_70170_p.func_72838_d((Entity)entitypoisonblot);
            entitypoisonblot.func_70186_c(d, d2 + (double)f1, d1, 0.6f, 12.0f);
            this.attackTime = 50;
            this.field_70177_z = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f;
        }
    }

    public Type getType() {
        Type[] types;
        for (Type t : types = Type.values()) {
            if (t.ordinal() != ((Integer)this.func_184212_Q().func_187225_a(TYPE)).intValue()) continue;
            return t;
        }
        return null;
    }

    public void setType(int i) {
        this.func_184212_Q().func_187227_b(TYPE, (Object)i);
    }

    public void func_70014_b(NBTTagCompound n) {
        n.func_74768_a("frogType", this.getType().ordinal());
        super.func_70014_b(n);
    }

    public void func_70037_a(NBTTagCompound n) {
        this.setType(n.func_74762_e("frogType"));
        super.func_70037_a(n);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_145779_a(ItemRegistry.frogLeg, 2);
            if (this.getType() != Type.GREEN) {
                this.func_145779_a(ItemRegistry.poisonFrogSkin, 1);
            }
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public static enum Type {
        GREEN("green"),
        RED("red"),
        BLUE("blue"),
        YELLOW("yellow");

        final String color;

        private Type(String s) {
            this.color = s;
        }

        public String getColor() {
            return this.color;
        }
    }
}

