/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.ColorHelper;
import net.tropicraft.core.registry.ItemRegistry;

public class EntityChair
extends Entity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityChair.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityChair.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> COMESAILAWAY = EntityDataManager.func_187226_a(EntityChair.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(EntityChair.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityChair.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean isChairEmpty;
    private int chairPosRotationIncrements;
    private double chairX;
    private double chairY;
    private double chairZ;
    private double chairPitch;
    private double chairYaw;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private double speedMultiplier;

    public EntityChair(World world) {
        super(world);
        this.field_70158_ak = true;
        this.isChairEmpty = true;
        this.speedMultiplier = 0.1;
        this.field_70156_m = true;
        this.field_70144_Y = 0.95f;
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityChair(World world, double x, double y, double z, int color, EntityPlayer player) {
        this(world);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.setColor(color);
        this.field_70177_z = this.getAngleToPlayer(player);
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public void func_70071_h_() {
        double d12;
        double d11;
        int j;
        double d4;
        double d2;
        double d10;
        super.func_70071_h_();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        int b0 = 5;
        double d0 = 0.0;
        if (this.getComeSailAway()) {
            for (int i = 0; i < b0; ++i) {
                double d1 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)(i + 0) / (double)b0 - 0.125;
                double d3 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)(i + 1) / (double)b0 - 0.125;
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.func_174813_aQ().field_72340_a, d1, this.func_174813_aQ().field_72339_c, this.func_174813_aQ().field_72336_d, d3, this.func_174813_aQ().field_72334_f);
                if (!this.field_70170_p.func_72875_a(axisalignedbb, Material.field_151586_h)) continue;
                d0 += 1.0 / (double)b0;
            }
        }
        if ((d10 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.26249999999999996) {
            d2 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            d4 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            if (this.getComeSailAway()) {
                j = 0;
                while ((double)j < 1.0 + d10 * 60.0) {
                    double d9;
                    double d8;
                    double d5 = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                    double d6 = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                    if (this.field_70146_Z.nextBoolean()) {
                        d8 = this.field_70165_t - d2 * d5 * 0.8 + d4 * d6;
                        d9 = this.field_70161_v - d4 * d5 * 0.8 - d2 * d6;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, d8, this.field_70163_u - 0.125, d9, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                    } else {
                        d8 = this.field_70165_t + d2 + d4 * d5 * 0.7;
                        d9 = this.field_70161_v + d4 - d2 * d5 * 0.7;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, d8, this.field_70163_u - 0.125, d9, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                    }
                    ++j;
                }
            }
        }
        if (this.field_70170_p.field_72995_K && this.isChairEmpty) {
            if (this.chairPosRotationIncrements > 0) {
                d2 = this.field_70165_t + (this.chairX - this.field_70165_t) / (double)this.chairPosRotationIncrements;
                d4 = this.field_70163_u + (this.chairY - this.field_70163_u) / (double)this.chairPosRotationIncrements;
                d11 = this.field_70161_v + (this.chairZ - this.field_70161_v) / (double)this.chairPosRotationIncrements;
                d12 = MathHelper.func_76138_g((double)(this.chairYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d12 / (double)this.chairPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.chairPitch - (double)this.field_70125_A) / (double)this.chairPosRotationIncrements);
                --this.chairPosRotationIncrements;
                this.func_70107_b(d2, d4, d11);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                d2 = this.field_70165_t + this.field_70159_w;
                d4 = this.field_70163_u + this.field_70181_x;
                d11 = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(d2, d4, d11);
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
        } else {
            double d7;
            if (d0 < 1.0) {
                d2 = d0 * 2.0 - 1.0;
                this.field_70181_x += (double)0.04f * d2;
            } else {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x /= 2.0;
                }
                this.field_70181_x += (double)0.007f;
            }
            if (this.getComeSailAway() && this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
                float f = this.func_184179_bs().field_70177_z + -entitylivingbase.field_70702_br * 90.0f;
                this.field_70159_w += -Math.sin(f * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)entitylivingbase.field_191988_bg * (double)0.05f;
                this.field_70179_y += Math.cos(f * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)entitylivingbase.field_191988_bg * (double)0.05f;
            }
            if ((d2 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 0.45) {
                d4 = 0.45 / d2;
                this.field_70159_w *= d4;
                this.field_70179_y *= d4;
                d2 = 0.45;
            }
            if (d2 > d10 && this.speedMultiplier < 0.45) {
                this.speedMultiplier += (0.45 - this.speedMultiplier) / 45.0;
                if (this.speedMultiplier > 0.45) {
                    this.speedMultiplier = 0.45;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.1) / 45.0;
                if (this.speedMultiplier < 0.1) {
                    this.speedMultiplier = 0.1;
                }
            }
            if (this.getComeSailAway()) {
                for (int l = 0; l < 4; ++l) {
                    int i1 = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)(l % 2) - 0.5) * 0.8));
                    j = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)(l / 2) - 0.5) * 0.8));
                    for (int j1 = 0; j1 < 2; ++j1) {
                        int k = MathHelper.func_76128_c((double)this.field_70163_u) + j1;
                        Block block = this.field_70170_p.func_180495_p(new BlockPos(i1, k, j)).func_177230_c();
                        BlockPos pos = new BlockPos(i1, k, j);
                        if (block == Blocks.field_150431_aC) {
                            this.field_70170_p.func_175698_g(pos);
                            this.field_70123_F = false;
                            continue;
                        }
                        if (block != Blocks.field_150392_bi) continue;
                        this.field_70170_p.func_175698_g(pos);
                        this.field_70123_F = false;
                    }
                }
            }
            if (this.getComeSailAway() && this.field_70122_E) {
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            } else if (this.field_70122_E) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.getComeSailAway()) {
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
            this.field_70125_A = 0.0f;
            d4 = this.field_70177_z;
            d11 = this.field_70169_q - this.field_70165_t;
            d12 = this.field_70166_s - this.field_70161_v;
            if (d11 * d11 + d12 * d12 > 0.001) {
                d4 = (float)(Math.atan2(d12, d11) * 180.0 / Math.PI);
            }
            if ((d7 = MathHelper.func_76138_g((double)(d4 - (double)this.field_70177_z))) > 20.0) {
                d7 = 20.0;
            }
            if (d7 < -20.0) {
                d7 = -20.0;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + d7);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, 0.0, (double)0.2f));
                if (list != null && !list.isEmpty()) {
                    for (int k1 = 0; k1 < list.size(); ++k1) {
                        Entity entity = (Entity)list.get(k1);
                        if (entity == this.func_184179_bs() || !entity.func_70104_M() || !(entity instanceof EntityChair)) continue;
                        entity.func_70108_f((Entity)this);
                    }
                }
                if (this.func_184179_bs() != null && this.func_184179_bs().field_70128_L) {
                    this.func_184226_ay();
                }
            }
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(COLOR, (Object)ColorHelper.DEFAULT_VALUE);
        this.func_184212_Q().func_187214_a(DAMAGE, (Object)new Float(0.0f));
        this.func_184212_Q().func_187214_a(COMESAILAWAY, (Object)new Byte(0));
        this.func_184212_Q().func_187214_a(FORWARD_DIRECTION, (Object)new Integer(1));
        this.func_184212_Q().func_187214_a(TIME_SINCE_HIT, (Object)new Integer(0));
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setColor(nbt.func_74762_e("COLOR"));
        this.setComeSailAway(nbt.func_74767_n("COME_SAIL_AWAY"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("COLOR", Integer.valueOf(this.getColor()).intValue());
        nbt.func_74757_a("COME_SAIL_AWAY", Boolean.valueOf(this.getComeSailAway()).booleanValue());
    }

    public boolean func_70097_a(DamageSource damageSource, float par2) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamage(this.getDamage() + par2 * 10.0f);
            this.func_70018_K();
            boolean bl = flag = damageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)damageSource.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamage() > 40.0f) {
                if (!flag) {
                    this.func_70099_a(new ItemStack((Item)ItemRegistry.chair, 1, this.getDamageFromColor()), 0.0f);
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public int getDamageFromColor() {
        return ColorHelper.getDamageFromColor(this.getColor());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !player.func_70093_af()) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double xVelocity, double yVelocity, double zVelocity) {
        this.velocityX = this.field_70159_w = xVelocity;
        this.velocityY = this.field_70181_x = yVelocity;
        this.velocityZ = this.field_70179_y = zVelocity;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.5f;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 0.65;
    }

    private float getAngleToPlayer(EntityPlayer player) {
        float angle = MathHelper.func_76142_g((float)player.field_70177_z);
        return angle;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public void setColor(float red, float green, float blue) {
        this.field_70180_af.func_187227_b(COLOR, (Object)ColorHelper.getColor(red, green, blue));
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setComeSailAway(boolean sail) {
        this.field_70180_af.func_187227_b(COMESAILAWAY, (Object)(sail ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0)));
    }

    public boolean getComeSailAway() {
        return (Byte)this.field_70180_af.func_187225_a(COMESAILAWAY) == 1;
    }

    public void setForwardDirection(int dir) {
        this.field_70180_af.func_187227_b(FORWARD_DIRECTION, (Object)dir);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(FORWARD_DIRECTION);
    }

    public void setDamage(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damageTaken));
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }
}

