/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.egg.EntityEgg;

public abstract class EntityEchinoderm
extends EntityWaterMob {
    public static final int GROWTH_TICKS = 12000;
    public static final int BREEDING_COOLDOWN = 12000;
    public static final int BREEDING_PROXIMITY = 4;
    public static final int MAX_NEIGHBORS = 6;
    public static final int NEIGHBORHOOD_SIZE = 8;
    public static final int MATE_SCAN_INTERVAL = 100;
    private int prevGrowingAge;
    private int mateScanCooldown;
    private static final DataParameter<Integer> GROWING_AGE = EntityDataManager.func_187226_a(EntityEchinoderm.class, (DataSerializer)DataSerializers.field_187192_b);
    private double yOffset = -1.0;

    public EntityEchinoderm(World world) {
        super(world);
        this.setEchinodermSize();
    }

    public EntityEchinoderm(World world, boolean baby) {
        super(world);
        this.setGrowingAge(baby ? -12000 : 0);
        this.setEchinodermSize();
    }

    protected void func_184651_r() {
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70703_bu = false;
    }

    public boolean func_70097_a(DamageSource source, float amt) {
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(source, amt);
    }

    public void func_70653_a(Entity ent, float par2, double par3, double par5) {
    }

    public void func_70030_z() {
        super.func_70030_z();
        int growingAge = this.getGrowingAge();
        if (this.field_70170_p.field_72995_K) {
            this.field_70181_x = 0.0;
            if (growingAge != this.prevGrowingAge) {
                this.setEchinodermSize();
                this.prevGrowingAge = growingAge;
            }
        } else {
            this.field_70145_X = this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
            if (growingAge < 0) {
                this.setGrowingAge(growingAge + 1);
                this.setEchinodermSize();
            } else if (growingAge > 0) {
                this.setGrowingAge(growingAge - 1);
            }
            if (this.isHorny()) {
                if (this.mateScanCooldown > 0) {
                    --this.mateScanCooldown;
                } else {
                    this.mateScanCooldown = 100;
                    EntityEchinoderm mate = this.findMate();
                    if (mate != null) {
                        this.setGrowingAge(12000);
                        mate.setGrowingAge(12000);
                        EntityEgg egg = this.createEgg();
                        double newX = this.field_70165_t + 0.5 * (mate.field_70165_t - this.field_70165_t);
                        double newY = this.field_70163_u + 1.0;
                        double newZ = this.field_70161_v + 0.5 * (mate.field_70161_v - this.field_70161_v);
                        egg.func_70012_b(newX, newY, newZ, 0.0f, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)egg);
                    }
                }
            }
        }
    }

    public abstract EntityEgg createEgg();

    public boolean func_70631_g_() {
        return this.getGrowingAge() < 0;
    }

    public boolean isHorny() {
        return this.getGrowingAge() == 0;
    }

    private EntityEchinoderm findMate() {
        int neighbors = 0;
        EntityEchinoderm closestMate = null;
        double closestSqDist = -1.0;
        AxisAlignedBB aabb = this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0);
        for (Object obj : this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), aabb)) {
            double sqDist;
            if (obj == this) continue;
            ++neighbors;
            EntityEchinoderm other = (EntityEchinoderm)((Object)obj);
            if (!this.isPotentialMate(other) || !((sqDist = this.func_70068_e((Entity)other)) < 4.0) || closestSqDist != -1.0 && !(sqDist < closestSqDist)) continue;
            closestMate = other;
            closestSqDist = sqDist;
        }
        if (neighbors > 6) {
            return null;
        }
        return closestMate;
    }

    public boolean isPotentialMate(EntityEchinoderm other) {
        return !other.func_70631_g_() && other.isHorny();
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(GROWING_AGE, (Object)0);
    }

    public int getGrowingAge() {
        return (Integer)this.field_70180_af.func_187225_a(GROWING_AGE);
    }

    public void setGrowingAge(int age) {
        this.field_70180_af.func_187227_b(GROWING_AGE, (Object)age);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Age", this.getGrowingAge());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setGrowingAge(compound.func_74762_e("Age"));
    }

    public float getGrowthProgress() {
        int growingAge = this.getGrowingAge();
        float growthProgress = growingAge < 0 ? 1.0f + (float)growingAge / 12000.0f : 1.0f;
        return growthProgress;
    }

    private void setEchinodermSize() {
        float growthProgress = this.getGrowthProgress();
        float width = this.getBabyWidth() + growthProgress * (this.getAdultWidth() - this.getBabyWidth());
        float height = this.getBabyHeight() + growthProgress * (this.getAdultHeight() - this.getBabyHeight());
        float yO = this.getBabyYOffset() + growthProgress * (this.getAdultYOffset() - this.getBabyYOffset());
        this.func_70105_a(width, height);
        this.yOffset = yO;
    }

    public double func_70033_W() {
        if (this.yOffset < 0.0) {
            return super.func_70033_W();
        }
        return this.yOffset;
    }

    public abstract float getBabyWidth();

    public abstract float getAdultWidth();

    public abstract float getBabyHeight();

    public abstract float getAdultHeight();

    public abstract float getBabyYOffset();

    public abstract float getAdultYOffset();
}

