/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea.atlantoku;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicraftWaterBase;
import net.tropicraft.core.common.entity.underdasea.atlantoku.RodLink;
import net.tropicraft.core.registry.ItemRegistry;

public class EntityHook
extends Entity {
    private static final DataParameter<Integer> DATA_HOOKED_ID = EntityDataManager.func_187226_a(EntityHook.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> DATA_ANGLER_UUID = EntityDataManager.func_187226_a(EntityHook.class, (DataSerializer)DataSerializers.field_187194_d);
    private BlockPos pos = new BlockPos(-1, -1, -1);
    private Block inTile;
    private boolean inGround;
    public EntityPlayer angler;
    private int ticksInGround;
    private int ticksInAir;
    @SideOnly(value=Side.CLIENT)
    private double clientMotionX;
    @SideOnly(value=Side.CLIENT)
    private double clientMotionY;
    @SideOnly(value=Side.CLIENT)
    private double clientMotionZ;

    public EntityHook(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70158_ak = true;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityHook(World worldIn, double x, double y, double z, EntityPlayer anglerIn) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.field_70158_ak = true;
        this.angler = anglerIn;
    }

    public EntityHook(World worldIn, EntityPlayer fishingPlayer) {
        super(worldIn);
        this.field_70158_ak = true;
        this.angler = fishingPlayer;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(fishingPlayer.field_70165_t, fishingPlayer.field_70163_u + (double)fishingPlayer.func_70047_e(), fishingPlayer.field_70161_v, fishingPlayer.field_70177_z, fishingPlayer.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.8f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180))) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180))) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180))) * 0.4f;
        this.handleHookCasting(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5f, 1.0f);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ID, (Object)0);
        this.func_184212_Q().func_187214_a(DATA_ANGLER_UUID, (Object)"");
    }

    public void setHooked(Entity ent) {
        if (ent == null) {
            this.func_184212_Q().func_187227_b(DATA_HOOKED_ID, (Object)0);
            return;
        }
        if (ent instanceof EntityTropicraftWaterBase) {
            EntityTropicraftWaterBase fish = (EntityTropicraftWaterBase)ent;
            fish.setHook(this);
        }
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ID, (Object)ent.func_145782_y());
    }

    public Entity getHooked() {
        return this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ID)).intValue());
    }

    public void setAngler(EntityPlayer p) {
        if (p == null) {
            this.angler = null;
            this.func_184212_Q().func_187227_b(DATA_ANGLER_UUID, (Object)"");
            return;
        }
        this.func_184212_Q().func_187227_b(DATA_ANGLER_UUID, (Object)p.func_189512_bd());
        this.angler = p;
    }

    public EntityPlayer getAngler() {
        if (((String)this.func_184212_Q().func_187225_a(DATA_ANGLER_UUID)).length() == 0) {
            return null;
        }
        return this.field_70170_p.func_152378_a(UUID.fromString((String)this.func_184212_Q().func_187225_a(DATA_ANGLER_UUID)));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void handleHookCasting(double posX, double posY, double posZ, float p_146035_7_, float p_146035_8_) {
        float f = MathHelper.func_76133_a((double)(posX * posX + posY * posY + posZ * posZ));
        posX /= (double)f;
        posY /= (double)f;
        posZ /= (double)f;
        posX += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_146035_8_;
        posY += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_146035_8_;
        posZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_146035_8_;
        this.field_70159_w = posX *= (double)p_146035_7_;
        this.field_70181_x = posY *= (double)p_146035_7_;
        this.field_70179_y = posZ *= (double)p_146035_7_;
        float f1 = MathHelper.func_76133_a((double)(posX * posX + posZ * posZ));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)posX, (double)posZ) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)posY, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.field_70159_w = this.clientMotionX;
        this.field_70181_x = this.clientMotionY;
        this.field_70179_y = this.clientMotionZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        this.clientMotionX = this.field_70159_w;
        this.clientMotionY = this.field_70181_x;
        this.clientMotionZ = this.field_70179_y;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.angler = this.getAngler();
        }
        if (this.angler == null) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack itemstack = this.angler.func_184614_ca();
            if (this.angler.field_70128_L || !this.angler.func_70089_S() || itemstack.func_190926_b() || itemstack.func_77973_b() != ItemRegistry.fishingRod || this.func_70068_e((Entity)this.angler) > 1024.0) {
                this.func_70106_y();
                return;
            }
        }
        if (this.inGround) {
            if (this.field_70170_p.func_180495_p(this.pos).func_177230_c() == this.inTile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.func_70106_y();
                }
                return;
            }
            this.inGround = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        if (!this.field_70170_p.field_72995_K) {
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult result = this.field_70170_p.func_72933_a(vec3d1, vec3d);
            vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (result != null) {
                vec3d = new Vec3d(result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
            double d0 = 0.0;
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                AxisAlignedBB axisalignedbb1;
                RayTraceResult raytraceresult1;
                Entity entity1 = (Entity)list.get(j);
                if (!this.canBeHooked(entity1) || entity1 == this.angler && this.ticksInAir < 5 || (raytraceresult1 = (axisalignedbb1 = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d1, vec3d)) == null || !((d1 = vec3d1.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                result = new RayTraceResult(entity);
            }
            if (result != null) {
                if (result.field_72308_g != null) {
                    if (this.getHooked() == null) {
                        this.setHooked(result.field_72308_g);
                    }
                } else {
                    this.inGround = true;
                }
            }
        }
        if (!this.inGround) {
            if (this.field_70170_p.func_72875_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, 0.0), Material.field_151586_h)) {
                if (this.field_70181_x < (double)-0.05f) {
                    this.field_70181_x = -0.05f;
                }
                this.field_70181_x += 0.01;
            } else {
                if (this.field_70181_x > 0.0) {
                    this.field_70181_x *= 0.9;
                }
                this.field_70181_x -= 0.02;
            }
            this.field_70159_w *= 0.9;
            this.field_70179_y *= 0.9;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.getHooked() != null) {
                this.func_70107_b(this.getHooked().field_70165_t, this.getHooked().field_70163_u + (double)(this.getHooked().field_70131_O * 0.5f), this.getHooked().field_70161_v);
            }
        }
    }

    protected boolean canBeHooked(Entity e) {
        if (e instanceof EntityTropicraftWaterBase) {
            return ((EntityTropicraftWaterBase)e).isFishable();
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.pos.func_177958_n());
        compound.func_74768_a("yTile", this.pos.func_177956_o());
        compound.func_74768_a("zTile", this.pos.func_177952_p());
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
        compound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.pos = new BlockPos(compound.func_74762_e("xTile"), compound.func_74762_e("yTile"), compound.func_74762_e("zTile"));
        this.inTile = compound.func_150297_b("inTile", 8) ? Block.func_149684_b((String)compound.func_74779_i("inTile")) : Block.func_149729_e((int)(compound.func_74771_c("inTile") & 0xFF));
        this.inGround = compound.func_74771_c("inGround") == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 31 && this.field_70170_p.field_72995_K && this.getHooked() instanceof EntityPlayer && ((EntityPlayer)this.getHooked()).func_175144_cb()) {
            this.bringInHookedEntity();
        }
        super.func_70103_a(id);
    }

    public void bringInHookedEntity() {
        double d0 = this.angler.field_70165_t - this.field_70165_t;
        double d1 = this.angler.field_70163_u - this.field_70163_u;
        double d2 = this.angler.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
        this.getHooked().field_70159_w += d0 * 0.05;
        this.getHooked().field_70181_x += d1 * 0.05 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
        this.getHooked().field_70179_y += d2 * 0.05;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.angler != null && !this.field_70170_p.field_72995_K) {
            RodLink.destroyLink(this, this.angler);
        }
    }
}

