/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea.atlantoku;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.EntityLand;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityMarlin;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityPiranha;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntitySeahorse;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicalFish;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicraftWaterBase;
import net.tropicraft.core.common.entity.underdasea.atlantoku.IPredatorDiet;
import net.tropicraft.core.registry.ItemRegistry;

public class EntityShark
extends EntityTropicraftWaterBase
implements IPredatorDiet {
    private static final DataParameter<Boolean> IS_BOSS = EntityDataManager.func_187226_a(EntityShark.class, (DataSerializer)DataSerializers.field_187198_h);
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
    private ArrayList<EntityPlayerMP> bossTargets = new ArrayList();
    private boolean hasSetBoss = false;

    public EntityShark(World world) {
        super(world);
        this.setSwimSpeeds(1.3f, 2.0f, 0.8f, 3.0f, 5.0f);
        this.func_70105_a(2.4f, 0.5f);
        this.setExpRate(5);
        this.setApproachesPlayers(true);
        this.setFishable(true);
        this.setDropStack(ItemRegistry.fertilizer, 3);
        this.setMaxHealth(10);
        this.setAttackDamage(4.0f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_BOSS, (Object)false);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isBoss()) {
            if (!this.hasSetBoss) {
                this.setBossTraits();
            }
            if (!this.field_70170_p.field_72995_K) {
                EntityPlayer nearest = this.field_70170_p.func_72890_a((Entity)this, 64.0);
                if (nearest != null) {
                    if (this.func_70685_l((Entity)nearest) && nearest.func_70090_H() && !nearest.func_184812_l_() && !nearest.field_70128_L) {
                        this.aggressTarget = nearest;
                        this.setTargetHeading(this.aggressTarget.field_70165_t, this.aggressTarget.field_70163_u + 1.0, this.aggressTarget.field_70161_v, true);
                        if (nearest instanceof EntityPlayerMP && !this.bossInfo.func_186757_c().contains(nearest)) {
                            this.bossTargets.add((EntityPlayerMP)nearest);
                            this.bossInfo.func_186760_a((EntityPlayerMP)nearest);
                        }
                    } else {
                        this.clearBossTargets();
                    }
                } else {
                    this.clearBossTargets();
                }
                if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 80 == 0 && this.aggressTarget == null) {
                    this.func_70691_i(1.0f);
                    this.func_70656_aK();
                }
                this.bossInfo.func_186735_a(this.rangeMap(this.func_110143_aJ(), 0.0f, this.func_110138_aP(), 0.0f, 1.0f));
            }
        }
    }

    private void clearBossTargets() {
        if (this.bossTargets.size() > 0) {
            for (EntityPlayerMP p : this.bossTargets) {
                this.bossInfo.func_186761_b(p);
            }
            this.bossTargets.clear();
        }
    }

    private void setBossTraits() {
        this.func_70105_a(2.5f, 1.5f);
        this.setAttackDamage(8.0f);
        this.setDropStack(ItemRegistry.yellowFlippers, 1);
        this.func_96094_a("Elder Hammerhead");
        this.setSwimSpeeds(1.1f, 2.2f, 1.5f, 3.0f, 5.0f);
        this.setMaxHealth(20);
        this.setFishable(false);
        this.setExpRate(20);
        this.setTexture("hammerhead4");
        if (!this.field_70170_p.field_72995_K) {
            this.bossInfo.func_186739_a((ITextComponent)new TextComponentString("Elder Hammerhead"));
        }
        this.hasSetBoss = true;
    }

    public EntityShark setBoss() {
        this.func_184212_Q().func_187227_b(IS_BOSS, (Object)true);
        return this;
    }

    public boolean isBoss() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BOSS);
    }

    @Override
    public String[] getTexturePool() {
        return new String[]{"hammerhead1", "hammerhead2", "hammerhead3"};
    }

    @Override
    public Class[] getPreyClasses() {
        return new Class[]{EntityTropicalFish.class, EntityPiranha.class, EntityMarlin.class, EntityPlayer.class, EntitySeahorse.class, EntityLand.class};
    }

    @Override
    public void func_70014_b(NBTTagCompound n) {
        n.func_74757_a("isBoss", this.isBoss());
        super.func_70014_b(n);
    }

    public void func_70106_y() {
        this.clearBossTargets();
        this.bossInfo.func_186758_d(false);
        super.func_70106_y();
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        if (this.bossInfo.func_186757_c().contains(player)) {
            this.bossInfo.func_186761_b(player);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound n) {
        if (n.func_74767_n("isBoss")) {
            this.setBoss();
        }
        super.func_70037_a(n);
    }

    @Override
    public boolean func_70692_ba() {
        return this.isBoss() ? false : super.func_70692_ba();
    }
}

