/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.item.scuba.ItemScubaGear;
import net.tropicraft.core.common.item.scuba.ItemScubaHelmet;
import net.tropicraft.core.common.item.scuba.ScubaCapabilities;
import net.tropicraft.core.common.item.scuba.api.IAirType;
import net.tropicraft.core.common.item.scuba.api.IScubaGear;
import net.tropicraft.core.common.item.scuba.api.IScubaTank;
import net.tropicraft.core.common.item.scuba.api.ScubaMaterial;

public class ItemScubaChestplateGear
extends ItemScubaGear {
    public static final int UPDATE_RATE = 20;

    public ItemScubaChestplateGear(ItemArmor.ArmorMaterial material, ScubaMaterial scubaMaterial, int renderIndex, EntityEquipmentSlot slot) {
        super(material, scubaMaterial, renderIndex, slot);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        IScubaGear cap = (IScubaGear)itemstack.getCapability(ScubaCapabilities.getGearCapability(), null);
        ItemStack leftTank = cap.getStackInSlot(0);
        ItemStack rightTank = cap.getStackInSlot(1);
        String suitType = this.scubaMaterial.getDisplayName();
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tropicraft.gui.suit.type", (Object[])new Object[]{TextFormatting.GRAY + suitType}));
        tooltip.add("");
        if (leftTank.func_190926_b()) {
            tooltip.add(I18n.func_135052_a((String)"tropicraft.gui.gear.tank.left.none", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tropicraft.gui.gear.tank.left.info", (Object[])new Object[0]));
            leftTank.func_77973_b().func_77624_a(leftTank, world, tooltip, flagIn);
            tooltip.add("");
        }
        if (rightTank.func_190926_b()) {
            tooltip.add(I18n.func_135052_a((String)"tropicraft.gui.gear.tank.right.none", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tropicraft.gui.gear.tank.right.info", (Object[])new Object[0]));
            rightTank.func_77973_b().func_77624_a(rightTank, world, tooltip, flagIn);
        }
        tooltip.add(I18n.func_135052_a((String)"tropicraft.gui.gear.tank.click", (Object[])new Object[0]));
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return ScubaCapabilities.getProvider(ScubaCapabilities.getGearCapability(), () -> {
            IScubaGear.ScubaGear ret = new IScubaGear.ScubaGear(){

                @Override
                public void markDirty() {
                    stack.func_77982_d(this.serializeNBT());
                }
            };
            if (stack.func_77942_o()) {
                ret.deserializeNBT(stack.func_77978_p());
            }
            return ret;
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack noTank = new ItemStack((Item)this, 1, 0);
        list.add((Object)noTank);
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    @Override
    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, EnumHand hand) {
        if (entityplayer.func_70093_af()) {
            ItemStack itemstack = entityplayer.func_184586_b(hand);
            entityplayer.openGui((Object)Tropicraft.instance, 0, world, hand.ordinal(), 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return super.func_77659_a(world, entityplayer, hand);
    }

    @Override
    public void onScubaTick(World world, EntityPlayer player, ItemStack itemstack) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (!world.field_72995_K && world.func_82737_E() % 20L == 0L) {
            float air;
            IScubaGear gear;
            IScubaTank tankToEmpty;
            ItemStack helmetStack = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!itemstack.func_190926_b() && !helmetStack.func_190926_b() && helmetStack.func_77973_b() instanceof ItemScubaHelmet && (tankToEmpty = (gear = (IScubaGear)itemstack.getCapability(ScubaCapabilities.getGearCapability(), null)).getFirstNonEmptyTank()) != null && (air = tankToEmpty.getPressure()) > 0.0f) {
                IAirType airType = tankToEmpty.getAirType();
                tankToEmpty.setPressure(Math.max(0.0f, air - airType.getUsageRate()));
                gear.markDirty();
                player.func_70050_g(300);
            }
        }
    }

    @Override
    protected void onRemovedFromArmorInventory(World world, EntityPlayer player, ItemStack itemstack) {
    }
}

