/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.tropicraft.core.common.event.ScubaHandlerCommon;
import net.tropicraft.core.common.network.TCPacketHandler;

public class MessagePlayerSwimData
implements IMessage {
    public PlayerSwimData data;

    public MessagePlayerSwimData() {
    }

    public MessagePlayerSwimData(PlayerSwimData d) {
        this.data = d;
    }

    public void fromBytes(ByteBuf buf) {
        UUID uuid = new UUID(buf.readLong(), buf.readLong());
        if (this.data == null) {
            this.data = new PlayerSwimData(uuid);
        }
        this.data.rotationYawHead = buf.readFloat();
        this.data.prevRotationYawHead = buf.readFloat();
        this.data.rotationYaw = buf.readFloat();
        this.data.prevRotationYaw = buf.readFloat();
        this.data.renderYawOffset = buf.readFloat();
        this.data.prevRenderYawOffset = buf.readFloat();
        this.data.rotationPitch = buf.readFloat();
        this.data.prevRotationPitch = buf.readFloat();
        this.data.targetRotationPitch = MathHelper.func_76142_g((float)buf.readFloat());
        this.data.targetRotationYaw = MathHelper.func_76142_g((float)buf.readFloat());
        this.data.targetRotationRoll = MathHelper.func_76142_g((float)buf.readFloat());
        this.data.currentRotationPitch = buf.readFloat();
        this.data.currentRotationYaw = buf.readFloat();
        this.data.currentRotationRoll = buf.readFloat();
        this.data.targetHeadPitchOffset = buf.readFloat();
        this.data.currentHeadPitchOffset = buf.readFloat();
        this.data.currentSwimSpeed = buf.readFloat();
        this.data.targetSwimSpeed = buf.readFloat();
        this.data.currentHeight = buf.readFloat();
        this.data.targetHeight = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.data.playerUUID.getMostSignificantBits());
        buf.writeLong(this.data.playerUUID.getLeastSignificantBits());
        buf.writeFloat(this.data.rotationYawHead);
        buf.writeFloat(this.data.prevRotationYawHead);
        buf.writeFloat(this.data.rotationYaw);
        buf.writeFloat(this.data.prevRotationYaw);
        buf.writeFloat(this.data.renderYawOffset);
        buf.writeFloat(this.data.prevRenderYawOffset);
        buf.writeFloat(this.data.rotationPitch);
        buf.writeFloat(this.data.prevRotationPitch);
        buf.writeFloat(this.data.targetRotationPitch);
        buf.writeFloat(this.data.targetRotationYaw);
        buf.writeFloat(this.data.targetRotationRoll);
        buf.writeFloat(this.data.currentRotationPitch);
        buf.writeFloat(this.data.currentRotationYaw);
        buf.writeFloat(this.data.currentRotationRoll);
        buf.writeFloat(this.data.targetHeadPitchOffset);
        buf.writeFloat(this.data.currentHeadPitchOffset);
        buf.writeFloat(this.data.currentSwimSpeed);
        buf.writeFloat(this.data.targetSwimSpeed);
        buf.writeFloat(this.data.currentHeight);
        buf.writeFloat(this.data.targetHeight);
    }

    public static final class Handler
    implements IMessageHandler<MessagePlayerSwimData, IMessage> {
        public IMessage onMessage(MessagePlayerSwimData message, MessageContext ctx) {
            if (ctx.side.equals((Object)Side.SERVER)) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (!ScubaHandlerCommon.rotationMap.containsKey(player.func_110124_au())) {
                    ScubaHandlerCommon.rotationMap.put(player.func_110124_au(), message.data);
                } else {
                    PlayerSwimData localData = ScubaHandlerCommon.rotationMap.get(player.func_110124_au());
                    PlayerSwimData d = message.data;
                    localData.rotationYawHead = d.rotationYawHead;
                    localData.prevRotationYawHead = d.prevRotationYawHead;
                    localData.rotationYaw = d.rotationYaw;
                    localData.prevRotationYaw = d.prevRotationYaw;
                    localData.renderYawOffset = d.renderYawOffset;
                    localData.prevRenderYawOffset = d.prevRenderYawOffset;
                    localData.rotationPitch = d.rotationPitch;
                    localData.prevRotationPitch = d.prevRotationPitch;
                    localData.targetRotationPitch = d.targetRotationPitch;
                    localData.targetRotationYaw = d.targetRotationYaw;
                    localData.targetRotationRoll = d.targetRotationRoll;
                    localData.currentRotationPitch = d.currentRotationPitch;
                    localData.currentRotationYaw = d.currentRotationYaw;
                    localData.currentRotationRoll = d.currentRotationRoll;
                    localData.targetHeadPitchOffset = d.targetHeadPitchOffset;
                    localData.currentHeadPitchOffset = d.currentHeadPitchOffset;
                }
                BlockPos p = player.func_180425_c();
                TCPacketHandler.INSTANCE.sendToAllAround(message, new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), (double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), 32.0));
            }
            return null;
        }
    }

    public static class PlayerSwimData {
        public UUID playerUUID;
        public float rotationYawHead = 0.0f;
        public float prevRotationYawHead = 0.0f;
        public float rotationYaw = 0.0f;
        public float prevRotationYaw = 0.0f;
        public float renderYawOffset = 0.0f;
        public float prevRenderYawOffset = 0.0f;
        public float rotationPitch = 0.0f;
        public float prevRotationPitch = 0.0f;
        public float targetRotationPitch = 0.0f;
        public float targetRotationYaw = 0.0f;
        public float targetRotationRoll = 0.0f;
        public float currentRotationPitch = 0.0f;
        public float currentRotationYaw = 0.0f;
        public float currentRotationRoll = 0.0f;
        public float targetHeadPitchOffset = 0.0f;
        public float currentHeadPitchOffset = 0.0f;
        public float currentSwimSpeed = 0.0f;
        public float targetSwimSpeed = 0.0f;
        public float currentHeight = 1.8f;
        public float targetHeight = 1.8f;

        public PlayerSwimData(UUID associatedPlayer) {
            this.playerUUID = associatedPlayer;
        }
    }
}

