/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public abstract class TCGenBase
extends WorldGenerator {
    protected World worldObj;
    protected Random rand;
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    public static final int MAX_CHUNK_HEIGHT = 256;
    protected List<Block> standardAllowedBlocks = Arrays.asList(Blocks.field_150350_a, Blocks.field_150362_t, Blocks.field_150329_H, Blocks.field_150431_aC, Blocks.field_150433_aE);
    public static final int BLOCK_GEN_NOTIFY_FLAG_DEFAULT = 2;
    public static int blockGenNotifyFlag = 2;

    public TCGenBase(World world, Random random) {
        this.worldObj = world;
        this.rand = random;
    }

    public boolean isLeafBlock(Block block) {
        return block == Blocks.field_150362_t || block == BlockRegistry.leaves;
    }

    public abstract boolean generate(BlockPos var1);

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        this.worldObj = world;
        this.rand = rand;
        return this.generate(pos);
    }

    protected boolean genCircle(int x, int y, int z, double outerRadius, double innerRadius, IBlockState state, boolean solid) {
        return this.genCircle(new BlockPos(x, y, z), outerRadius, innerRadius, state, solid);
    }

    public boolean genCircle(BlockPos pos, double outerRadius, double innerRadius, IBlockState state, boolean solid) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean hasGenned = false;
        for (int i = (int)(-outerRadius - 1.0) + x; i <= (int)(outerRadius + 1.0) + x; ++i) {
            for (int k = (int)(-outerRadius - 1.0) + z; k <= (int)(outerRadius + 1.0) + z; ++k) {
                BlockPos pos2;
                double d = (i - x) * (i - x) + (k - z) * (k - z);
                if (!(d <= outerRadius * outerRadius) || !(d >= innerRadius * innerRadius) || !this.worldObj.func_175623_d(pos2 = new BlockPos(i, y, k)) && !solid || !this.worldObj.func_180501_a(pos2, state, blockGenNotifyFlag)) continue;
                hasGenned = true;
            }
        }
        return hasGenned;
    }

    public boolean checkCircle(BlockPos pos, double outerRadius, double innerRadius, List<Block> allowedBlockList) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int x = (int)(-outerRadius - 2.0) + i; x < (int)(outerRadius + 2.0) + i; ++x) {
            for (int z = (int)(-outerRadius - 2.0) + k; z < (int)(outerRadius + 2.0) + k; ++z) {
                BlockPos pos2;
                double d = (i - x) * (i - x) + (k - z) * (k - z);
                if (!(d <= outerRadius * outerRadius) || !(d >= innerRadius * innerRadius) || allowedBlockList.contains(this.worldObj.func_180495_p(pos2 = new BlockPos(x, j, z)).func_177230_c())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkBlockLine(int[] ai, int[] ai1, List<Block> allowedBlockList) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return false;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            BlockPos pos = new BlockPos(ai3[0], ai3[1], ai3[2]);
            if (allowedBlockList.contains(this.worldObj.func_180495_p(pos).func_177230_c())) continue;
            return false;
        }
        return true;
    }

    public ArrayList<int[]> placeBlockLine(int[] ai, int[] ai1, IBlockState state) {
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            BlockPos pos = new BlockPos(ai3[0], ai3[1], ai3[2]);
            this.worldObj.func_180501_a(pos, state, blockGenNotifyFlag);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
        }
        return places;
    }

    public boolean checkBlockCircleLine(int[] ai, int[] ai1, double outerRadius, double innerRadius, List<Block> allowedBlockList) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return false;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            BlockPos pos = new BlockPos(ai3[0], ai3[1], ai3[2]);
            if (this.checkCircle(pos, outerRadius, innerRadius, allowedBlockList)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<int[]> checkAndPlaceBlockCircleLine(int[] ai, int[] ai1, double outerRadius, double innerRadius, IBlockState state, List<Block> allowedBlockList) {
        BlockPos pos;
        int k;
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            pos = new BlockPos(ai3[0], ai3[1], ai3[2]);
            if (this.checkCircle(pos, outerRadius, innerRadius, allowedBlockList)) continue;
            return null;
        }
        l = ai2[j] + byte3;
        for (k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            pos = new BlockPos(ai3[0], ai3[1], ai3[2]);
            this.genCircle(pos, outerRadius, innerRadius, state, true);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
        }
        return places;
    }

    public ArrayList<int[]> checkAndPlaceBlockLine(int[] ai, int[] ai1, IBlockState state, List allowedBlockList) {
        BlockPos pos;
        int k;
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            pos = TCGenUtils.getBlockPos(ai3);
            if (allowedBlockList.contains(this.worldObj.func_180495_p(pos))) continue;
            return null;
        }
        l = ai2[j] + byte3;
        while (k != l) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            pos = TCGenUtils.getBlockPos(ai3);
            this.worldObj.func_180501_a(pos, state, blockGenNotifyFlag);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
            k += byte3;
        }
        return places;
    }

    public ArrayList<int[]> placeBlockCircleLine(int[] ai, int[] ai1, double distance, double distance2, IBlockState state) {
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.genCircle(TCGenUtils.getBlockPos(ai3), distance, distance2, state, true);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
        }
        return places;
    }

    public void genSphere(BlockPos pos, int outerRadius, IBlockState state) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int i = x - outerRadius; i < x + outerRadius; ++i) {
            for (int j = y - outerRadius; j < y + outerRadius; ++j) {
                for (int k = z - outerRadius; k < z + outerRadius; ++k) {
                    int distance1;
                    if (!this.worldObj.func_175623_d(TCGenUtils.getBlockPos(i, j, k)) || (distance1 = (i - x) * (i - x) + (j - y) * (j - y) + (k - z) * (k - z)) > outerRadius) continue;
                    BlockPos pos2 = TCGenUtils.getBlockPos(i, j, k);
                    this.worldObj.func_180501_a(pos2, state, blockGenNotifyFlag);
                }
            }
        }
    }

    public int getTerrainHeightAt(int x, int z) {
        int height;
        for (int y = height = this.worldObj.func_175645_m(TCGenUtils.getBlockPos(x, 0, z)).func_177956_o() + 1; y > 0; --y) {
            Block block = this.worldObj.func_180495_p(TCGenUtils.getBlockPos(x, y, z)).func_177230_c();
            if (block != Blocks.field_150346_d && block != Blocks.field_150349_c && block != Blocks.field_150354_m && block != Blocks.field_150348_b) continue;
            return y + 1;
        }
        return 0;
    }

    public double randAngle() {
        return this.rand.nextDouble() * Math.PI * 2.0;
    }

    protected int getHeight(int x, int z) {
        return this.worldObj.func_175645_m(new BlockPos(x, 0, z)).func_177956_o();
    }
}

