/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.worldgen.TCGenBase;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public class WorldGenBamboo
extends TCGenBase {
    private int minBamboo;
    private int maxBamboo;
    private static final int MIN_HEIGHT = 4;
    private static final int MAX_HEIGHT = 11;
    private static final IBlockState BAMBOO_BLOCK_STATE = BlockRegistry.bambooShoot.func_176223_P();

    public WorldGenBamboo(World world, Random random) {
        super(world, random);
        if (world.field_73011_w.getDimension() == TropicsConfigs.tropicsDimensionID) {
            this.minBamboo = TropicsConfigs.minBambooPerPatchOverworld;
            this.maxBamboo = TropicsConfigs.maxBambooPerPatchOverworld;
        } else {
            this.minBamboo = TropicsConfigs.minBambooPerPatchTropics;
            this.maxBamboo = TropicsConfigs.maxBambooPerPatchTropics;
        }
    }

    @Override
    public boolean generate(BlockPos pos) {
        pos = pos.func_177982_a(8, 0, 8);
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        j = this.getTerrainHeightAt(i, k);
        if (!TCGenUtils.isAirBlock((IBlockAccess)this.worldObj, pos = new BlockPos(i, j, k))) {
            return false;
        }
        int amount = this.rand.nextInt(this.maxBamboo - this.minBamboo) + this.minBamboo;
        int spread = this.rand.nextInt(3) - 1 + (int)(Math.sqrt(amount) / 2.0);
        block0: for (int l = 0; l < amount; ++l) {
            boolean genStalk = true;
            if (!genStalk) continue;
            int x = i + this.rand.nextInt(spread);
            int z = k + this.rand.nextInt(spread);
            int y = this.getTerrainHeightAt(x, z) - 1;
            int height = this.rand.nextInt(7) + 4;
            BlockPos bpos = new BlockPos(x, y, z);
            for (int h = 0; h < height; ++h) {
                bpos = bpos.func_177984_a();
                boolean canPlace = BlockRegistry.bambooShoot.func_176354_d(this.worldObj, bpos);
                if (!TCGenUtils.isAirBlock((IBlockAccess)this.worldObj, bpos) || !canPlace) continue block0;
                this.worldObj.func_180501_a(bpos, BAMBOO_BLOCK_STATE, blockGenNotifyFlag);
            }
        }
        return true;
    }
}

