/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.BlockTropicraftLeaves;
import net.tropicraft.core.common.block.BlockTropicraftLog;
import net.tropicraft.core.common.enums.TropicraftLeaves;
import net.tropicraft.core.common.enums.TropicraftLogs;
import net.tropicraft.core.common.worldgen.TCDirectionalGen;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public class WorldGenCurvedPalms
extends TCDirectionalGen {
    private static final int TOP_OFFSET = 3;
    private static final IBlockState woodState = BlockRegistry.logs.func_176223_P().func_177226_a(BlockTropicraftLog.VARIANT, (Comparable)((Object)TropicraftLogs.PALM));
    private static final IBlockState leafState = BlockRegistry.leaves.func_176223_P().func_177226_a(BlockTropicraftLeaves.VARIANT, (Comparable)((Object)TropicraftLeaves.PALM));

    public WorldGenCurvedPalms(World world, Random rand) {
        super(world, rand);
    }

    @Override
    public boolean generate(BlockPos pos) {
        int y;
        int x;
        if (TCGenUtils.getBlockState((IBlockAccess)this.worldObj, pos.func_177977_b()).func_185904_a() != Material.field_151595_p) {
            return false;
        }
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        int height = 9 + this.rand.nextInt(3);
        int dir = this.pickDirection(i, j, k);
        this.setDir(dir);
        this.setOrigin(i, k);
        for (x = 0; x < 4; ++x) {
            for (y = 0; y < height; ++y) {
                if (this.getBlockWithDir(x, y + j, 0) == Blocks.field_150350_a) continue;
                return false;
            }
        }
        for (x = 0; x < 9; ++x) {
            for (int z = 0; z < 9; ++z) {
                for (int y2 = height - 3; y2 < height + 4; ++y2) {
                    if (this.getBlockWithDir(x + 3, y2 + j, z) == Blocks.field_150350_a) continue;
                    return false;
                }
            }
        }
        x = 0;
        for (y = 0; y < height; ++y) {
            this.placeBlockWithDir(x, y + j, 0, woodState);
            if (y != 0 && y != 1 && y != 3) continue;
            this.placeBlockWithDir(++x, y + j, 0, woodState);
        }
        this.setOrigin(this.getActualXAt(3, 0), this.getActualZAt(3, 0));
        for (int y3 = 1; y3 < 5; ++y3) {
            if (y3 == 4) {
                this.placeBlockWithDir(1, y3 + j + height - 1, 0, leafState);
                continue;
            }
            this.placeBlockWithDir(0, y3 + j + height - 1, 0, leafState);
        }
        for (int curDir = 0; curDir < 4; ++curDir) {
            this.setDir(curDir);
            y = height - 1;
            this.placeBlockWithDir(1, y - 1 + j, 1, leafState);
            this.placeBlockWithDir(2, y - 2 + j, 1, leafState);
            this.placeBlockWithDir(1, y - 2 + j, 2, leafState);
            this.placeBlockWithDir(2, y - 3 + j, 2, leafState);
            this.placeBlockWithDir(1, y + 1 + j, 1, leafState);
            this.placeBlockWithDir(2, y + 2 + j, 1, leafState);
            this.placeBlockWithDir(1, y + 2 + j, 2, leafState);
            this.placeBlockWithDir(2, y + 3 + j, 2, leafState);
            for (int x2 = 1; x2 < 5; ++x2) {
                if (x2 == 4) {
                    --y;
                }
                this.placeBlockWithDir(x2, y + j, 0, leafState);
            }
        }
        return true;
    }

    public int findWater(int i, int j, int k) {
        int iPos;
        int iNeg = 0;
        int kPos = 0;
        int kNeg = 0;
        for (iPos = 0; iPos < 10 && TCGenUtils.getMaterial((IBlockAccess)this.worldObj, i + iPos, 62, k) != Material.field_151586_h; ++iPos) {
        }
        while (iNeg > -10 && TCGenUtils.getMaterial((IBlockAccess)this.worldObj, i + iNeg, 62, k) != Material.field_151586_h) {
            --iNeg;
        }
        while (kPos < 10 && TCGenUtils.getMaterial((IBlockAccess)this.worldObj, i, 62, k + kPos) != Material.field_151586_h) {
            ++kPos;
        }
        while (kNeg > -10 && TCGenUtils.getMaterial((IBlockAccess)this.worldObj, i, 62, k + kNeg) != Material.field_151586_h) {
            --kNeg;
        }
        if (iPos < Math.abs(iNeg) && iPos < kPos && iPos < Math.abs(kNeg)) {
            return 2;
        }
        if (Math.abs(iNeg) < iPos && Math.abs(iNeg) < kPos && Math.abs(iNeg) < Math.abs(kNeg)) {
            return 3;
        }
        if (kPos < Math.abs(iNeg) && kPos < iPos && kPos < Math.abs(kNeg)) {
            return 0;
        }
        if (Math.abs(kNeg) < Math.abs(iNeg) && Math.abs(kNeg) < iPos && Math.abs(kNeg) < kPos) {
            return 1;
        }
        if (iPos < 10 && iPos == Math.abs(iNeg)) {
            return this.rand.nextInt(2) + 1;
        }
        if (iPos < 10 && iPos == kPos) {
            if (this.rand.nextInt(2) + 1 == 1) {
                return 2;
            }
            return 0;
        }
        if (iPos < 10 && iPos == Math.abs(kNeg)) {
            if (this.rand.nextInt(2) + 1 == 1) {
                return 2;
            }
            return 1;
        }
        if (kPos < 10 && Math.abs(iNeg) == kPos) {
            if (this.rand.nextInt(2) + 1 == 1) {
                return 3;
            }
            return 0;
        }
        if (Math.abs(iNeg) < 10 && Math.abs(iNeg) == Math.abs(kNeg)) {
            if (this.rand.nextInt(2) + 1 == 1) {
                return 3;
            }
            return 1;
        }
        if (kPos < 10 && kPos == Math.abs(kNeg)) {
            if (this.rand.nextInt(2) + 1 == 1) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public int pickDirection(int i, int j, int k) {
        int direction = this.findWater(i, j, k);
        if (direction != -1) {
            return direction;
        }
        return this.rand.nextInt(4) + 1;
    }
}

