/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.BlockTropicraftLeaves;
import net.tropicraft.core.common.block.BlockTropicraftLog;
import net.tropicraft.core.common.enums.TropicraftLeaves;
import net.tropicraft.core.common.enums.TropicraftLogs;
import net.tropicraft.core.common.worldgen.TCGenBase;
import net.tropicraft.core.common.worldgen.TCGenUtils;
import net.tropicraft.core.registry.BlockRegistry;

public class WorldGenUpTree
extends TCGenBase {
    private static final IBlockState WOOD_STATE = BlockRegistry.logs.func_176223_P().func_177226_a(BlockTropicraftLog.VARIANT, (Comparable)((Object)TropicraftLogs.MAHOGANY));
    private static final IBlockState LEAF_STATE = BlockRegistry.leaves.func_176223_P().func_177226_a(BlockTropicraftLeaves.VARIANT, (Comparable)((Object)TropicraftLeaves.MAHOGANY));

    public WorldGenUpTree(World world, Random random) {
        super(world, random);
    }

    @Override
    public boolean generate(BlockPos pos) {
        int y;
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        Block blockUnder = TCGenUtils.getBlock((IBlockAccess)this.worldObj, pos.func_177977_b());
        if (blockUnder != Blocks.field_150349_c && blockUnder != Blocks.field_150346_d) {
            return false;
        }
        int height = this.rand.nextInt(4) + 6;
        for (y = j; y < j + height; ++y) {
            IBlockState state = TCGenUtils.getBlockState((IBlockAccess)this.worldObj, i, y, k);
            if (state.func_185904_a() != Material.field_151584_j || state.func_185914_p()) continue;
            return false;
        }
        for (y = j; y < j + height; ++y) {
            TCGenUtils.setBlockState(this.worldObj, i, y, k, WOOD_STATE, blockGenNotifyFlag);
            if (this.rand.nextInt(5) == 0) {
                int x = this.rand.nextInt(3) - 1 + i;
                int z = k;
                if (x - i == 0) {
                    z += this.rand.nextBoolean() ? 1 : -1;
                }
                TCGenUtils.setBlockState(this.worldObj, x, y, z, LEAF_STATE, blockGenNotifyFlag);
            }
            if (y != j + height - 1) continue;
            TCGenUtils.setBlockState(this.worldObj, i + 1, y, k, WOOD_STATE, blockGenNotifyFlag);
            TCGenUtils.setBlockState(this.worldObj, i - 1, y, k, WOOD_STATE, blockGenNotifyFlag);
            TCGenUtils.setBlockState(this.worldObj, i, y, k + 1, WOOD_STATE, blockGenNotifyFlag);
            TCGenUtils.setBlockState(this.worldObj, i, y, k - 1, WOOD_STATE, blockGenNotifyFlag);
        }
        int radius = this.rand.nextInt(2) + 3;
        this.genCircle(i, j + height, k, radius, 0.0, LEAF_STATE, false);
        this.genCircle(i, j + height + 1, k, radius + 2, radius, LEAF_STATE, false);
        this.genCircle(i, j + height + 2, k, radius + 3, radius + 2, LEAF_STATE, false);
        return true;
    }
}

