/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen.mapgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.tropicraft.core.common.block.BlockSeaweed;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityShark;
import net.tropicraft.core.common.enums.TropicraftCorals;
import net.tropicraft.core.common.worldgen.perlin.generator.RidgedMulti;
import net.tropicraft.core.registry.BlockRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class MapGenUndergroundWaterCove {
    private World worldObj;
    public int centerX = 0;
    public int centerZ = 0;
    public double length;
    public double width;
    public double height;
    public int y;
    public ArrayList<Pair<BlockPos, TileEntity>> pendingTileEntities = new ArrayList();
    public boolean pendingBossSpawn = true;

    public MapGenUndergroundWaterCove(World worldObj) {
        this.worldObj = worldObj;
    }

    public ChunkPrimer generate(int x, int z, ChunkPrimer primer) {
        BlockPos coveCoords = this.getCoveNear(this.worldObj, x, z);
        BlockFalling.field_149832_M = true;
        if (coveCoords != null) {
            this.centerX = coveCoords.func_177958_n();
            this.y = coveCoords.func_177956_o();
            this.centerZ = coveCoords.func_177952_p();
            x *= 16;
            z *= 16;
        } else {
            this.pendingBossSpawn = true;
            return primer;
        }
        Random rand = new Random(this.worldObj.func_72905_C() * (long)this.centerX + (long)this.centerZ * 57647382913L);
        RidgedMulti ridged = new RidgedMulti(rand.nextLong(), 1);
        ridged.frequency = 0.0325;
        this.length = rand.nextInt(20) + 30;
        this.width = rand.nextInt(20) + 30;
        this.height = rand.nextInt(3) + 5;
        this.length *= this.length;
        this.width *= this.width;
        this.height *= this.height;
        for (int blockX = 0; blockX < 16; ++blockX) {
            for (int blockZ = 0; blockZ < 16; ++blockZ) {
                int relativeX = x + blockX - this.centerX;
                int relativeZ = z + blockZ - this.centerZ;
                relativeX *= relativeX;
                relativeZ *= relativeZ;
                for (double j = -this.height; j < this.height; j += 1.0) {
                    if (!((double)relativeX / this.length + j * j / this.height + (double)relativeZ / this.width <= 1.0)) continue;
                    if (j >= -1.0) {
                        this.placeBlock(blockX, this.y + (int)j + 1, blockZ, BlockRegistry.packedPurifiedSand.func_176223_P(), primer);
                        this.placeBlock(blockX, this.y + (int)j + 2, blockZ, BlockRegistry.sands.func_176223_P(), primer);
                    }
                    this.placeBlock(blockX, this.y + (int)j, blockZ, BlockRegistry.tropicsWater.func_176223_P(), primer);
                }
                double noise1 = ridged.getNoise(x + blockX, z + blockZ);
                double noise2 = ridged.getNoise(x + blockX + 15432, z + blockZ + 42314);
                int j = (int)Math.sqrt(this.height - this.height * (double)relativeX / this.length - this.height * (double)relativeZ / this.width);
                this.placeBlock(blockX, this.y - j - 1, blockZ, BlockRegistry.sands.func_176223_P(), primer);
                this.placeBlock(blockX, this.y - j - 2, blockZ, BlockRegistry.packedPurifiedSand.func_176223_P(), primer);
                if (!(noise1 > 0.875) && !(noise2 > 0.855)) continue;
                double tunnelHeight = (8.0 - ((double)relativeX / 2500.0 + (double)relativeZ / 2500.0) * 2.0) / 3.0;
                if (tunnelHeight < 5.0) {
                    tunnelHeight = 5.0;
                }
                int j2 = 0;
                while ((double)j2 < tunnelHeight) {
                    this.placeBlock(blockX, this.y - j + j2, blockZ, BlockRegistry.tropicsWater.func_176223_P(), primer);
                    ++j2;
                }
                if (rand.nextInt(15) == 0) {
                    this.placeBlock(blockX, this.y - j, blockZ, BlockRegistry.coral.defaultForVariant(TropicraftCorals.values()[rand.nextInt(TropicraftCorals.values().length)]), primer);
                }
                if (rand.nextInt(80) == 0) {
                    this.placeBlock(blockX, this.y - j - 1, blockZ, Blocks.field_150360_v.func_176203_a(1), primer);
                }
                if (rand.nextInt(45) != 0) continue;
                this.placeBlock(blockX, this.y - j - 1, blockZ, BlockRegistry.seaweed.func_176223_P(), primer);
                this.placeBlock(blockX, this.y - j, blockZ, BlockRegistry.tropicsWater.func_176223_P(), primer);
                this.queueTE(x + blockX, this.y - j - 1, z + blockZ, new BlockSeaweed.TileSeaweed());
            }
        }
        BlockFalling.field_149832_M = false;
        return primer;
    }

    public void queueTE(int x, int y, int z, TileEntity e) {
        this.pendingTileEntities.add((Pair<BlockPos, TileEntity>)Pair.of((Object)new BlockPos(x, y, z), (Object)e));
    }

    public void decorate(int chunkX, int chunkZ) {
        if (this.pendingTileEntities.size() > 0) {
            for (int o = 0; o < this.pendingTileEntities.size(); ++o) {
                TileEntity t;
                BlockPos tepos = (BlockPos)this.pendingTileEntities.get(o).getLeft();
                if (tepos == null || (t = this.worldObj.func_175625_s(tepos)) != null) continue;
                TileEntity te = (TileEntity)this.pendingTileEntities.get(o).getRight();
                this.worldObj.func_175690_a(tepos, te);
                this.worldObj.func_175646_b(tepos, te);
                te.func_70296_d();
            }
            this.pendingTileEntities.clear();
        }
        if (!this.canGenCoveAtCoords(this.worldObj, chunkX, chunkZ)) {
            return;
        }
        if (this.pendingBossSpawn) {
            EntityShark shark = new EntityShark(this.worldObj).setBoss();
            shark.func_70107_b(this.centerX, this.y, this.centerZ);
            this.worldObj.func_72838_d((Entity)shark);
            System.out.println("shark boss spawned at " + this.centerX + " " + this.y + " " + this.centerZ);
            this.pendingBossSpawn = false;
        }
    }

    public int getHeightAt(int x, int z) {
        int relativeX = x - this.centerX;
        int relativeZ = z - this.centerZ;
        relativeX *= relativeX;
        relativeZ *= relativeZ;
        return this.y - (int)Math.sqrt(this.height - this.height * (double)relativeX / this.length - this.height * (double)relativeZ / this.width);
    }

    protected boolean canGenCoveAtCoords(World worldObj, int i, int j) {
        int numChunks = 32;
        int offsetChunks = 0;
        int oldi = i;
        int oldj = j;
        if (i < 0) {
            i -= numChunks - 1;
        }
        if (j < 0) {
            j -= numChunks - 1;
        }
        int randX = i / numChunks;
        int randZ = j / numChunks;
        long seed = (long)randX * 341832132712L + (long)randZ * 422843987541L + worldObj.func_72912_H().func_76063_b() + 42231726L;
        Random rand = new Random(seed);
        randX *= numChunks;
        randZ *= numChunks;
        return oldi == (randX += rand.nextInt(numChunks - offsetChunks)) && oldj == (randZ += rand.nextInt(numChunks - offsetChunks));
    }

    public BlockPos getCoveNear(World worldObj, int i, int j) {
        int range = 4;
        for (int x = i - range; x <= i + range; ++x) {
            for (int z = j - range; z <= j + range; ++z) {
                Random rand = new Random(worldObj.func_72905_C() * (long)x + (long)z * 57647382913L);
                if (!this.canGenCoveAtCoords(worldObj, x, z)) continue;
                return new BlockPos(x * 16 + 8, rand.nextInt(5) + 40, z * 16 + 8);
            }
        }
        return null;
    }

    private void placeBlock(int x, int y, int z, IBlockState block, ChunkPrimer primer) {
        primer.func_177855_a(x, y, z, block);
    }
}

