/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen.perlin;

import java.util.Random;

public class FishyNoise {
    int[] perm = new int[512];
    public double[][] grad2d = new double[][]{{1.0, 0.0}, {0.9239, 0.3827}, {0.707107, 0.707107}, {0.3827, 0.9239}, {0.0, 1.0}, {-0.3827, 0.9239}, {-0.707107, 0.707107}, {-0.9239, 0.3827}, {-1.0, 0.0}, {-0.9239, -0.3827}, {-0.707107, -0.707107}, {-0.3827, -0.9239}, {0.0, -1.0}, {0.3827, -0.9239}, {0.707107, -0.707107}, {0.9239, -0.3827}};
    public int[][] grad3d = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}, {1, 1, 0}, {-1, 1, 0}, {0, -1, 1}, {0, -1, -1}};

    public FishyNoise(long seed) {
        int i;
        Random rand = new Random(seed);
        for (i = 0; i < 256; ++i) {
            this.perm[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int j = rand.nextInt(256);
            this.perm[i] = this.perm[i] ^ this.perm[j];
            this.perm[j] = this.perm[i] ^ this.perm[j];
            this.perm[i] = this.perm[i] ^ this.perm[j];
        }
        for (i = 0; i < 256; ++i) {
            this.perm[i + 256] = this.perm[i];
        }
    }

    private static double lerp(double x, double y, double n) {
        return x + n * (y - x);
    }

    private static int fastFloor(double x) {
        return x > 0.0 ? (int)x : (int)x - 1;
    }

    private static double fade(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }

    private static double dot2(double[] grad2, double x, double y) {
        return grad2[0] * x + grad2[1] * y;
    }

    private static double dot3(int[] grad3, double x, double y, double z) {
        return (double)grad3[0] * x + (double)grad3[1] * y + (double)grad3[2] * z;
    }

    public double noise2d(double x, double y) {
        int largeX = FishyNoise.fastFloor(x);
        int largeY = FishyNoise.fastFloor(y);
        x -= (double)largeX;
        y -= (double)largeY;
        double u = FishyNoise.fade(x);
        double v = FishyNoise.fade(y);
        double grad00 = FishyNoise.dot2(this.grad2d[this.perm[(largeX &= 0xFF) + this.perm[largeY &= 0xFF]] & 0xF], x, y);
        double grad01 = FishyNoise.dot2(this.grad2d[this.perm[largeX + this.perm[largeY + 1]] & 0xF], x, y - 1.0);
        double grad11 = FishyNoise.dot2(this.grad2d[this.perm[largeX + 1 + this.perm[largeY + 1]] & 0xF], x - 1.0, y - 1.0);
        double grad10 = FishyNoise.dot2(this.grad2d[this.perm[largeX + 1 + this.perm[largeY]] & 0xF], x - 1.0, y);
        double lerpX0 = FishyNoise.lerp(grad00, grad10, u);
        double lerpX1 = FishyNoise.lerp(grad01, grad11, u);
        return FishyNoise.lerp(lerpX0, lerpX1, v);
    }

    public double noise3d(double x, double y, double z) {
        int unitX = FishyNoise.fastFloor(x);
        int unitY = FishyNoise.fastFloor(y);
        int unitZ = FishyNoise.fastFloor(z);
        x -= (double)unitX;
        y -= (double)unitY;
        z -= (double)unitZ;
        double u = FishyNoise.fade(x);
        double v = FishyNoise.fade(y);
        double w = FishyNoise.fade(z);
        double grad000 = FishyNoise.dot3(this.grad3d[this.perm[(unitX &= 0xFF) + this.perm[(unitY &= 0xFF) + this.perm[unitZ &= 0xFF]]] & 0xF], x, y, z);
        double grad100 = FishyNoise.dot3(this.grad3d[this.perm[unitX + 1 + this.perm[unitY + this.perm[unitZ]]] & 0xF], x - 1.0, y, z);
        double grad010 = FishyNoise.dot3(this.grad3d[this.perm[unitX + this.perm[unitY + 1 + this.perm[unitZ]]] & 0xF], x, y - 1.0, z);
        double grad110 = FishyNoise.dot3(this.grad3d[this.perm[unitX + 1 + this.perm[unitY + 1 + this.perm[unitZ]]] & 0xF], x - 1.0, y - 1.0, z);
        double grad001 = FishyNoise.dot3(this.grad3d[this.perm[unitX + this.perm[unitY + this.perm[unitZ + 1]]] & 0xF], x, y, z - 1.0);
        double grad101 = FishyNoise.dot3(this.grad3d[this.perm[unitX + 1 + this.perm[unitY + this.perm[unitZ + 1]]] & 0xF], x - 1.0, y, z - 1.0);
        double grad011 = FishyNoise.dot3(this.grad3d[this.perm[unitX + this.perm[unitY + 1 + this.perm[unitZ + 1]]] & 0xF], x, y - 1.0, z - 1.0);
        double grad111 = FishyNoise.dot3(this.grad3d[this.perm[unitX + 1 + this.perm[unitY + 1 + this.perm[unitZ + 1]]] & 0xF], x - 1.0, y - 1.0, z - 1.0);
        return FishyNoise.lerp(FishyNoise.lerp(FishyNoise.lerp(grad000, grad100, u), FishyNoise.lerp(grad010, grad110, u), v), FishyNoise.lerp(FishyNoise.lerp(grad001, grad101, u), FishyNoise.lerp(grad011, grad111, u), v), w);
    }
}

