/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.registry;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.block.BlockBambooChest;
import net.tropicraft.core.common.block.BlockBambooDoor;
import net.tropicraft.core.common.block.BlockBambooShoot;
import net.tropicraft.core.common.block.BlockBongoDrum;
import net.tropicraft.core.common.block.BlockBundle;
import net.tropicraft.core.common.block.BlockChunkOHead;
import net.tropicraft.core.common.block.BlockCoconut;
import net.tropicraft.core.common.block.BlockCoffeeBush;
import net.tropicraft.core.common.block.BlockCoral;
import net.tropicraft.core.common.block.BlockDonation;
import net.tropicraft.core.common.block.BlockDrinkMixer;
import net.tropicraft.core.common.block.BlockFruitLeaves;
import net.tropicraft.core.common.block.BlockIris;
import net.tropicraft.core.common.block.BlockPackedPurifiedSand;
import net.tropicraft.core.common.block.BlockPineapple;
import net.tropicraft.core.common.block.BlockPortalWall;
import net.tropicraft.core.common.block.BlockSeaweed;
import net.tropicraft.core.common.block.BlockSifter;
import net.tropicraft.core.common.block.BlockTikiTorch;
import net.tropicraft.core.common.block.BlockTropicraftEnumVariants;
import net.tropicraft.core.common.block.BlockTropicraftFence;
import net.tropicraft.core.common.block.BlockTropicraftFlowerPot;
import net.tropicraft.core.common.block.BlockTropicraftLadder;
import net.tropicraft.core.common.block.BlockTropicraftLeaves;
import net.tropicraft.core.common.block.BlockTropicraftLog;
import net.tropicraft.core.common.block.BlockTropicraftOre;
import net.tropicraft.core.common.block.BlockTropicraftOreBlock;
import net.tropicraft.core.common.block.BlockTropicraftPlank;
import net.tropicraft.core.common.block.BlockTropicraftSands;
import net.tropicraft.core.common.block.BlockTropicraftSlab;
import net.tropicraft.core.common.block.BlockTropicraftStairs;
import net.tropicraft.core.common.block.BlockTropicraftStairsFuzzy;
import net.tropicraft.core.common.block.BlockTropicsFlowers;
import net.tropicraft.core.common.block.BlockTropicsPortal;
import net.tropicraft.core.common.block.BlockTropicsSapling;
import net.tropicraft.core.common.block.BlockTropicsWater;
import net.tropicraft.core.common.block.BlockVolcano;
import net.tropicraft.core.common.block.scuba.BlockAirCompressor;
import net.tropicraft.core.common.enums.BlockHardnessValues;
import net.tropicraft.core.common.enums.ITropicraftVariant;
import net.tropicraft.core.common.enums.TropicraftBongos;
import net.tropicraft.core.common.enums.TropicraftBundles;
import net.tropicraft.core.common.enums.TropicraftCorals;
import net.tropicraft.core.common.enums.TropicraftFlowers;
import net.tropicraft.core.common.enums.TropicraftFruitLeaves;
import net.tropicraft.core.common.enums.TropicraftLeaves;
import net.tropicraft.core.common.enums.TropicraftLogs;
import net.tropicraft.core.common.enums.TropicraftOres;
import net.tropicraft.core.common.enums.TropicraftPlanks;
import net.tropicraft.core.common.enums.TropicraftSands;
import net.tropicraft.core.common.enums.TropicraftSaplings;
import net.tropicraft.core.common.enums.TropicraftSlabs;
import net.tropicraft.core.common.itemblock.ItemBlockTropicraft;
import net.tropicraft.core.common.itemblock.ItemTropicraftSlab;
import net.tropicraft.core.registry.CreativeTabRegistry;
import net.tropicraft.core.registry.FluidRegistry;
import net.tropicraft.core.registry.ItemRegistry;
import net.tropicraft.core.registry.TropicraftRegistry;

@Mod.EventBusSubscriber(modid="tropicraft")
public class BlockRegistry
extends TropicraftRegistry {
    public static Block chunk;
    public static BlockTropicraftEnumVariants<TropicraftOres> ore;
    public static BlockTropicraftEnumVariants<TropicraftOres> oreBlock;
    public static BlockTropicsFlowers flowers;
    public static Block logs;
    public static BlockTropicraftEnumVariants<TropicraftCorals> coral;
    public static Block seaweed;
    public static Block sands;
    public static BlockTropicraftEnumVariants<TropicraftBundles> bundles;
    public static BlockTropicraftEnumVariants<TropicraftPlanks> planks;
    public static BlockBambooShoot bambooShoot;
    public static Block chunkStairs;
    public static Block thatchStairs;
    public static Block bambooStairs;
    public static Block palmStairs;
    public static Block mahoganyStairs;
    public static Block thatchStairsFuzzy;
    public static BlockTropicsWater tropicsWater;
    public static BlockTropicsPortal tropicsPortal;
    public static BlockTropicsPortal tropicsPortalTeleporter;
    public static BlockPortalWall portalWall;
    public static Block leaves;
    public static Block fruitLeaves;
    public static Block bambooChest;
    public static Block saplings;
    public static Block coconut;
    public static Block pineapple;
    public static Block iris;
    public static BlockCoffeeBush coffeePlant;
    public static Block volcano;
    public static Block tikiTorch;
    public static Block drinkMixer;
    public static Block sifter;
    public static Block airCompressor;
    public static Block flowerPot;
    public static Block bambooDoor;
    public static BlockTropicraftSlab slabs;
    public static BlockTropicraftSlab doubleSlabs;
    public static Block bongo;
    public static Block bambooFence;
    public static Block thatchFence;
    public static Block chunkFence;
    public static Block palmFence;
    public static Block mahoganyFence;
    public static BlockFenceGate bambooFenceGate;
    public static BlockFenceGate thatchFenceGate;
    public static BlockFenceGate chunkFenceGate;
    public static BlockFenceGate palmFenceGate;
    public static BlockFenceGate mahoganyFenceGate;
    public static Block bambooLadder;
    public static Block packedPurifiedSand;
    public static Block donation;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        FluidRegistry.preInit();
        IForgeRegistry registry = event.getRegistry();
        chunk = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockChunkOHead(), "chunk");
        ore = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftOre(), "ore", new MultiBlockItemCreator(TropicraftOres.VALUES).withOredict("oreAzurite", TropicraftOres.AZURITE.getMeta()).withOredict("oreEudialyte", TropicraftOres.EUDIALYTE.getMeta()).withOredict("oreZircon", TropicraftOres.ZIRCON.getMeta()).withOredict("oreManganese", TropicraftOres.MANGANESE.getMeta()));
        oreBlock = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftOreBlock(), "oreblock", new MultiBlockItemCreator(TropicraftOres.ORES_WITH_BLOCKS){

            @Override
            public Item getItem(Block block) {
                return new ItemBlockTropicraft(block, this.variants.toArray(new ITropicraftVariant[this.variants.size()])){

                    @Override
                    public String func_77667_c(ItemStack itemstack) {
                        return super.func_77667_c(itemstack).replaceAll(TropicraftOres.AZURITE.getTypeName(), "oreblock");
                    }
                };
            }
        });
        flowers = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicsFlowers(), "flower", new StandardItemCreator(TropicraftFlowers.VALUES));
        logs = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftLog(), "log", new MultiBlockItemCreator(TropicraftLogs.values()).withOredict("logWood", Short.MAX_VALUE));
        coral = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockCoral(), "coral", new StandardItemCreator(TropicraftCorals.VALUES));
        bundles = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockBundle(Material.field_151575_d), "bundle", new StandardItemCreator(TropicraftBundles.values()).withOredict("blockThatch", TropicraftBundles.THATCH.getMeta()).withOredict("blockBamboo", TropicraftBundles.BAMBOO.getMeta()));
        seaweed = BlockRegistry.registerBlockNoItem((IForgeRegistry<Block>)registry, new BlockSeaweed(), "seaweed");
        slabs = new BlockTropicraftSlab(Material.field_151575_d, false);
        doubleSlabs = new BlockTropicraftSlab(Material.field_151575_d, true);
        SimpleItemCreator slabRegistrar = new MultiBlockItemCreator(TropicraftSlabs.VALUES){

            public ItemTropicraftSlab getItem(Block block) {
                return new ItemTropicraftSlab(block, slabs, doubleSlabs);
            }
        }.withOredict("slabWood", TropicraftSlabs.PALM.getMeta(), TropicraftSlabs.MAHOGANY.getMeta());
        slabs = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, slabs, "slab", slabRegistrar);
        doubleSlabs = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, doubleSlabs, "double_slab", slabRegistrar);
        planks = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftPlank(Material.field_151575_d), "plank", new MultiBlockItemCreator(TropicraftPlanks.VALUES).withOredict("plankWood", Short.MAX_VALUE));
        bambooShoot = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockBambooShoot(), "bamboo_shoot", new SimpleItemCreator("bamboo_shoot", false).withOredict("bamboo", 0));
        thatchStairs = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftStairs(bundles.defaultForVariant(TropicraftBundles.THATCH)), "thatch_stairs", new SimpleItemCreator("thatch_stairs", true));
        bambooStairs = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftStairs(bundles.defaultForVariant(TropicraftBundles.BAMBOO)), "bamboo_stairs", new SimpleItemCreator("bamboo_stairs", true));
        palmStairs = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftStairs(planks.defaultForVariant(TropicraftPlanks.PALM)), "palm_stairs", new SimpleItemCreator("palm_stairs", true).withOredict("stairsWood", Short.MAX_VALUE));
        chunkStairs = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftStairs(chunk.func_176223_P()), "chunk_stairs", new SimpleItemCreator("chunk_stairs", true));
        mahoganyStairs = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftStairs(planks.defaultForVariant(TropicraftPlanks.MAHOGANY)), "mahogany_stairs", new SimpleItemCreator("mahogany_stairs", true).withOredict("stairsWood", Short.MAX_VALUE));
        thatchStairsFuzzy = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftStairsFuzzy(bundles.defaultForVariant(TropicraftBundles.THATCH)), "thatch_stairs_fuzzy", new SimpleItemCreator("thatch_stairs_fuzzy", true));
        leaves = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftLeaves(), "leaves", new MultiBlockItemCreator(TropicraftLeaves.VALUES).withOredict("treeLeaves", Short.MAX_VALUE));
        fruitLeaves = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockFruitLeaves(), "leaves_fruit", new MultiBlockItemCreator(TropicraftFruitLeaves.VALUES).withOredict("treeLeaves", Short.MAX_VALUE));
        bambooChest = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockBambooChest(), "bamboo_chest");
        saplings = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicsSapling(), "sapling", new StandardItemCreator(TropicraftSaplings.VALUES).withOredict("treeSapling", Short.MAX_VALUE));
        coconut = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockCoconut(), "coconut");
        pineapple = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockPineapple(), "pineapple");
        iris = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockIris(), "iris");
        coffeePlant = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockCoffeeBush(), "coffee_bush", (ItemRegistry.IBlockItemRegistrar)null);
        sands = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftSands(), "sand", new MultiBlockItemCreator(TropicraftSands.VALUES).withOredict("sand", TropicraftSands.PURIFIED.getMeta()));
        volcano = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockVolcano(), "volcano", (ItemRegistry.IBlockItemRegistrar)null);
        tikiTorch = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTikiTorch(), "tiki_torch");
        drinkMixer = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockDrinkMixer(), "drink_mixer");
        sifter = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockSifter(), "sifter");
        airCompressor = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockAirCompressor(), "air_compressor");
        flowerPot = BlockRegistry.registerBlockNoItem((IForgeRegistry<Block>)registry, new BlockTropicraftFlowerPot(), "flower_pot");
        bambooDoor = BlockRegistry.registerBlockNoItem((IForgeRegistry<Block>)registry, new BlockBambooDoor(), "bamboo_door");
        bongo = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockBongoDrum(), "bongo", new MultiBlockItemCreator(TropicraftBongos.VALUES));
        bambooFenceGate = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, (BlockFenceGate)new BlockFenceGate(BlockPlanks.EnumType.BIRCH).func_149711_c(2.0f).func_149752_b(5.0f), "bamboo_fence_gate");
        thatchFenceGate = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, (BlockFenceGate)new BlockFenceGate(BlockPlanks.EnumType.BIRCH).func_149711_c(2.0f).func_149752_b(5.0f), "thatch_fence_gate");
        chunkFenceGate = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, (BlockFenceGate)new BlockFenceGate(BlockPlanks.EnumType.DARK_OAK).func_149711_c(2.0f).func_149752_b(30.0f), "chunk_fence_gate");
        palmFenceGate = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, (BlockFenceGate)new BlockFenceGate(BlockPlanks.EnumType.SPRUCE).func_149711_c(2.0f).func_149752_b(5.0f), "palm_fence_gate", new SimpleItemCreator("palm_fence_gate", false).withOredict("fenceGateWood", Short.MAX_VALUE));
        mahoganyFenceGate = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, (BlockFenceGate)new BlockFenceGate(BlockPlanks.EnumType.OAK).func_149711_c(2.0f).func_149752_b(5.0f), "mahogany_fence_gate", new SimpleItemCreator("mahogany_fence_gate", false).withOredict("fenceGateWood", Short.MAX_VALUE));
        bambooFence = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftFence(bambooFenceGate, Material.field_151575_d, MapColor.field_151658_d), "bamboo_fence");
        thatchFence = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftFence(thatchFenceGate, Material.field_151585_k, MapColor.field_151658_d), "thatch_fence");
        chunkFence = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftFence(chunkFenceGate, Material.field_151576_e, MapColor.field_151658_d), "chunk_fence");
        palmFence = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftFence(palmFenceGate, Material.field_151575_d, MapColor.field_151658_d), "palm_fence", new SimpleItemCreator("palm_fence", true).withOredict("fenceWood", Short.MAX_VALUE));
        mahoganyFence = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftFence(mahoganyFenceGate, Material.field_151575_d, MapColor.field_151658_d), "mahogany_fence", new SimpleItemCreator("mahogany_fence", true).withOredict("fenceWood", Short.MAX_VALUE));
        bambooLadder = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockTropicraftLadder().func_149711_c(BlockHardnessValues.BAMBOO.hardness).func_149752_b(BlockHardnessValues.BAMBOO.resistance), "bamboo_ladder");
        packedPurifiedSand = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockPackedPurifiedSand(), "packed_purified_sand");
        tropicsWater = BlockRegistry.registerBlockNoItem((IForgeRegistry<Block>)registry, new BlockTropicsWater(FluidRegistry.tropicsWater, Material.field_151586_h), "water");
        tropicsPortal = BlockRegistry.registerBlockNoItem((IForgeRegistry<Block>)registry, new BlockTropicsPortal(FluidRegistry.tropicsPortal, Material.field_151586_h, false), "portal");
        tropicsPortalTeleporter = BlockRegistry.registerBlockNoItem((IForgeRegistry<Block>)registry, new BlockTropicsPortal(FluidRegistry.tropicsPortal, Material.field_151586_h, true), "portal_teleporter");
        Tropicraft.proxy.registerFluidBlockRendering((Block)tropicsWater, "water");
        Tropicraft.proxy.registerFluidBlockRendering((Block)tropicsPortal, "portal");
        Tropicraft.proxy.registerFluidBlockRendering((Block)tropicsPortalTeleporter, "portal_teleporter");
        portalWall = BlockRegistry.registerBlockNoItem((IForgeRegistry<Block>)registry, new BlockPortalWall(), "portal_wall");
        donation = BlockRegistry.registerBlock((IForgeRegistry<Block>)registry, new BlockDonation(), "donation", new SimpleItemCreator("donation", true));
    }

    public static void init() {
        BlockRegistry.setFireInfo(leaves, 30, 60);
        BlockRegistry.setFireInfo(fruitLeaves, 30, 60);
        BlockRegistry.setFireInfo(logs, 5, 5);
        BlockRegistry.setFireInfo(mahoganyStairs, 5, 20);
        BlockRegistry.setFireInfo(palmStairs, 5, 20);
        BlockRegistry.setFireInfo(thatchFence, 30, 60);
        BlockRegistry.setFireInfo(thatchStairs, 30, 60);
        BlockRegistry.setFireInfo(thatchStairsFuzzy, 30, 60);
        BlockRegistry.setFireInfo((Block)thatchFenceGate, 30, 60);
        BlockRegistry.setFireInfo(planks, 5, 20);
        BlockRegistry.setFireInfo((Block)flowers, 60, 100);
        BlockRegistry.setFireInfo(iris, 60, 100);
        BlockRegistry.setFireInfo(pineapple, 60, 100);
    }

    private static final void setFireInfo(Block block, int encouragement, int flammability) {
        Blocks.field_150480_ab.func_180686_a(block, encouragement, flammability);
    }

    public static void clientProxyInit() {
        Tropicraft.proxy.registerColoredBlock(sands);
    }

    public static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name, ItemRegistry.IBlockItemRegistrar item, CreativeTabs tab) {
        block.func_149663_c(BlockRegistry.getNamePrefixed(name));
        block.setRegistryName(new ResourceLocation("tropicraft", name));
        registry.register(block);
        block.func_149647_a(tab);
        if (item != null) {
            ItemRegistry.addBlockItem(block, item);
        }
        return block;
    }

    public static void registerBlockVariant(Block block, String registryName, int stateMeta, String variantName) {
        Item item = Item.func_150898_a((Block)block);
        Tropicraft.proxy.registerItemVariantModel(item, registryName, stateMeta, variantName);
    }

    public static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name) {
        return BlockRegistry.registerBlock(registry, block, name, new SimpleItemCreator(name, false));
    }

    private static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name, ItemRegistry.IBlockItemRegistrar item) {
        return BlockRegistry.registerBlock(registry, block, name, item, CreativeTabRegistry.tropicraftTab);
    }

    public static <T extends Block> T registerBlockNoItem(IForgeRegistry<Block> registry, T block, String name) {
        return BlockRegistry.registerBlock(registry, block, name, (ItemRegistry.IBlockItemRegistrar)null);
    }

    public static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name, CreativeTabs tab) {
        return BlockRegistry.registerBlock(registry, block, name, new SimpleItemCreator(name, false), tab);
    }

    public static void registerOreDictWildcard(String oreDictName, Block block) {
        OreDictionary.registerOre((String)oreDictName, (ItemStack)new ItemStack(block, 1, Short.MAX_VALUE));
    }

    private static class MultiBlockItemCreator
    extends StandardItemCreator {
        public MultiBlockItemCreator(ITropicraftVariant ... names) {
            super(names);
        }

        @Override
        public void postRegister(Block block, Item item) {
            Tropicraft.proxy.registerBlockVariantModels(block, item);
            this.registerOres(item);
        }
    }

    private static class StandardItemCreator
    extends SimpleItemCreator {
        protected final List<ITropicraftVariant> variants;

        public StandardItemCreator(ITropicraftVariant ... variants) {
            super(null, false);
            this.variants = Lists.newArrayList((Object[])variants);
        }

        @Override
        public Item getItem(Block block) {
            return new ItemBlockTropicraft(block, this.variants.toArray(new ITropicraftVariant[this.variants.size()]));
        }

        private void registerVariant(Block block, Item item, String name, int meta) {
            Tropicraft.proxy.registerItemVariantModel(item, name, meta, "inventory");
        }

        @Override
        public void postRegister(Block block, Item item) {
            for (int i = 0; i < this.variants.size(); ++i) {
                this.registerVariant(block, item, this.variants.get(i).getSimpleName() + "_" + this.variants.get(i).getTypeName(), i);
            }
            this.registerOres(item);
        }
    }

    private static class SimpleItemCreator
    implements ItemRegistry.IBlockItemRegistrar {
        private final String name;
        private final boolean useBlock;
        private final Int2ObjectMap<List<String>> oredict = new Int2ObjectArrayMap();

        public SimpleItemCreator(String name, boolean useBlock) {
            this.name = name;
            this.useBlock = useBlock;
        }

        public SimpleItemCreator withOredict(String name, int ... metas) {
            for (int meta : metas) {
                ((List)this.oredict.computeIfAbsent((Object)meta, ArrayList::new)).add(name);
            }
            return this;
        }

        @Override
        public Item getItem(Block block) {
            return new ItemBlockTropicraft(block, new ITropicraftVariant[0]);
        }

        protected final void registerOres(Item item) {
            this.oredict.forEach((meta, names) -> names.forEach(name -> OreDictionary.registerOre((String)name, (ItemStack)new ItemStack(item, 1, meta.intValue()))));
        }

        @Override
        public void postRegister(Block block, Item item) {
            if (this.useBlock) {
                Tropicraft.proxy.registerBlockVariantModel(block.func_176223_P(), item, 0);
            } else {
                Tropicraft.proxy.registerItemVariantModel(item, this.name, 0, "inventory");
            }
            this.registerOres(item);
        }
    }
}

