/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.tropicraft.core.common.drinks.Ingredient;
import net.tropicraft.core.common.drinks.MixerRecipe;
import net.tropicraft.core.common.item.ItemCocktail;
import net.tropicraft.core.registry.ItemRegistry;
import net.tropicraft.core.registry.TropicraftRegistry;

public class DrinkMixerRegistry
extends TropicraftRegistry {
    private static List<MixerRecipe> recipes = new LinkedList<MixerRecipe>();

    public static void registerRecipe(MixerRecipe recipe) {
        recipes.add(recipe);
    }

    public static boolean isRegisteredIngredient(ItemStack item) {
        if (item.func_77973_b() == ItemRegistry.cocktail) {
            return true;
        }
        for (MixerRecipe recipe : recipes) {
            for (Ingredient i : recipe.getIngredients()) {
                if (!ItemStack.func_77989_b((ItemStack)i.getIngredient(), (ItemStack)item)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRegisteredIngredient(@Nonnull Item item) {
        return DrinkMixerRegistry.isRegisteredIngredient(new ItemStack(item, 1, 0));
    }

    @Nonnull
    public static ItemStack getResult(NonNullList<ItemStack> ingredients) {
        for (MixerRecipe recipe : recipes) {
            int validIngredientsFound = 0;
            block1: for (Ingredient recipeIngredient : recipe.getIngredients()) {
                for (ItemStack mixerIngredient : ingredients) {
                    if (!ItemStack.func_77989_b((ItemStack)recipeIngredient.getIngredient(), (ItemStack)mixerIngredient)) continue;
                    ++validIngredientsFound;
                    continue block1;
                }
            }
            if ((long)validIngredientsFound != ingredients.stream().filter(i -> !i.func_190926_b()).count()) continue;
            return ItemCocktail.makeCocktail(recipe);
        }
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        for (ItemStack ingredientStack : ingredients) {
            is.addAll(Ingredient.listIngredients(ingredientStack));
        }
        Collections.sort(is);
        return ItemCocktail.makeCocktail(is.toArray(new Ingredient[is.size()]));
    }

    public static List<MixerRecipe> getRecipes() {
        return recipes;
    }
}

