/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.registry;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.tropicraft.core.common.sound.TropicraftSounds;

public class SoundRegistry {
    private static List<String> registeredSounds = new ArrayList<String>();

    public static void init() {
        for (Field f : TropicraftSounds.class.getDeclaredFields()) {
            if (!f.isAnnotationPresent(SoundName.class)) continue;
            try {
                f.set(null, SoundRegistry.register(f.getAnnotation(SoundName.class).value()));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    private static SoundEvent register(String soundPath) {
        ResourceLocation resLoc = new ResourceLocation("tropicraft", soundPath);
        SoundEvent event = new SoundEvent(resLoc);
        ForgeRegistries.SOUND_EVENTS.register(event.setRegistryName(resLoc));
        if (registeredSounds.contains(soundPath)) {
            System.out.println("TCWARNING: duplicate sound registration for " + soundPath);
        }
        registeredSounds.add(soundPath);
        return event;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SoundName {
        public String value();
    }
}

