/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.common;

import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.fluids.FluidEffectRegistry;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.inventory.InventoryBackpack;
import com.darkona.adventurebackpack.inventory.InventorySteamJetpack;
import com.darkona.adventurebackpack.item.ItemCopterPack;
import com.darkona.adventurebackpack.item.ItemHose;
import com.darkona.adventurebackpack.network.WearableModePacket;
import com.darkona.adventurebackpack.network.messages.EntitySoundPacket;
import com.darkona.adventurebackpack.reference.BackpackNames;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.Wearing;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ServerActions {
    public static final boolean HOSE_SWITCH = false;
    public static final boolean HOSE_TOGGLE = true;

    public static void cycleTool(EntityPlayer player, int direction, int slot) {
        try {
            InventoryBackpack backpack = Wearing.getBackpackInv(player, true);
            ItemStack current = player.func_71045_bC();
            backpack.func_70295_k_();
            if (direction < 0) {
                player.field_71071_by.field_70462_a[slot] = backpack.func_70301_a(39);
                backpack.setInventorySlotContentsNoSave(39, backpack.func_70301_a(40));
                backpack.setInventorySlotContentsNoSave(40, current);
            } else if (direction > 0) {
                player.field_71071_by.field_70462_a[slot] = backpack.func_70301_a(40);
                backpack.setInventorySlotContentsNoSave(40, backpack.func_70301_a(39));
                backpack.setInventorySlotContentsNoSave(39, current);
            }
            backpack.func_70296_d();
            player.field_71071_by.func_70305_f();
        }
        catch (Exception oops) {
            LogHelper.debug("Exception trying to cycle tools.");
            oops.printStackTrace();
        }
    }

    public static boolean setFluidEffect(World world, EntityPlayer player, FluidTank tank) {
        FluidStack drained = tank.drain(1000, false);
        boolean done = false;
        if (drained != null && drained.amount >= 1000 && FluidEffectRegistry.hasFluidEffect(drained.getFluid())) {
            done = FluidEffectRegistry.executeFluidEffectsForFluid(drained.getFluid(), (Entity)player, world);
        }
        return done;
    }

    public static void switchHose(EntityPlayer player, boolean action, int direction, int slot) {
        ItemStack hose = player.field_71071_by.field_70462_a[slot];
        if (hose != null && hose.func_77973_b() instanceof ItemHose) {
            NBTTagCompound tag;
            NBTTagCompound nBTTagCompound = tag = hose.func_77942_o() ? hose.field_77990_d : new NBTTagCompound();
            if (!action) {
                int mode = ItemHose.getHoseMode(hose);
                if (direction > 0) {
                    mode = (mode + 1) % 3;
                } else if (direction < 0) {
                    mode = mode - 1 < 0 ? 2 : mode - 1;
                }
                tag.func_74768_a("mode", mode);
            }
            if (action) {
                int tank = ItemHose.getHoseTank(hose);
                tank = (tank + 1) % 2;
                tag.func_74768_a("tank", tank);
            }
            hose.func_77982_d(tag);
        }
    }

    public static void electrify(EntityPlayer player) {
        ItemStack backpack = Wearing.getWearingBackpack(player);
        if (BackpackNames.getBackpackColorName(backpack).equals("Pig")) {
            BackpackNames.setBackpackColorName(backpack, "Pigman");
        }
        if (BackpackNames.getBackpackColorName(backpack).equals("Diamond")) {
            BackpackNames.setBackpackColorName(backpack, "Electric");
        }
    }

    public static void leakArrow(EntityPlayer player, ItemStack bow, int charge) {
        boolean flag;
        World world = player.field_70170_p;
        Random itemRand = new Random();
        InventoryBackpack backpack = new InventoryBackpack(Wearing.getWearingBackpack(player));
        boolean bl = flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)bow) > 0;
        if (flag || backpack.hasItem(Items.field_151032_g)) {
            int punch;
            int power;
            float f = (float)charge / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityArrow entityarrow = new EntityArrow(world, (EntityLivingBase)player, f * 2.0f);
            if (f == 1.0f) {
                entityarrow.func_70243_d(true);
            }
            if ((power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)bow)) > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)power * 0.5 + 0.5);
            }
            if ((punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)bow)) > 0) {
                entityarrow.func_70240_a(punch);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)bow) > 0) {
                entityarrow.func_70015_d(100);
            }
            bow.func_77972_a(1, (EntityLivingBase)player);
            world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (flag) {
                entityarrow.field_70251_a = 2;
            } else {
                backpack.consumeInventoryItem(Items.field_151032_g);
                backpack.dirtyInventory();
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityarrow);
            }
        }
    }

    public static void toggleSleepingBag(EntityPlayer player, int coordX, int coordY, int coordZ) {
        World world = player.field_70170_p;
        if (world.func_147438_o(coordX, coordY, coordZ) instanceof TileAdventureBackpack) {
            TileAdventureBackpack te = (TileAdventureBackpack)world.func_147438_o(coordX, coordY, coordZ);
            if (!te.isSBDeployed()) {
                int[] can = ServerActions.canDeploySleepingBag(world, coordX, coordY, coordZ);
                if (can[0] > -1) {
                    if (te.deploySleepingBag(player, world, can[1], can[2], can[3], can[0])) {
                        player.func_71053_j();
                    }
                } else if (world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Can't deploy the sleeping bag! Check the surrounding area."));
                }
            } else {
                te.removeSleepingBag(world);
            }
            player.func_71053_j();
        }
    }

    public static int[] canDeploySleepingBag(World world, int coordX, int coordY, int coordZ) {
        TileAdventureBackpack te = (TileAdventureBackpack)world.func_147438_o(coordX, coordY, coordZ);
        int newMeta = -1;
        if (!te.isSBDeployed()) {
            int meta = world.func_72805_g(coordX, coordY, coordZ);
            switch (meta & 3) {
                case 0: {
                    if (!world.func_147437_c(coordX, coordY, --coordZ) || !world.func_147439_a(coordX, coordY - 1, coordZ).func_149688_o().func_76220_a() || !world.func_147437_c(coordX, coordY, coordZ - 1) || !world.func_147439_a(coordX, coordY - 1, coordZ - 1).func_149688_o().func_76220_a()) break;
                    newMeta = 2;
                    break;
                }
                case 1: {
                    if (!world.func_147437_c(++coordX, coordY, coordZ) || !world.func_147439_a(coordX, coordY - 1, coordZ).func_149688_o().func_76220_a() || !world.func_147437_c(coordX + 1, coordY, coordZ) || !world.func_147439_a(coordX + 1, coordY - 1, coordZ).func_149688_o().func_76220_a()) break;
                    newMeta = 3;
                    break;
                }
                case 2: {
                    if (!world.func_147437_c(coordX, coordY, ++coordZ) || !world.func_147439_a(coordX, coordY - 1, coordZ).func_149688_o().func_76220_a() || !world.func_147437_c(coordX, coordY, coordZ + 1) || !world.func_147439_a(coordX, coordY - 1, coordZ + 1).func_149688_o().func_76220_a()) break;
                    newMeta = 0;
                    break;
                }
                case 3: {
                    if (!world.func_147437_c(--coordX, coordY, coordZ) || !world.func_147439_a(coordX, coordY - 1, coordZ).func_149688_o().func_76220_a() || !world.func_147437_c(coordX - 1, coordY, coordZ) || !world.func_147439_a(coordX - 1, coordY - 1, coordZ).func_149688_o().func_76220_a()) break;
                    newMeta = 1;
                    break;
                }
            }
        }
        int[] result = new int[]{newMeta, coordX, coordY, coordZ};
        return result;
    }

    public static void pistonBootsJump(EntityPlayer player) {
        player.func_85030_a("tile.piston.out", 0.5f, player.func_70681_au().nextFloat() * 0.25f + 0.6f);
        player.field_70181_x += 0.3;
        player.field_70747_aH = (float)((double)player.field_70747_aH + 0.3);
    }

    public static void toggleCopterPack(EntityPlayer player, ItemStack copter, byte type) {
        String message = "";
        boolean actionPerformed = false;
        if (!copter.func_77942_o()) {
            copter.field_77990_d = new NBTTagCompound();
        }
        if (!copter.field_77990_d.func_74764_b("status")) {
            copter.field_77990_d.func_74774_a("status", ItemCopterPack.OFF_MODE);
        }
        byte mode = copter.field_77990_d.func_74771_c("status");
        byte newMode = ItemCopterPack.OFF_MODE;
        if (type == WearableModePacket.COPTER_ON_OFF) {
            if (mode == ItemCopterPack.OFF_MODE) {
                newMode = ItemCopterPack.NORMAL_MODE;
                message = "adventurebackpack:messages.copterpack.normal";
                actionPerformed = true;
                if (!player.field_70170_p.field_72995_K) {
                    ModNetwork.sendToNearby(new EntitySoundPacket.Message(1, (Entity)player), player);
                }
            } else {
                newMode = ItemCopterPack.OFF_MODE;
                message = "adventurebackpack:messages.copterpack.off";
                actionPerformed = true;
            }
        }
        if (type == WearableModePacket.COPTER_TOGGLE && mode != ItemCopterPack.OFF_MODE) {
            if (mode == ItemCopterPack.NORMAL_MODE) {
                newMode = ItemCopterPack.HOVER_MODE;
                message = "adventurebackpack:messages.copterpack.hover";
                actionPerformed = true;
            }
            if (mode == ItemCopterPack.HOVER_MODE) {
                newMode = ItemCopterPack.NORMAL_MODE;
                message = "adventurebackpack:messages.copterpack.normal";
                actionPerformed = true;
            }
        }
        if (actionPerformed) {
            copter.field_77990_d.func_74774_a("status", newMode);
            if (player.field_70170_p.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
            }
        }
    }

    public static void toggleSteamJetpack(EntityPlayer player, ItemStack jetpack, byte on_off) {
        InventorySteamJetpack inv = new InventorySteamJetpack(jetpack);
        if (inv.getStatus()) {
            inv.setStatus(false);
            inv.func_70296_d();
            if (player.field_70170_p.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.jetpack.off", new Object[0]));
            }
        } else {
            inv.setStatus(true);
            inv.func_70296_d();
            if (player.field_70170_p.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.jetpack.on", new Object[0]));
            }
        }
    }
}

