/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static Configuration config;
    public static boolean IS_BUILDCRAFT;
    public static boolean IS_BAUBLES;
    public static boolean IS_TINKERS;
    public static boolean IS_THAUM;
    public static boolean IS_TWILIGHT;
    public static boolean IS_ENVIROMINE;
    public static boolean IS_RAILCRAFT;
    public static int GUI_TANK_RENDER;
    public static boolean BONUS_CHEST_ALLOWED;
    public static boolean PIGMAN_ALLOWED;
    public static boolean BACKPACK_DEATH_PLACE;
    public static boolean BACKPACK_ABILITIES;
    public static boolean ALLOW_COPTER_SOUND;
    public static boolean ALLOW_JETPACK_SOUNDS;
    public static boolean STATUS_OVERLAY;
    public static boolean TANKS_OVERLAY;
    public static boolean HOVERING_TEXT_TANKS;
    public static boolean SADDLE_RECIPE;
    public static boolean FIX_LEAD;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        GUI_TANK_RENDER = config.getInt("TankRenderType", "general", 3, 1, 3, "1,2 or 3 for different rendering of fluids in the Backpack GUI");
        BONUS_CHEST_ALLOWED = config.getBoolean("BonusBackpack", "general", false, "Include a Standard Adventure Backpack in bonus chest?");
        PIGMAN_ALLOWED = config.getBoolean("PigmanBackpacks", "general", false, "Allow generation of Pigman Backpacks in dungeon loot and villager trades");
        ALLOW_COPTER_SOUND = config.getBoolean("CopterPackSound", "general", true, "Allow playing the CopterPack sound (Client Only, other players may hear it)");
        BACKPACK_ABILITIES = config.getBoolean("BackpackAbilities", "general", true, "Allow the backpacks to execute their special abilities, or be only cosmetic (Doesn't affect lightning transformation) Must be disabled in both Client and Server to work properly");
        STATUS_OVERLAY = config.getBoolean("StatusOverlay", "general", true, "Show player status effects on screen?");
        TANKS_OVERLAY = config.getBoolean("BackpackOverlay", "general", true, "Show the different wearable overlays on screen?");
        HOVERING_TEXT_TANKS = config.getBoolean("HoveringText", "general", false, "Show hovering text on fluid tanks?");
        FIX_LEAD = config.getBoolean("FixVanillaLead", "general", true, "Fix the vanilla Lead? (Checks mobs falling on a leash to not die of fall damage if they're not falling so fast)");
        BACKPACK_DEATH_PLACE = config.getBoolean("BackpackDeathPlace", "general", true, "Place backpacks as a block when you die?");
        SADDLE_RECIPE = config.getBoolean("SaddleRecipe", "general", true, "Add recipe for saddle?");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChangeEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("adventurebackpack")) {
            ConfigHandler.loadConfiguration();
        }
    }

    static {
        IS_BUILDCRAFT = false;
        IS_BAUBLES = false;
        IS_TINKERS = false;
        IS_THAUM = false;
        IS_TWILIGHT = false;
        IS_ENVIROMINE = false;
        IS_RAILCRAFT = false;
        GUI_TANK_RENDER = 2;
        BONUS_CHEST_ALLOWED = false;
        PIGMAN_ALLOWED = false;
        BACKPACK_DEATH_PLACE = true;
        BACKPACK_ABILITIES = true;
        ALLOW_COPTER_SOUND = true;
        ALLOW_JETPACK_SOUNDS = true;
        STATUS_OVERLAY = true;
        TANKS_OVERLAY = true;
        HOVERING_TEXT_TANKS = false;
        SADDLE_RECIPE = true;
        FIX_LEAD = true;
    }
}

